/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import org.jledit.Editor;
import org.jledit.utils.Files;
import org.jledit.utils.internal.Charsets;

public class StringEditor
implements Editor<String> {
    private File file;
    private Charset charset = Charset.defaultCharset();
    private int line = 1;
    private int column = 1;
    private Boolean dirty = false;
    private final LinkedList<String> lines = new LinkedList();

    public StringEditor() {
        this.lines.add("");
    }

    public StringEditor(String content) {
        String[] contentLines = content.split("\n|\r");
        this.lines.addAll(Arrays.asList(contentLines));
    }

    @Override
    public synchronized int getLine() {
        return this.line;
    }

    @Override
    public synchronized int getColumn() {
        return this.column;
    }

    @Override
    public synchronized void move(int line, int column) {
        String targetLine;
        this.column = this.lines() < line ? 1 : ((targetLine = this.lines.get(line - 1)).length() < column ? targetLine.length() + 1 : column);
        this.line = line;
    }

    @Override
    public synchronized void home() {
        this.move(this.line, 1);
    }

    @Override
    public synchronized void end() {
        this.move(this.line, this.getContent(this.line).length());
    }

    @Override
    public synchronized void put(String str) {
        while (this.lines() < this.line) {
            this.lines.add("");
        }
        String currentLine = this.lines.remove(this.line - 1);
        String beforePut = currentLine.substring(0, this.column - 1);
        String afterPut = this.column - 1 < currentLine.length() ? currentLine.substring(this.column - 1) : "";
        String[] modifiedContent = (beforePut + str + afterPut).split("\n|\r");
        if (modifiedContent.length == 1) {
            this.lines.add(this.line - 1, modifiedContent[0]);
            this.column += str.length();
        } else {
            String lastLine = null;
            for (String l : modifiedContent) {
                this.lines.add(this.line++ - 1, l);
                lastLine = l;
            }
            this.column = lastLine.length() - afterPut.length();
        }
    }

    @Override
    public synchronized String delete() {
        if (this.lines() < this.line) {
            this.column = 1;
            return "\n";
        }
        String currentLine = this.lines.remove(this.line - 1);
        if (this.column - 1 == currentLine.length()) {
            String nextLine = "";
            if (this.lines() >= this.line) {
                nextLine = this.lines.remove(this.line - 1);
            }
            this.lines.add(this.line - 1, currentLine + nextLine);
            return "\n";
        }
        if (this.column - 1 < currentLine.length()) {
            String deleted = currentLine.substring(this.column - 1, this.column);
            this.lines.add(this.line - 1, currentLine.substring(0, this.column - 1) + currentLine.substring(this.column));
            return deleted;
        }
        return "\n";
    }

    @Override
    public synchronized String backspace() {
        if (this.line == 1 && this.column == 1) {
            return "";
        }
        if (this.lines() < this.line) {
            return "";
        }
        if (this.column == 1) {
            String currentLine = this.lines.remove(this.line - 1);
            String previousLine = this.lines.remove(this.line - 2);
            this.lines.add(this.line - 2, previousLine + currentLine);
            --this.line;
            this.column = previousLine.length();
            return "\n";
        }
        String currentLine = this.lines.remove(this.line - 1);
        String deleted = currentLine.substring(this.column - 2, this.column - 1);
        this.lines.add(this.line - 1, currentLine.substring(0, this.column - 2) + currentLine.substring(this.column - 1));
        --this.column;
        return deleted;
    }

    @Override
    public synchronized void newLine() {
        while (this.lines() < this.line) {
            this.lines.add("");
        }
        if (this.column == 1) {
            this.lines.add(this.line - 1, "");
        } else {
            String currentLine = this.lines.remove(this.line - 1);
            String beforeNewLine = currentLine.substring(0, this.column - 1);
            String afterNewLine = currentLine.substring(this.column - 1);
            this.lines.add(this.line - 1, afterNewLine);
            this.lines.add(this.line - 1, beforeNewLine);
        }
        ++this.line;
        this.column = 1;
    }

    @Override
    public synchronized void mergeLine() {
        if (this.line < this.lines.size()) {
            String currentLine = this.lines.remove(this.line - 1);
            String nextLine = this.lines.remove(this.line - 1);
            this.lines.add(this.line - 1, currentLine + nextLine);
        }
    }

    @Override
    public synchronized void findNext(String str) {
        boolean found = false;
        int startLine = this.line;
        int startColumn = this.column + 1;
        while (!found && startLine <= this.lines.size()) {
            String linePart;
            String currentLine = this.getContent(startLine);
            String string = linePart = currentLine.length() > startColumn ? currentLine.substring(startColumn - 1) : "";
            if (linePart.contains(str)) {
                this.column = startColumn + linePart.indexOf(str);
                this.line = startLine;
                found = true;
                continue;
            }
            ++startLine;
            startColumn = 1;
        }
    }

    @Override
    public synchronized int lines() {
        return this.lines.size();
    }

    @Override
    public synchronized void findPrevious(String str) {
        boolean found = false;
        int startLine = this.line;
        int startColumn = this.column;
        while (!found && startLine > 0) {
            String currentLine = this.getContent(startLine);
            String linePart = currentLine.substring(0, startColumn - 1);
            if (linePart.contains(str)) {
                this.column = linePart.indexOf(str, 0) + 1;
                this.line = startLine;
                found = true;
                continue;
            }
            currentLine = this.getContent(--startLine);
            startColumn = currentLine.length() + 1;
        }
    }

    @Override
    public synchronized void open(File source) throws IOException {
        this.file = source;
        this.charset = Charsets.detect(source);
        this.lines.clear();
        if (source.exists()) {
            String[] contentLines = Files.toString(source, this.charset).split("\n|\r");
            this.lines.addAll(Arrays.asList(contentLines));
        }
        this.line = 1;
        this.column = 1;
    }

    @Override
    public synchronized void save(File target) throws IOException {
        if (target != null) {
            this.file = target;
        }
        if (this.file == null) {
            throw new IOException("No file specified for saving.");
        }
        Files.writeToFile(this.file, this.getContent(), this.charset);
    }

    @Override
    public synchronized void close() throws IOException {
        this.file = null;
        this.charset = null;
        this.lines.clear();
    }

    @Override
    public synchronized String getContent() {
        StringBuilder contentBuilder = new StringBuilder();
        for (String l : this.lines) {
            contentBuilder.append(l).append("\n");
        }
        return contentBuilder.toString();
    }

    @Override
    public String getContent(int line) {
        if (line <= this.lines.size()) {
            return this.lines.get(line - 1);
        }
        return "";
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(Boolean dirty) {
        this.dirty = dirty;
    }
}

