/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.utils;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class FortunaGenerator
implements RandomGenerator {
    private static final int SEED_FILE_SIZE = 64;
    private static final int NUM_POOLS = 32;
    private static final int MIN_POOL_SIZE = 64;
    private final Generator generator = new Generator((BlockCipher)new AESEngine(), (Digest)new SHA256Digest());
    private final Digest[] pools = new Digest[32];
    private long lastReseed = 0L;
    private int pool = 0;
    private int pool0Count = 0;
    private int reseedCount = 0;
    private boolean initialized = false;
    private byte[] buffer;
    protected int ndx = 0;

    public FortunaGenerator() {
        this(null);
    }

    public FortunaGenerator(byte[] seed) {
        for (int i = 0; i < 32; ++i) {
            this.pools[i] = new SHA256Digest();
        }
        this.buffer = new byte[256];
        if (seed != null) {
            this.generator.init(seed);
            this.fillBlock();
            this.initialized = true;
        }
    }

    private void fillBlock() {
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            long powerOfTwo = 1L;
            ++this.reseedCount;
            byte[] randomBytes = new byte[this.pools[0].getDigestSize()];
            for (int i = 0; i < 32 && (i == 0 || (long)this.reseedCount % powerOfTwo == 0L); ++i) {
                this.pools[i].doFinal(randomBytes, 0);
                this.generator.addRandomBytes(randomBytes, 0, randomBytes.length);
                powerOfTwo <<= 1;
            }
            this.lastReseed = System.currentTimeMillis();
            this.pool0Count = 0;
        }
        this.generator.nextBytes(this.buffer, 0, this.buffer.length);
    }

    public void nextBytes(byte[] out) {
        this.nextBytes(out, 0, out.length);
    }

    public void nextBytes(byte[] out, int offset, int length) {
        if (!this.initialized) {
            throw new IllegalStateException(" Fortuna generator not initialized/seeded");
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || length < 0 || offset + length > out.length) {
            throw new ArrayIndexOutOfBoundsException("offset=" + offset + " length=" + length + " limit=" + out.length);
        }
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        int count = 0;
        while (count < length) {
            int amount = Math.min(this.buffer.length - this.ndx, length - count);
            System.arraycopy(this.buffer, this.ndx, out, offset + count, amount);
            count += amount;
            this.ndx += amount;
            if (this.ndx < this.buffer.length) continue;
            this.fillBlock();
            this.ndx = 0;
        }
    }

    public void addSeedMaterial(long b) {
        this.pools[this.pool].update((byte)(b & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 8 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 16 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 24 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 32 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 40 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 48 & 0xFFL));
        this.pools[this.pool].update((byte)(b >> 56 & 0xFFL));
        if (this.pool == 0) {
            this.pool0Count += 8;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addSeedMaterial(byte[] buf) {
        this.addSeedMaterial(buf, 0, buf.length);
    }

    public void addSeedMaterial(byte[] buf, int offset, int length) {
        this.pools[this.pool].update(buf, offset, length);
        if (this.pool == 0) {
            this.pool0Count += buf.length;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addSeedMaterial(int poolNumber, byte[] data, int offset, int length) {
        if (poolNumber < 0 || poolNumber >= this.pools.length) {
            throw new IllegalArgumentException("pool number out of range: " + poolNumber);
        }
        this.pools[poolNumber].update((byte)length);
        this.pools[poolNumber].update(data, offset, length);
        if (poolNumber == 0) {
            this.pool0Count += length;
        }
    }

    public byte[] getSeedStatus() {
        byte[] seed = new byte[64];
        this.generator.nextBytes(seed, 0, seed.length);
        return seed;
    }

    public void setSeedStatus(byte[] seedStatus) {
        this.generator.init(seedStatus);
        this.fillBlock();
        this.initialized = true;
    }

    private static class Generator {
        private static final int LIMIT = 0x100000;
        private final BlockCipher cipher;
        private final Digest hash;
        private final byte[] counter;
        private final byte[] key;
        private byte[] buffer;
        protected int ndx = 0;

        private Generator(BlockCipher cipher, Digest hash) {
            this.cipher = cipher;
            this.hash = hash;
            this.counter = new byte[cipher.getBlockSize()];
            this.buffer = new byte[cipher.getBlockSize()];
            this.key = new byte[32];
        }

        private void nextBytes(byte[] out, int offset, int length) {
            int count = 0;
            do {
                int amount = Math.min(0x100000, length - count);
                this.nextBytesInternal(out, offset + count, amount);
                count += amount;
                for (int i = 0; i < this.key.length; i += this.counter.length) {
                    this.fillBlock();
                    int l = Math.min(this.key.length - i, this.cipher.getBlockSize());
                    System.arraycopy(this.buffer, 0, this.key, i, l);
                }
                this.resetKey();
            } while (count < length);
            this.fillBlock();
            this.ndx = 0;
        }

        private void addRandomBytes(byte[] seed, int offset, int length) {
            this.hash.update(this.key, 0, this.key.length);
            this.hash.update(seed, offset, length);
            byte[] newkey = new byte[this.hash.getDigestSize()];
            this.hash.doFinal(newkey, 0);
            System.arraycopy(newkey, 0, this.key, 0, Math.min(this.key.length, newkey.length));
            this.resetKey();
            this.incrementCounter();
        }

        private void fillBlock() {
            this.cipher.processBlock(this.counter, 0, this.buffer, 0);
            this.incrementCounter();
        }

        private void init(byte[] seed) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.counter, (byte)0);
            if (seed != null) {
                this.addRandomBytes(seed, 0, seed.length);
            }
            this.fillBlock();
        }

        private void nextBytesInternal(byte[] out, int offset, int length) {
            if (length == 0) {
                return;
            }
            if (offset < 0 || length < 0 || offset + length > out.length) {
                throw new ArrayIndexOutOfBoundsException("offset=" + offset + " length=" + length + " limit=" + out.length);
            }
            if (this.ndx >= this.buffer.length) {
                this.fillBlock();
                this.ndx = 0;
            }
            int count = 0;
            while (count < length) {
                int amount = Math.min(this.buffer.length - this.ndx, length - count);
                System.arraycopy(this.buffer, this.ndx, out, offset + count, amount);
                count += amount;
                this.ndx += amount;
                if (this.ndx < this.buffer.length) continue;
                this.fillBlock();
                this.ndx = 0;
            }
        }

        private void resetKey() {
            this.cipher.reset();
            this.cipher.init(true, (CipherParameters)new KeyParameter(this.key));
        }

        private void incrementCounter() {
            for (int i = 0; i < this.counter.length; ++i) {
                int n = i;
                this.counter[n] = (byte)(this.counter[n] + 1);
                if (this.counter[i] != 0) break;
            }
        }
    }
}

