/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp;

import gnu.java.zrtp.ZrtpConstants;
import java.util.ArrayList;
import java.util.Iterator;

public class ZrtpConfigure {
    public static final int STANDARD = 1;
    public static final int PREFER_NON_NIST = 2;
    private Data<ZrtpConstants.SupportedHashes> hashes = new Data();
    private Data<ZrtpConstants.SupportedSymCiphers> symCiphers = new Data();
    private Data<ZrtpConstants.SupportedPubKeys> publicKeyAlgos = new Data();
    private Data<ZrtpConstants.SupportedSASTypes> sasTypes = new Data();
    private Data<ZrtpConstants.SupportedAuthLengths> authLengths = new Data();
    private boolean enableTrustedMitM = false;
    private boolean enableSasSignature = false;
    private boolean enableParanoidMode = false;
    private int policy = 1;

    public void setStandardConfig() {
        this.clear();
        this.hashes.addAlgo(ZrtpConstants.SupportedHashes.S384);
        this.hashes.addAlgo(ZrtpConstants.SupportedHashes.S256);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.TWO3);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.AES3);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.TWO1);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.AES1);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.EC25);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.DH3K);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.EC38);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.DH2K);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.MULT);
        this.sasTypes.addAlgo(ZrtpConstants.SupportedSASTypes.B32);
        this.sasTypes.addAlgo(ZrtpConstants.SupportedSASTypes.B256);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.SK32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.SK64);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS80);
    }

    public void setMobileConfig() {
        this.clear();
        this.hashes.addAlgo(ZrtpConstants.SupportedHashes.S256);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.TWO1);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.AES1);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.EC25);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.DH2K);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.MULT);
        this.sasTypes.addAlgo(ZrtpConstants.SupportedSASTypes.B32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.SK32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.SK64);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS80);
    }

    public void setMandatoryOnly() {
        this.clear();
        this.hashes.addAlgo(ZrtpConstants.SupportedHashes.S256);
        this.symCiphers.addAlgo(ZrtpConstants.SupportedSymCiphers.AES1);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.DH3K);
        this.publicKeyAlgos.addAlgo(ZrtpConstants.SupportedPubKeys.MULT);
        this.sasTypes.addAlgo(ZrtpConstants.SupportedSASTypes.B32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS32);
        this.authLengths.addAlgo(ZrtpConstants.SupportedAuthLengths.HS80);
    }

    public void clear() {
        this.hashes.clear();
        this.symCiphers.clear();
        this.publicKeyAlgos.clear();
        this.sasTypes.clear();
        this.authLengths.clear();
    }

    public void setTrustedMitM(boolean yesNo) {
        this.enableTrustedMitM = yesNo;
    }

    public boolean isTrustedMitM() {
        return this.enableTrustedMitM;
    }

    public void setSasSignature(boolean yesNo) {
        this.enableSasSignature = yesNo;
    }

    public boolean isSasSignature() {
        return this.enableSasSignature;
    }

    public void setParanoidMode(boolean yesNo) {
        this.enableParanoidMode = yesNo;
    }

    public boolean isParanoidMode() {
        return this.enableParanoidMode;
    }

    public int addHashAlgo(ZrtpConstants.SupportedHashes algo) {
        return this.hashes.addAlgo(algo);
    }

    public int addHashAlgoAt(int index, ZrtpConstants.SupportedHashes algo) {
        return this.hashes.addAlgoAt(index, algo);
    }

    public int removeHashAlgo(ZrtpConstants.SupportedHashes algo) {
        return this.hashes.removeAlgo(algo);
    }

    public int getNumConfiguredHashes() {
        return this.hashes.getNumConfiguredAlgos();
    }

    public ZrtpConstants.SupportedHashes getHashAlgoAt(int index) {
        try {
            return this.hashes.getAlgoAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Iterable<ZrtpConstants.SupportedHashes> hashes() {
        return this.hashes;
    }

    public boolean containsHashAlgo(ZrtpConstants.SupportedHashes hash) {
        return this.hashes.containsAlgo(hash);
    }

    public int addSymCipherAlgo(ZrtpConstants.SupportedSymCiphers algo) {
        return this.symCiphers.addAlgo(algo);
    }

    public int addSymCipherAlgoAt(int index, ZrtpConstants.SupportedSymCiphers algo) {
        return this.symCiphers.addAlgoAt(index, algo);
    }

    public int removeSymCipherAlgo(ZrtpConstants.SupportedSymCiphers algo) {
        return this.symCiphers.removeAlgo(algo);
    }

    public int getNumConfiguredSymCiphers() {
        return this.symCiphers.getNumConfiguredAlgos();
    }

    public ZrtpConstants.SupportedSymCiphers getSymCipherAlgoAt(int index) {
        try {
            return this.symCiphers.getAlgoAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Iterable<ZrtpConstants.SupportedSymCiphers> symCiphers() {
        return this.symCiphers;
    }

    public boolean containsCipherAlgo(ZrtpConstants.SupportedSymCiphers cipher) {
        return this.symCiphers.containsAlgo(cipher);
    }

    public int addPubKeyAlgo(ZrtpConstants.SupportedPubKeys algo) {
        return this.publicKeyAlgos.addAlgo(algo);
    }

    public int addPubKeyAlgoAt(int index, ZrtpConstants.SupportedPubKeys algo) {
        return this.publicKeyAlgos.addAlgoAt(index, algo);
    }

    public int removePubKeyAlgo(ZrtpConstants.SupportedPubKeys algo) {
        return this.publicKeyAlgos.removeAlgo(algo);
    }

    public int getNumConfiguredPubKeys() {
        return this.publicKeyAlgos.getNumConfiguredAlgos();
    }

    public ZrtpConstants.SupportedPubKeys getPubKeyAlgoAt(int index) {
        try {
            return this.publicKeyAlgos.getAlgoAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Iterable<ZrtpConstants.SupportedPubKeys> publicKeyAlgos() {
        return this.publicKeyAlgos;
    }

    public boolean containsPubKeyAlgo(ZrtpConstants.SupportedPubKeys pubkey) {
        return this.publicKeyAlgos.containsAlgo(pubkey);
    }

    public int addSasTypeAlgo(ZrtpConstants.SupportedSASTypes algo) {
        return this.sasTypes.addAlgo(algo);
    }

    public int addSasTypeAlgoAt(int index, ZrtpConstants.SupportedSASTypes algo) {
        return this.sasTypes.addAlgoAt(index, algo);
    }

    public int removeSasTypeAlgo(ZrtpConstants.SupportedSASTypes algo) {
        return this.sasTypes.removeAlgo(algo);
    }

    public int getNumConfiguredSasTypes() {
        return this.sasTypes.getNumConfiguredAlgos();
    }

    public ZrtpConstants.SupportedSASTypes getSasTypeAlgoAt(int index) {
        try {
            return this.sasTypes.getAlgoAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Iterable<ZrtpConstants.SupportedSASTypes> sasTypes() {
        return this.sasTypes;
    }

    public boolean containsSasTypeAlgo(ZrtpConstants.SupportedSASTypes sas) {
        return this.sasTypes.containsAlgo(sas);
    }

    public int addAuthLength(ZrtpConstants.SupportedAuthLengths algo) {
        return this.authLengths.addAlgo(algo);
    }

    public int addAuthLengthAt(int index, ZrtpConstants.SupportedAuthLengths algo) {
        return this.authLengths.addAlgoAt(index, algo);
    }

    public int removeAuthLength(ZrtpConstants.SupportedAuthLengths algo) {
        return this.authLengths.removeAlgo(algo);
    }

    public int getNumConfiguredAuthLengths() {
        return this.authLengths.getNumConfiguredAlgos();
    }

    public ZrtpConstants.SupportedAuthLengths getAuthLengthAt(int index) {
        try {
            return this.authLengths.getAlgoAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Iterable<ZrtpConstants.SupportedAuthLengths> authLengths() {
        return this.authLengths;
    }

    public boolean containsAuthLength(ZrtpConstants.SupportedAuthLengths length) {
        return this.authLengths.containsAlgo(length);
    }

    public <T extends Enum<T>> int addAlgo(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes.addAlgo((ZrtpConstants.SupportedHashes)((Object)ZrtpConstants.SupportedHashes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers.addAlgo((ZrtpConstants.SupportedSymCiphers)((Object)ZrtpConstants.SupportedSymCiphers.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos.addAlgo((ZrtpConstants.SupportedPubKeys)((Object)ZrtpConstants.SupportedPubKeys.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes.addAlgo((ZrtpConstants.SupportedSASTypes)((Object)ZrtpConstants.SupportedSASTypes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            return this.authLengths.addAlgo((ZrtpConstants.SupportedAuthLengths)((Object)ZrtpConstants.SupportedAuthLengths.class.cast(algo)));
        }
        return -1;
    }

    public <T extends Enum<T>> int addAlgoAt(int index, T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes.addAlgoAt(index, (ZrtpConstants.SupportedHashes)((Object)ZrtpConstants.SupportedHashes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers.addAlgoAt(index, (ZrtpConstants.SupportedSymCiphers)((Object)ZrtpConstants.SupportedSymCiphers.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos.addAlgoAt(index, (ZrtpConstants.SupportedPubKeys)((Object)ZrtpConstants.SupportedPubKeys.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes.addAlgoAt(index, (ZrtpConstants.SupportedSASTypes)((Object)ZrtpConstants.SupportedSASTypes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            return this.authLengths.addAlgoAt(index, (ZrtpConstants.SupportedAuthLengths)((Object)ZrtpConstants.SupportedAuthLengths.class.cast(algo)));
        }
        return -1;
    }

    public <T extends Enum<T>> int removeAlgo(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes.removeAlgo((ZrtpConstants.SupportedHashes)((Object)ZrtpConstants.SupportedHashes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers.removeAlgo((ZrtpConstants.SupportedSymCiphers)((Object)ZrtpConstants.SupportedSymCiphers.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos.removeAlgo((ZrtpConstants.SupportedPubKeys)((Object)ZrtpConstants.SupportedPubKeys.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes.removeAlgo((ZrtpConstants.SupportedSASTypes)((Object)ZrtpConstants.SupportedSASTypes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            return this.authLengths.removeAlgo((ZrtpConstants.SupportedAuthLengths)((Object)ZrtpConstants.SupportedAuthLengths.class.cast(algo)));
        }
        return -1;
    }

    public <T extends Enum<T>> int getNumConfiguredAlgos(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes.getNumConfiguredAlgos();
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers.getNumConfiguredAlgos();
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos.getNumConfiguredAlgos();
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes.getNumConfiguredAlgos();
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            return this.authLengths.getNumConfiguredAlgos();
        }
        return -1;
    }

    public <T extends Enum<T>> T getAlgoAt(int index, T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            try {
                return (T)((Enum)clazz.cast((Object)this.hashes.getAlgoAt(index)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            try {
                return (T)((Enum)clazz.cast((Object)this.symCiphers.getAlgoAt(index)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            try {
                return (T)((Enum)clazz.cast((Object)this.publicKeyAlgos.getAlgoAt(index)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            try {
                return (T)((Enum)clazz.cast((Object)this.sasTypes.getAlgoAt(index)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            try {
                return (T)((Enum)clazz.cast((Object)this.authLengths.getAlgoAt(index)));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public <T extends Enum<T>> Iterable<T> algos(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes;
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers;
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos;
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes;
        }
        if (clazz.equals(ZrtpConstants.SupportedAuthLengths.class)) {
            return this.authLengths;
        }
        return null;
    }

    public <T extends Enum<T>> boolean containsAuthLength(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        if (clazz.equals(ZrtpConstants.SupportedHashes.class)) {
            return this.hashes.containsAlgo((ZrtpConstants.SupportedHashes)((Object)ZrtpConstants.SupportedHashes.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSymCiphers.class)) {
            return this.symCiphers.containsAlgo((ZrtpConstants.SupportedSymCiphers)((Object)ZrtpConstants.SupportedSymCiphers.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedPubKeys.class)) {
            return this.publicKeyAlgos.containsAlgo((ZrtpConstants.SupportedPubKeys)((Object)ZrtpConstants.SupportedPubKeys.class.cast(algo)));
        }
        if (clazz.equals(ZrtpConstants.SupportedSASTypes.class)) {
            return this.sasTypes.containsAlgo((ZrtpConstants.SupportedSASTypes)((Object)ZrtpConstants.SupportedSASTypes.class.cast(algo)));
        }
        return clazz.equals(ZrtpConstants.SupportedAuthLengths.class) && this.authLengths.containsAlgo((ZrtpConstants.SupportedAuthLengths)((Object)ZrtpConstants.SupportedAuthLengths.class.cast(algo)));
    }

    private class Data<T extends Enum<T>>
    implements Iterable<T> {
        private static final int maxNoOfAlgos = 7;
        private final ArrayList<T> algos = new ArrayList(7);

        private Data() {
        }

        T getAlgoAt(int index) {
            return (T)((Enum)this.algos.get(index));
        }

        int addAlgo(T algo) {
            if (this.algos.size() >= 7) {
                return 0;
            }
            if (this.algos.contains(algo)) {
                return 7 - this.algos.size();
            }
            this.algos.add(algo);
            return 7 - this.algos.size();
        }

        int addAlgoAt(int index, T algo) {
            if (this.algos.size() >= 7) {
                return 0;
            }
            if (index >= 7) {
                return 0;
            }
            if (this.algos.contains(algo)) {
                return 7 - this.algos.size();
            }
            this.algos.add(index, algo);
            return 7 - this.algos.size();
        }

        int removeAlgo(T algo) {
            this.algos.remove(algo);
            return 7 - this.algos.size();
        }

        int getNumConfiguredAlgos() {
            return this.algos.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.algos.iterator();
        }

        void clear() {
            this.algos.clear();
        }

        boolean containsAlgo(T algo) {
            return this.algos.contains(algo);
        }
    }
}

