/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp;

import gnu.java.zrtp.utils.ZrtpSecureRandom;
import java.math.BigInteger;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;

public class ZrtpConstants {
    public static final int SHA256_DIGEST_LENGTH = 32;
    public static final int MAX_DIGEST_LENGTH = 64;
    public static final String clientId = "GNU ZRTP4J 4.1.0";
    public static final byte[] zrtpVersion_11 = new byte[]{49, 46, 49, 48};
    public static final byte[] zrtpVersion_12 = new byte[]{49, 46, 50, 48};
    public static final String AES_128 = "AES-CM-128";
    public static final String AES_256 = "AES-CM-256";
    public static final String TWO_128 = "TWO-CM-128";
    public static final String TWO_256 = "TWO-CM-256";
    public static final byte[] HelloMsg = new byte[]{72, 101, 108, 108, 111, 32, 32, 32};
    public static final byte[] HelloAckMsg = new byte[]{72, 101, 108, 108, 111, 65, 67, 75};
    public static final byte[] CommitMsg = new byte[]{67, 111, 109, 109, 105, 116, 32, 32};
    public static final byte[] DHPart1Msg = new byte[]{68, 72, 80, 97, 114, 116, 49, 32};
    public static final byte[] DHPart2Msg = new byte[]{68, 72, 80, 97, 114, 116, 50, 32};
    public static final byte[] Confirm1Msg = new byte[]{67, 111, 110, 102, 105, 114, 109, 49};
    public static final byte[] Confirm2Msg = new byte[]{67, 111, 110, 102, 105, 114, 109, 50};
    public static final byte[] Conf2AckMsg = new byte[]{67, 111, 110, 102, 50, 65, 67, 75};
    public static final byte[] ErrorMsg = new byte[]{69, 114, 114, 111, 114, 32, 32, 32};
    public static final byte[] ErrorAckMsg = new byte[]{69, 114, 114, 111, 114, 65, 67, 75};
    public static final byte[] PingMsg = new byte[]{80, 105, 110, 103, 32, 32, 32, 32};
    public static final byte[] PingAckMsg = new byte[]{80, 105, 110, 103, 65, 67, 75, 32};
    public static final byte[] SASRelayMsg = new byte[]{83, 65, 83, 114, 101, 108, 97, 121};
    public static final byte[] RelayAckMsg = new byte[]{82, 101, 108, 97, 121, 65, 67, 75};
    public static final byte[] responder = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114};
    public static final byte[] initiator = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114};
    public static final byte[] iniMasterKey = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114, 32, 83, 82, 84, 80, 32, 109, 97, 115, 116, 101, 114, 32, 107, 101, 121, 0};
    public static final byte[] iniMasterSalt = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114, 32, 83, 82, 84, 80, 32, 109, 97, 115, 116, 101, 114, 32, 115, 97, 108, 116, 0};
    public static final byte[] respMasterKey = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114, 32, 83, 82, 84, 80, 32, 109, 97, 115, 116, 101, 114, 32, 107, 101, 121, 0};
    public static final byte[] respMasterSalt = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114, 32, 83, 82, 84, 80, 32, 109, 97, 115, 116, 101, 114, 32, 115, 97, 108, 116, 0};
    public static final byte[] iniHmacKey = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114, 32, 72, 77, 65, 67, 32, 107, 101, 121, 0};
    public static final byte[] respHmacKey = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114, 32, 72, 77, 65, 67, 32, 107, 101, 121, 0};
    public static final byte[] retainedSec = new byte[]{114, 101, 116, 97, 105, 110, 101, 100, 32, 115, 101, 99, 114, 101, 116, 0};
    public static final byte[] iniZrtpKey = new byte[]{73, 110, 105, 116, 105, 97, 116, 111, 114, 32, 90, 82, 84, 80, 32, 107, 101, 121, 0};
    public static final byte[] respZrtpKey = new byte[]{82, 101, 115, 112, 111, 110, 100, 101, 114, 32, 90, 82, 84, 80, 32, 107, 101, 121, 0};
    public static final byte[] sasString = new byte[]{83, 65, 83, 0};
    public static final byte[] KDFString = new byte[]{90, 82, 84, 80, 45, 72, 77, 65, 67, 45, 75, 68, 70};
    public static final byte[] zrtpSessionKey = new byte[]{90, 82, 84, 80, 32, 83, 101, 115, 115, 105, 111, 110, 32, 75, 101, 121, 0};
    public static final byte[] zrtpMsk = new byte[]{90, 82, 84, 80, 32, 77, 83, 75, 0};
    public static final byte[] zrtpTrustedMitm = new byte[]{84, 114, 117, 115, 116, 101, 100, 32, 77, 105, 84, 77, 32, 107, 101, 121, 0};
    public static final byte[] s256 = new byte[]{83, 50, 53, 54};
    public static final byte[] s384 = new byte[]{83, 51, 56, 52};
    public static final byte[] aes3 = new byte[]{65, 69, 83, 51};
    public static final byte[] aes1 = new byte[]{65, 69, 83, 49};
    public static final byte[] two1 = new byte[]{50, 70, 83, 49};
    public static final byte[] two3 = new byte[]{50, 70, 83, 51};
    public static final byte[] dh3k = new byte[]{68, 72, 51, 107};
    public static final byte[] dh2k = new byte[]{68, 72, 50, 107};
    public static final byte[] mult = new byte[]{77, 117, 108, 116};
    public static final byte[] b32 = new byte[]{66, 51, 50, 32};
    public static final byte[] b256 = new byte[]{66, 50, 53, 54};
    public static final byte[] b32e = new byte[]{66, 51, 50, 69};
    public static final byte[] hs32 = new byte[]{72, 83, 51, 50};
    public static final byte[] hs80 = new byte[]{72, 83, 56, 48};
    public static final byte[] sk32 = new byte[]{83, 75, 51, 50};
    public static final byte[] sk64 = new byte[]{83, 75, 54, 52};
    public static final byte[] ec25 = new byte[]{69, 67, 50, 53};
    public static final byte[] ec38 = new byte[]{69, 67, 51, 56};
    public static final byte[] e255 = new byte[]{69, 50, 53, 53};
    public static final X9ECParameters x9Ec25 = SECNamedCurves.getByName((String)"secp256r1");
    public static final X9ECParameters x9Ec38 = SECNamedCurves.getByName((String)"secp384r1");
    public static final X9ECParameters curve25519 = CustomNamedCurves.getByName((String)"Curve25519");
    public static final BigInteger P2048 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger P3072 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
    public static final BigInteger two = BigInteger.valueOf(2L);
    public static final BigInteger P2048MinusOne = P2048.subtract(BigInteger.ONE);
    public static final BigInteger P3072MinusOne = P3072.subtract(BigInteger.ONE);
    public static final DHParameters specDh2k = new DHParameters(P2048, two, null, 256);
    public static final DHParameters specDh3k = new DHParameters(P3072, two, null, 512);
    public static final String[] sas256WordsOdd = new String[]{"adroitness", "adviser", "aftermath", "aggregate", "alkali", "almighty", "amulet", "amusement", "antenna", "applicant", "Apollo", "armistice", "article", "asteroid", "Atlantic", "atmosphere", "autopsy", "Babylon", "backwater", "barbecue", "belowground", "bifocals", "bodyguard", "bookseller", "borderline", "bottomless", "Bradbury", "bravado", "Brazilian", "breakaway", "Burlington", "businessman", "butterfat", "Camelot", "candidate", "cannonball", "Capricorn", "caravan", "caretaker", "celebrate", "cellulose", "certify", "chambermaid", "Cherokee", "Chicago", "clergyman", "coherence", "combustion", "commando", "company", "component", "concurrent", "confidence", "conformist", "congregate", "consensus", "consulting", "corporate", "corrosion", "councilman", "crossover", "crucifix", "cumbersome", "customer", "Dakota", "decadence", "December", "decimal", "designing", "detector", "detergent", "determine", "dictator", "dinosaur", "direction", "disable", "disbelief", "disruptive", "distortion", "document", "embezzle", "enchanting", "enrollment", "enterprise", "equation", "equipment", "escapade", "Eskimo", "everyday", "examine", "existence", "exodus", "fascinate", "filament", "finicky", "forever", "fortitude", "frequency", "gadgetry", "Galveston", "getaway", "glossary", "gossamer", "graduate", "gravity", "guitarist", "hamburger", "Hamilton", "handiwork", "hazardous", "headwaters", "hemisphere", "hesitate", "hideaway", "holiness", "hurricane", "hydraulic", "impartial", "impetus", "inception", "indigo", "inertia", "infancy", "inferno", "informant", "insincere", "insurgent", "integrate", "intention", "inventive", "Istanbul", "Jamaica", "Jupiter", "leprosy", "letterhead", "liberty", "maritime", "matchmaker", "maverick", "Medusa", "megaton", "microscope", "microwave", "midsummer", "millionaire", "miracle", "misnomer", "molasses", "molecule", "Montana", "monument", "mosquito", "narrative", "nebula", "newsletter", "Norwegian", "October", "Ohio", "onlooker", "opulent", "Orlando", "outfielder", "Pacific", "pandemic", "Pandora", "paperweight", "paragon", "paragraph", "paramount", "passenger", "pedigree", "Pegasus", "penetrate", "perceptive", "performance", "pharmacy", "phonetic", "photograph", "pioneer", "pocketful", "politeness", "positive", "potato", "processor", "provincial", "proximate", "puberty", "publisher", "pyramid", "quantity", "racketeer", "rebellion", "recipe", "recover", "repellent", "replica", "reproduce", "resistor", "responsive", "retraction", "retrieval", "retrospect", "revenue", "revival", "revolver", "sandalwood", "sardonic", "Saturday", "savagery", "scavenger", "sensation", "sociable", "souvenir", "specialist", "speculate", "stethoscope", "stupendous", "supportive", "surrender", "suspicious", "sympathy", "tambourine", "telephone", "therapist", "tobacco", "tolerance", "tomorrow", "torpedo", "tradition", "travesty", "trombonist", "truncated", "typewriter", "ultimate", "undaunted", "underfoot", "unicorn", "unify", "universe", "unravel", "upcoming", "vacancy", "vagabond", "vertigo", "Virginia", "visitor", "vocalist", "voyager", "warranty", "Waterloo", "whimsical", "Wichita", "Wilmington", "Wyoming", "yesteryear", "Yucatan"};
    public static final String[] sas256WordsEven = new String[]{"aardvark", "absurd", "accrue", "acme", "adrift", "adult", "afflict", "ahead", "aimless", "Algol", "allow", "alone", "ammo", "ancient", "apple", "artist", "assume", "Athens", "atlas", "Aztec", "baboon", "backfield", "backward", "banjo", "beaming", "bedlamp", "beehive", "beeswax", "befriend", "Belfast", "berserk", "billiard", "bison", "blackjack", "blockade", "blowtorch", "bluebird", "bombast", "bookshelf", "brackish", "breadline", "breakup", "brickyard", "briefcase", "Burbank", "button", "buzzard", "cement", "chairlift", "chatter", "checkup", "chisel", "choking", "chopper", "Christmas", "clamshell", "classic", "classroom", "cleanup", "clockwork", "cobra", "commence", "concert", "cowbell", "crackdown", "cranky", "crowfoot", "crucial", "crumpled", "crusade", "cubic", "dashboard", "deadbolt", "deckhand", "dogsled", "dragnet", "drainage", "dreadful", "drifter", "dropper", "drumbeat", "drunken", "Dupont", "dwelling", "eating", "edict", "egghead", "eightball", "endorse", "endow", "enlist", "erase", "escape", "exceed", "eyeglass", "eyetooth", "facial", "fallout", "flagpole", "flatfoot", "flytrap", "fracture", "framework", "freedom", "frighten", "gazelle", "Geiger", "glitter", "glucose", "goggles", "goldfish", "gremlin", "guidance", "hamlet", "highchair", "hockey", "indoors", "indulge", "inverse", "involve", "island", "jawbone", "keyboard", "kickoff", "kiwi", "klaxon", "locale", "lockup", "merit", "minnow", "miser", "Mohawk", "mural", "music", "necklace", "Neptune", "newborn", "nightbird", "Oakland", "obtuse", "offload", "optic", "orca", "payday", "peachy", "pheasant", "physique", "playhouse", "Pluto", "preclude", "prefer", "preshrunk", "printer", "prowler", "pupil", "puppy", "python", "quadrant", "quiver", "quota", "ragtime", "ratchet", "rebirth", "reform", "regain", "reindeer", "rematch", "repay", "retouch", "revenge", "reward", "rhythm", "ribcage", "ringbolt", "robust", "rocker", "ruffled", "sailboat", "sawdust", "scallion", "scenic", "scorecard", "Scotland", "seabird", "select", "sentence", "shadow", "shamrock", "showgirl", "skullcap", "skydive", "slingshot", "slowdown", "snapline", "snapshot", "snowcap", "snowslide", "solo", "southward", "soybean", "spaniel", "spearhead", "spellbind", "spheroid", "spigot", "spindle", "spyglass", "stagehand", "stagnate", "stairway", "standard", "stapler", "steamship", "sterling", "stockman", "stopwatch", "stormy", "sugar", "surmount", "suspense", "sweatband", "swelter", "tactics", "talon", "tapeworm", "tempest", "tiger", "tissue", "tonic", "topmost", "tracker", "transit", "trauma", "treadmill", "Trojan", "trouble", "tumor", "tunnel", "tycoon", "uncut", "unearth", "unwind", "uproot", "upset", "upshot", "vapor", "village", "virus", "Vulcan", "waffle", "wallet", "watchword", "wayside", "willow", "woodlark", "Zulu"};

    public static enum SupportedAuthAlgos {
        HS,
        SK;

    }

    public static enum SupportedAuthLengths {
        SK32(sk32, SupportedAuthAlgos.SK, 32),
        HS32(hs32, SupportedAuthAlgos.HS, 32),
        SK64(sk64, SupportedAuthAlgos.SK, 64),
        HS80(hs80, SupportedAuthAlgos.HS, 80);

        public final byte[] name;
        public final SupportedAuthAlgos algo;
        public final int length;

        private SupportedAuthLengths(byte[] nm, SupportedAuthAlgos al, int len) {
            this.name = nm;
            this.algo = al;
            this.length = len;
        }
    }

    public static enum SupportedSASTypes {
        B32(b32),
        B256(b256),
        B32E(b32e);

        public byte[] name;

        private SupportedSASTypes(byte[] nm) {
            this.name = nm;
        }
    }

    public static enum SupportedPubKeys {
        EC25(ec25, 64, new ECKeyGenerationParameters(new ECDomainParameters(x9Ec25.getCurve(), x9Ec25.getG(), x9Ec25.getN(), x9Ec25.getH(), x9Ec25.getSeed()), ZrtpSecureRandom.getInstance())),
        EC38(ec38, 96, new ECKeyGenerationParameters(new ECDomainParameters(x9Ec38.getCurve(), x9Ec38.getG(), x9Ec38.getN(), x9Ec38.getH(), x9Ec38.getSeed()), ZrtpSecureRandom.getInstance())),
        E255(e255, 32, new ECKeyGenerationParameters(new ECDomainParameters(curve25519.getCurve(), curve25519.getG(), curve25519.getN(), curve25519.getH(), curve25519.getSeed()), ZrtpSecureRandom.getInstance())),
        DH2K(dh2k, 256, new DHKeyGenerationParameters(ZrtpSecureRandom.getInstance(), specDh2k)),
        DH3K(dh3k, 384, new DHKeyGenerationParameters(ZrtpSecureRandom.getInstance(), specDh3k)),
        MULT(mult);

        public byte[] name;
        public final AsymmetricCipherKeyPairGenerator keyPairGen;
        public final int pubKeySize;
        public final DHParameters specDh;
        public final ECCurve curve;
        public final BasicAgreement dhContext;

        private SupportedPubKeys(byte[] nm) {
            this.name = nm;
            this.pubKeySize = 0;
            this.keyPairGen = null;
            this.specDh = null;
            this.dhContext = null;
            this.curve = null;
        }

        private SupportedPubKeys(byte[] nm, int size, ECKeyGenerationParameters ecdh) {
            this.name = nm;
            this.pubKeySize = size;
            if (ecdh != null) {
                this.keyPairGen = new ECKeyPairGenerator();
                this.keyPairGen.init((KeyGenerationParameters)ecdh);
                this.curve = ecdh.getDomainParameters().getCurve();
                this.dhContext = new ECDHBasicAgreement();
            } else {
                this.curve = null;
                this.keyPairGen = null;
                this.dhContext = null;
            }
            this.specDh = null;
        }

        private SupportedPubKeys(byte[] nm, int size, DHKeyGenerationParameters dh) {
            this.name = nm;
            this.pubKeySize = size;
            if (dh != null) {
                this.keyPairGen = new DHBasicKeyPairGenerator();
                this.keyPairGen.init((KeyGenerationParameters)dh);
                this.specDh = dh.getParameters();
                this.dhContext = new DHBasicAgreement();
            } else {
                this.keyPairGen = null;
                this.specDh = null;
                this.dhContext = null;
            }
            this.curve = null;
        }
    }

    public static enum SupportedSymAlgos {
        AES,
        TwoFish;

    }

    public static enum SupportedSymCiphers {
        AES3(aes3, 32, "AES-CM-256", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESEngine(), 128)), SupportedSymAlgos.AES),
        AES1(aes1, 16, "AES-CM-128", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESEngine(), 128)), SupportedSymAlgos.AES),
        TWO3(two3, 32, "TWO-CM-256", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new TwofishEngine(), 128)), SupportedSymAlgos.TwoFish),
        TWO1(two1, 16, "TWO-CM-128", new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new TwofishEngine(), 128)), SupportedSymAlgos.TwoFish);

        public final byte[] name;
        public final int keyLength;
        public final String readable;
        public final BufferedBlockCipher cipher;
        public final SupportedSymAlgos algo;

        private SupportedSymCiphers(byte[] nm, int keyLen, String ra, BufferedBlockCipher ci, SupportedSymAlgos al) {
            this.name = nm;
            this.keyLength = keyLen;
            this.readable = ra;
            this.cipher = ci;
            this.algo = al;
        }
    }

    public static enum SupportedHashes {
        S256(s256),
        S384(s384);

        public byte[] name;

        private SupportedHashes(byte[] nm) {
            this.name = nm;
        }
    }
}

