/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpCryptoContext;
import org.jitsi.srtp.SrtpErrorStatus;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging.Logger;

public class SRTPTransformer
extends SinglePacketTransformer {
    private static final Logger logger = Logger.getLogger(SRTPTransformer.class);
    SrtpContextFactory forwardFactory;
    SrtpContextFactory reverseFactory;
    private final Map<Integer, SrtpCryptoContext> contexts;

    public SRTPTransformer(SrtpContextFactory factory) {
        this(factory, factory);
    }

    public SRTPTransformer(SrtpContextFactory forwardFactory, SrtpContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new HashMap<Integer, SrtpCryptoContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextFactory(SrtpContextFactory factory, boolean forward) {
        Map<Integer, SrtpCryptoContext> map = this.contexts;
        synchronized (map) {
            if (forward) {
                if (this.forwardFactory != null && this.forwardFactory != factory) {
                    this.forwardFactory.close();
                }
                this.forwardFactory = factory;
            } else {
                if (this.reverseFactory != null && this.reverseFactory != factory) {
                    this.reverseFactory.close();
                }
                this.reverseFactory = factory;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, SrtpCryptoContext> map = this.contexts;
        synchronized (map) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            this.contexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrtpCryptoContext getContext(int ssrc, SrtpContextFactory engine, int deriveSrtpKeysIndex) {
        SrtpCryptoContext context;
        Map<Integer, SrtpCryptoContext> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(ssrc);
            if (context == null) {
                try {
                    context = engine.deriveContext(ssrc, 0);
                }
                catch (GeneralSecurityException e) {
                    logger.error((Object)("Could not get context for ssrc " + ssrc), (Throwable)e);
                    return null;
                }
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        boolean skipDecryption;
        if ((pkt.readByte(0) & 0xC0) != 128) {
            return null;
        }
        SrtpCryptoContext context = this.getContext(pkt.getSSRC(), this.reverseFactory, pkt.getSequenceNumber());
        boolean bl = skipDecryption = (pkt.getFlags() & 6) != 0;
        if (context == null) {
            return null;
        }
        try {
            return context.reverseTransformPacket((ByteArrayBuffer)pkt, skipDecryption) == SrtpErrorStatus.OK ? pkt : null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        SrtpCryptoContext context = this.getContext(pkt.getSSRC(), this.forwardFactory, 0);
        if (context == null) {
            return null;
        }
        try {
            return context.transformPacket((ByteArrayBuffer)pkt) == SrtpErrorStatus.OK ? pkt : null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }
}

