/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jitsi.impl.neomedia.transform.fec.AbstractFECReceiver;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.logging.Logger;

public class ULPFECReceiver
extends AbstractFECReceiver {
    private static final Logger logger = Logger.getLogger(ULPFECReceiver.class);
    private final Set<RawPacket> packetsToRemove = new HashSet<RawPacket>();
    private Reconstructor reconstructor;

    public ULPFECReceiver(long ssrc, byte payloadType) {
        super(ssrc, payloadType);
        this.reconstructor = new Reconstructor(this.mediaPackets, ssrc);
    }

    @Override
    protected RawPacket[] doReverseTransform(RawPacket[] pkts) {
        if (this.handleFec) {
            this.packetsToRemove.clear();
            for (Map.Entry entry : this.fecPackets.entrySet()) {
                RawPacket fecPacket = (RawPacket)entry.getValue();
                this.reconstructor.setFecPacket(fecPacket);
                if (this.reconstructor.numMissing == 0) {
                    this.packetsToRemove.add(fecPacket);
                    continue;
                }
                if (!this.reconstructor.canRecover()) continue;
                this.packetsToRemove.add(fecPacket);
                RawPacket recovered = this.reconstructor.recover();
                if (recovered == null) continue;
                ++this.statistics.numRecoveredPackets;
                this.saveMedia(recovered);
                boolean found = false;
                for (int i = 0; i < pkts.length; ++i) {
                    if (pkts[i] != null) continue;
                    pkts[i] = recovered;
                    found = true;
                    break;
                }
                if (found) continue;
                RawPacket[] pkts2 = new RawPacket[pkts.length + 1];
                System.arraycopy(pkts, 0, pkts2, 0, pkts.length);
                pkts2[pkts.length] = recovered;
                pkts = pkts2;
            }
            for (RawPacket p : this.packetsToRemove) {
                this.fecPackets.remove(p.getSequenceNumber());
            }
        }
        return pkts;
    }

    private static class Reconstructor {
        private Set<RawPacket> neededPackets = new HashSet<RawPacket>();
        private RawPacket fecPacket = null;
        private int numMissing = -1;
        private int sequenceNumber = -1;
        private long ssrc;
        private Map<Integer, RawPacket> mediaPackets;

        Reconstructor(Map<Integer, RawPacket> mediaPackets, long ssrc) {
            this.mediaPackets = mediaPackets;
            this.ssrc = ssrc;
        }

        private boolean canRecover() {
            return this.numMissing == 1;
        }

        private void setFecPacket(RawPacket p) {
            this.neededPackets.clear();
            this.numMissing = 0;
            this.sequenceNumber = -1;
            this.fecPacket = p;
            byte[] buf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int maskLen = (buf[idx] & 0x40) == 0 ? 2 : 6;
            int base = this.fecPacket.readUint16AsInt(this.fecPacket.getHeaderLength() + 2);
            idx += 12;
            block0: for (int i = 0; i < maskLen; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if ((buf[idx + i] & (1 << 7 - j & 0xFF)) != 0) {
                        RawPacket pkt = this.mediaPackets.get(base + i * 8 + j);
                        if (pkt != null) {
                            this.neededPackets.add(pkt);
                        } else {
                            this.sequenceNumber = base + i * 8 + j;
                            ++this.numMissing;
                        }
                    }
                    if (this.numMissing > 1) break block0;
                }
            }
            if (this.numMissing != 1) {
                this.sequenceNumber = -1;
            }
        }

        private RawPacket recover() {
            int protectionLength;
            if (!this.canRecover()) {
                return null;
            }
            byte[] fecBuf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int lengthRecovery = (fecBuf[idx + 8] & 0xFF) << 8 | fecBuf[idx + 9] & 0xFF;
            for (RawPacket rawPacket : this.neededPackets) {
                lengthRecovery ^= rawPacket.getLength() - 12;
            }
            byte[] recoveredBuf = new byte[(lengthRecovery &= 0xFFFF) + 12];
            System.arraycopy(fecBuf, idx, recoveredBuf, 0, 8);
            for (RawPacket p : this.neededPackets) {
                int pOffset = p.getOffset();
                byte[] pBuf = p.getBuffer();
                for (int i = 0; i < 8; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOffset + i]);
                }
            }
            recoveredBuf[0] = (byte)(recoveredBuf[0] & 0x3F);
            recoveredBuf[0] = (byte)(recoveredBuf[0] | 0x80);
            boolean bl = (fecBuf[idx] & 0x40) != 0;
            if ((protectionLength = (fecBuf[idx += 10] & 0xFF) << 8 | fecBuf[idx + 1] & 0xFF) < lengthRecovery) {
                logger.warn((Object)"Recovered only a partial RTP packet. Discarding.");
                return null;
            }
            idx += 4;
            if (bl) {
                idx += 4;
            }
            System.arraycopy(fecBuf, idx, recoveredBuf, 12, lengthRecovery);
            for (RawPacket p : this.neededPackets) {
                byte[] pBuf = p.getBuffer();
                int pLen = p.getLength();
                int pOff = p.getOffset();
                for (int i = 12; i < lengthRecovery + 12 && i < pLen; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOff + i]);
                }
            }
            RawPacket recovered = new RawPacket(recoveredBuf, 0, lengthRecovery + 12);
            recovered.setSSRC((int)this.ssrc);
            recovered.setSequenceNumber(this.sequenceNumber);
            return recovered;
        }
    }
}

