/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.util.Iterator;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.utils.ByteArrayBuffer;

public class RTCPIterator
implements Iterator<ByteArrayBuffer> {
    private final ByteArrayBuffer baf;
    private int nextOff;
    private int remainingLen;
    private int lastLen;

    public RTCPIterator(ByteArrayBuffer baf) {
        this.baf = baf;
        if (baf != null) {
            this.nextOff = baf.getOffset();
            this.remainingLen = baf.getLength();
        }
    }

    @Override
    public boolean hasNext() {
        return RTCPUtils.getLength(this.baf.getBuffer(), this.nextOff, this.remainingLen) >= 8;
    }

    @Override
    public ByteArrayBuffer next() {
        int pktLen = RTCPUtils.getLength(this.baf.getBuffer(), this.nextOff, this.remainingLen);
        if (pktLen < 8) {
            throw new IllegalStateException();
        }
        RawPacket next = new RawPacket(this.baf.getBuffer(), this.nextOff, pktLen);
        this.lastLen = pktLen;
        this.nextOff += pktLen;
        this.remainingLen -= pktLen;
        if (this.remainingLen < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return next;
    }

    @Override
    public void remove() {
        if (this.lastLen == 0) {
            throw new IllegalStateException();
        }
        System.arraycopy(this.baf.getBuffer(), this.nextOff, this.baf.getBuffer(), this.nextOff - this.lastLen, this.remainingLen);
        this.nextOff -= this.lastLen;
        this.baf.setLength(this.baf.getLength() - this.lastLen);
        this.lastLen = 0;
    }
}

