/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.PropertyChangeNotifier;
import org.jitsi.utils.logging.Logger;

public abstract class DeviceSystem
extends PropertyChangeNotifier {
    private static List<DeviceSystem> deviceSystems = new LinkedList<DeviceSystem>();
    public static final int FEATURE_REINITIALIZE = 1;
    public static final String LOCATOR_PROTOCOL_ANDROIDCAMERA = "androidcamera";
    public static final String LOCATOR_PROTOCOL_CIVIL = "civil";
    public static final String LOCATOR_PROTOCOL_DIRECTSHOW = "directshow";
    public static final String LOCATOR_PROTOCOL_IMGSTREAMING = "imgstreaming";
    public static final String LOCATOR_PROTOCOL_MEDIARECORDER = "mediarecorder";
    public static final String LOCATOR_PROTOCOL_QUICKTIME = "quicktime";
    public static final String LOCATOR_PROTOCOL_VIDEO4LINUX2 = "video4linux2";
    private static final Logger logger = Logger.getLogger(DeviceSystem.class);
    private static List<CaptureDeviceInfo> preInitializeDevices;
    public static final String PROP_DEVICES = "devices";
    private final int features;
    private final String locatorProtocol;
    private final MediaType mediaType;

    protected static List<CaptureDeviceInfo> filterDeviceListByLocatorProtocol(List<CaptureDeviceInfo> deviceList, String locatorProtocol) {
        if (deviceList != null && deviceList.size() > 0) {
            Iterator<CaptureDeviceInfo> deviceListIter = deviceList.iterator();
            while (deviceListIter.hasNext()) {
                MediaLocator locator = deviceListIter.next().getLocator();
                if (locator != null && locatorProtocol.equalsIgnoreCase(locator.getProtocol())) continue;
                deviceListIter.remove();
            }
        }
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceSystem[] getDeviceSystems(MediaType mediaType) {
        ArrayList<DeviceSystem> ret;
        List<DeviceSystem> list = deviceSystems;
        synchronized (list) {
            ret = new ArrayList<DeviceSystem>(deviceSystems.size());
            for (DeviceSystem deviceSystem : deviceSystems) {
                if (!deviceSystem.getMediaType().equals((Object)mediaType)) continue;
                ret.add(deviceSystem);
            }
        }
        return ret.toArray(new DeviceSystem[ret.size()]);
    }

    public static void initializeDeviceSystems() {
        if (MediaServiceImpl.isMediaTypeSupportEnabled(MediaType.AUDIO)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Initializing audio devices");
            }
            DeviceSystem.initializeDeviceSystems(MediaType.AUDIO);
        }
        if (MediaServiceImpl.isMediaTypeSupportEnabled(MediaType.VIDEO)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Initializing video devices");
            }
            DeviceSystem.initializeDeviceSystems(MediaType.VIDEO);
        }
    }

    public static void initializeDeviceSystems(MediaType mediaType) {
        String[] classNames;
        switch (mediaType) {
            case AUDIO: {
                classNames = new String[]{OSUtils.IS_ANDROID ? ".AudioRecordSystem" : null, OSUtils.IS_ANDROID ? ".OpenSLESSystem" : null, OSUtils.IS_LINUX || OSUtils.IS_FREEBSD ? ".PulseAudioSystem" : null, OSUtils.IS_WINDOWS ? ".WASAPISystem" : null, OSUtils.IS_MAC ? ".MacCoreaudioSystem" : null, OSUtils.IS_ANDROID ? null : ".PortAudioSystem", ".AudioSilenceSystem", ".NoneAudioSystem"};
                break;
            }
            case VIDEO: {
                classNames = new String[]{OSUtils.IS_ANDROID ? ".MediaRecorderSystem" : null, OSUtils.IS_ANDROID ? ".AndroidCameraSystem" : null, OSUtils.IS_LINUX || OSUtils.IS_FREEBSD ? ".Video4Linux2System" : null, OSUtils.IS_MAC ? ".QuickTimeSystem" : null, OSUtils.IS_WINDOWS ? ".DirectShowSystem" : null, ".ImgStreamingSystem"};
                break;
            }
            default: {
                throw new IllegalArgumentException("mediaType");
            }
        }
        DeviceSystem.initializeDeviceSystems(classNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void initializeDeviceSystems(String[] classNames) {
        List<DeviceSystem> list = deviceSystems;
        synchronized (list) {
            String packageName = null;
            for (String string : classNames) {
                boolean reinitialize;
                void var6_6;
                if (string == null) continue;
                if (string.startsWith(".")) {
                    if (packageName == null) {
                        packageName = DeviceSystem.class.getPackage().getName();
                    }
                    String string2 = packageName + string;
                }
                if (Boolean.getBoolean((String)var6_6 + ".disabled")) continue;
                DeviceSystem deviceSystem = null;
                for (DeviceSystem aDeviceSystem : deviceSystems) {
                    if (!((Object)((Object)aDeviceSystem)).getClass().getName().equals(var6_6)) continue;
                    deviceSystem = aDeviceSystem;
                    break;
                }
                if (deviceSystem == null) {
                    reinitialize = false;
                    Object o = null;
                    try {
                        o = Class.forName((String)var6_6).newInstance();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn((Object)("Failed to initialize " + (String)var6_6), t);
                    }
                    if (o instanceof DeviceSystem && !deviceSystems.contains((Object)(deviceSystem = (DeviceSystem)o))) {
                        deviceSystems.add(deviceSystem);
                    }
                } else {
                    reinitialize = true;
                }
                if (!reinitialize || (deviceSystem.getFeatures() & 1) == 0) continue;
                try {
                    DeviceSystem.invokeDeviceSystemInitialize(deviceSystem);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn((Object)("Failed to reinitialize " + (String)var6_6), t);
                }
            }
        }
    }

    static void invokeDeviceSystemInitialize(DeviceSystem deviceSystem) throws Exception {
        DeviceSystem.invokeDeviceSystemInitialize(deviceSystem, false);
    }

    static void invokeDeviceSystemInitialize(final DeviceSystem deviceSystem, boolean asynchronous) throws Exception {
        if (OSUtils.IS_WINDOWS || asynchronous) {
            Throwable t;
            final String className = ((Object)((Object)deviceSystem)).getClass().getName();
            final Throwable[] exception = new Throwable[1];
            Thread thread = new Thread(className + ".initialize()"){

                @Override
                public void run() {
                    block4: {
                        boolean loggerIsTraceEnabled = logger.isTraceEnabled();
                        try {
                            if (loggerIsTraceEnabled) {
                                logger.trace((Object)("Will initialize " + className));
                            }
                            deviceSystem.initialize();
                            if (loggerIsTraceEnabled) {
                                logger.trace((Object)("Did initialize " + className));
                            }
                        }
                        catch (Throwable t) {
                            exception[0] = t;
                            if (!(t instanceof ThreadDeath)) break block4;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            if (asynchronous) {
                return;
            }
            boolean interrupted = false;
            while (thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if ((t = exception[0]) != null) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UndeclaredThrowableException(t);
            }
        } else {
            deviceSystem.initialize();
        }
    }

    protected DeviceSystem(MediaType mediaType, String locatorProtocol) throws Exception {
        this(mediaType, locatorProtocol, 0);
    }

    protected DeviceSystem(MediaType mediaType, String locatorProtocol, int features) throws Exception {
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        if (locatorProtocol == null) {
            throw new NullPointerException("locatorProtocol");
        }
        this.mediaType = mediaType;
        this.locatorProtocol = locatorProtocol;
        this.features = features;
        DeviceSystem.invokeDeviceSystemInitialize(this);
    }

    public Renderer createRenderer() {
        String className = this.getRendererClassName();
        if (className != null) {
            try {
                return (Renderer)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)("Failed to initialize a new " + className + " instance"), t);
            }
        }
        return null;
    }

    protected abstract void doInitialize() throws Exception;

    public final int getFeatures() {
        return this.features;
    }

    public Format getFormat() {
        AudioFormat format = null;
        switch (this.getMediaType()) {
            case AUDIO: {
                format = new AudioFormat(null);
                break;
            }
            case VIDEO: {
                format = new VideoFormat(null);
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    public final String getLocatorProtocol() {
        return this.locatorProtocol;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    protected String getRendererClassName() {
        return null;
    }

    protected final synchronized void initialize() throws Exception {
        this.preInitialize();
        try {
            this.doInitialize();
        }
        finally {
            this.postInitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postInitialize() throws Exception {
        try {
            Format format = this.getFormat();
            if (format != null) {
                int preInitializeDeviceCount;
                Vector cdis = CaptureDeviceManager.getDeviceList((Format)format);
                ArrayList postInitializeDevices = new ArrayList(cdis);
                if (preInitializeDevices != null) {
                    Iterator<CaptureDeviceInfo> preIter = preInitializeDevices.iterator();
                    while (preIter.hasNext()) {
                        if (!postInitializeDevices.remove(preIter.next())) continue;
                        preIter.remove();
                    }
                }
                int n = preInitializeDeviceCount = preInitializeDevices == null ? 0 : preInitializeDevices.size();
                if (preInitializeDeviceCount != 0 || postInitializeDevices.size() != 0) {
                    this.firePropertyChange(PROP_DEVICES, preInitializeDevices, postInitializeDevices);
                }
            }
        }
        finally {
            preInitializeDevices = null;
        }
    }

    protected void preInitialize() throws Exception {
        block6: {
            Format format = this.getFormat();
            if (format != null) {
                Vector cdis = CaptureDeviceManager.getDeviceList((Format)format);
                preInitializeDevices = new ArrayList<CaptureDeviceInfo>(cdis);
                if (cdis != null && cdis.size() > 0) {
                    boolean commit = false;
                    for (CaptureDeviceInfo cdi : DeviceSystem.filterDeviceListByLocatorProtocol(cdis, this.getLocatorProtocol())) {
                        CaptureDeviceManager.removeDevice((CaptureDeviceInfo)cdi);
                        commit = true;
                    }
                    if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
                        try {
                            CaptureDeviceManager.commit();
                        }
                        catch (IOException ioe) {
                            if (!logger.isDebugEnabled()) break block6;
                            logger.debug((Object)"Failed to commit CaptureDeviceManager", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return this.getLocatorProtocol();
    }
}

