/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import org.jitsi.impl.neomedia.codec.audio.g729.Filter;
import org.jitsi.impl.neomedia.codec.audio.g729.FloatReference;
import org.jitsi.impl.neomedia.codec.audio.g729.IntReference;
import org.jitsi.impl.neomedia.codec.audio.g729.TabLd8k;

class Pitch {
    Pitch() {
    }

    static int pitch_ol(float[] signal, int signal_offset, int pit_min, int pit_max, int l_frame) {
        float THRESHPIT = 0.85f;
        FloatReference maxRef = new FloatReference();
        int p_max1 = Pitch.lag_max(signal, signal_offset, l_frame, pit_max, 80, maxRef);
        float max1 = maxRef.value;
        int p_max2 = Pitch.lag_max(signal, signal_offset, l_frame, 79, 40, maxRef);
        float max2 = maxRef.value;
        int p_max3 = Pitch.lag_max(signal, signal_offset, l_frame, 39, pit_min, maxRef);
        float max3 = maxRef.value;
        if (max1 * THRESHPIT < max2) {
            max1 = max2;
            p_max1 = p_max2;
        }
        if (max1 * THRESHPIT < max3) {
            p_max1 = p_max3;
        }
        return p_max1;
    }

    private static int lag_max(float[] signal, int signal_offset, int l_frame, int lagmax, int lagmin, FloatReference cor_max) {
        float t0;
        int p;
        int i;
        float FLT_MIN_G729 = -1.0E38f;
        int p_max = 0;
        float max = FLT_MIN_G729;
        for (i = lagmax; i >= lagmin; --i) {
            p = signal_offset;
            int p1 = signal_offset - i;
            t0 = 0.0f;
            int j = 0;
            while (j < l_frame) {
                t0 += signal[p] * signal[p1];
                ++j;
                ++p;
                ++p1;
            }
            if (!(t0 >= max)) continue;
            max = t0;
            p_max = i;
        }
        t0 = 0.01f;
        p = signal_offset - p_max;
        i = 0;
        while (i < l_frame) {
            t0 += signal[p] * signal[p];
            ++i;
            ++p;
        }
        t0 = Pitch.inv_sqrt(t0);
        cor_max.value = max * t0;
        return p_max;
    }

    static int pitch_fr3(float[] exc, int exc_offset, float[] xn, float[] h, int l_subfr, int t0_min, int t0_max, int i_subfr, IntReference pit_frac) {
        int i;
        int L_INTER4 = 4;
        float[] corr_v = new float[10 + 2 * L_INTER4];
        int t_min = t0_min - L_INTER4;
        int t_max = t0_max + L_INTER4;
        float[] corr = corr_v;
        int corr_offset = -t_min;
        Pitch.norm_corr(exc, exc_offset, xn, h, l_subfr, t_min, t_max, corr, corr_offset);
        float max = corr[corr_offset + t0_min];
        int lag = t0_min;
        for (i = t0_min + 1; i <= t0_max; ++i) {
            if (!(corr[corr_offset + i] >= max)) continue;
            max = corr[corr_offset + i];
            lag = i;
        }
        if (i_subfr == 0 && lag > 84) {
            pit_frac.value = 0;
            return lag;
        }
        max = Pitch.interpol_3(corr, corr_offset += lag, -2);
        int frac = -2;
        for (i = -1; i <= 2; ++i) {
            float corr_int = Pitch.interpol_3(corr, corr_offset, i);
            if (!(corr_int > max)) continue;
            max = corr_int;
            frac = i;
        }
        if (frac == -2) {
            frac = 1;
            --lag;
        }
        if (frac == 2) {
            frac = -1;
            ++lag;
        }
        pit_frac.value = frac;
        return lag;
    }

    private static void norm_corr(float[] exc, int exc_offset, float[] xn, float[] h, int l_subfr, int t_min, int t_max, float[] corr_norm, int corr_norm_offset) {
        int L_SUBFR = 40;
        float[] excf = new float[L_SUBFR];
        int k = exc_offset - t_min;
        Filter.convolve(exc, k, h, excf, l_subfr);
        for (int i = t_min; i <= t_max; ++i) {
            int j;
            float alp = 0.01f;
            for (j = 0; j < l_subfr; ++j) {
                alp += excf[j] * excf[j];
            }
            float norm = Pitch.inv_sqrt(alp);
            float s = 0.0f;
            for (j = 0; j < l_subfr; ++j) {
                s += xn[j] * excf[j];
            }
            corr_norm[corr_norm_offset + i] = s * norm;
            if (i == t_max) continue;
            --k;
            for (j = l_subfr - 1; j > 0; --j) {
                excf[j] = excf[j - 1] + exc[k] * h[j];
            }
            excf[0] = exc[k];
        }
    }

    static float g_pitch(float[] xn, float[] y1, float[] g_coeff, int l_subfr) {
        int i;
        float GAIN_PIT_MAX = 1.2f;
        float xy = 0.0f;
        for (i = 0; i < l_subfr; ++i) {
            xy += xn[i] * y1[i];
        }
        float yy = 0.01f;
        for (i = 0; i < l_subfr; ++i) {
            yy += y1[i] * y1[i];
        }
        g_coeff[0] = yy;
        g_coeff[1] = -2.0f * xy + 0.01f;
        float gain = xy / yy;
        if (gain < 0.0f) {
            gain = 0.0f;
        }
        if (gain > GAIN_PIT_MAX) {
            gain = GAIN_PIT_MAX;
        }
        return gain;
    }

    static int enc_lag3(int T0, int T0_frac, IntReference T0_min, IntReference T0_max, int pit_min, int pit_max, int pit_flag) {
        int index;
        int _T0_min = T0_min.value;
        int _T0_max = T0_max.value;
        if (pit_flag == 0) {
            index = T0 <= 85 ? T0 * 3 - 58 + T0_frac : T0 + 112;
            _T0_min = T0 - 5;
            if (_T0_min < pit_min) {
                _T0_min = pit_min;
            }
            if ((_T0_max = _T0_min + 9) > pit_max) {
                _T0_max = pit_max;
                _T0_min = _T0_max - 9;
            }
        } else {
            index = T0 - _T0_min;
            index = index * 3 + 2 + T0_frac;
        }
        T0_min.value = _T0_min;
        T0_max.value = _T0_max;
        return index;
    }

    private static float interpol_3(float[] x, int x_offset, int frac) {
        int L_INTER4 = 4;
        int UP_SAMP = 3;
        float[] inter_3 = TabLd8k.inter_3;
        if (frac < 0) {
            frac += UP_SAMP;
            --x_offset;
        }
        int x1 = x_offset;
        int x2 = x_offset + 1;
        int c1 = frac;
        int c2 = UP_SAMP - frac;
        float s = 0.0f;
        int i = 0;
        while (i < L_INTER4) {
            s += x[x1] * inter_3[c1] + x[x2] * inter_3[c2];
            --x1;
            ++x2;
            ++i;
            c1 += UP_SAMP;
            c2 += UP_SAMP;
        }
        return s;
    }

    private static float inv_sqrt(float x) {
        return 1.0f / (float)Math.sqrt(x);
    }
}

