/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.nio.charset.StandardCharsets;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.JNIUtils;
import org.jitsi.utils.logging.Logger;

public class CoreAudioDevice {
    private static final Logger logger = Logger.getLogger(CoreAudioDevice.class);
    public static boolean isLoaded;
    private static Runnable devicesChangedCallback;

    public static native void freeDevices();

    public static String getDeviceModelIdentifier(String deviceUID) {
        if (deviceUID == null) {
            throw new NullPointerException("deviceUID");
        }
        byte[] deviceModelIdentifierBytes = CoreAudioDevice.getDeviceModelIdentifierBytes(deviceUID);
        return CoreAudioDevice.newString(deviceModelIdentifierBytes);
    }

    public static native byte[] getDeviceModelIdentifierBytes(String var0);

    public static String getDeviceName(String deviceUID) {
        byte[] deviceNameBytes = CoreAudioDevice.getDeviceNameBytes(deviceUID);
        return CoreAudioDevice.newString(deviceNameBytes);
    }

    public static native byte[] getDeviceNameBytes(String var0);

    public static native float getInputDeviceVolume(String var0);

    public static native float getOutputDeviceVolume(String var0);

    public static native int initDevices();

    public static native int setInputDeviceVolume(String var0, float var1);

    public static native int setOutputDeviceVolume(String var0, float var1);

    public static void devicesChangedCallback() {
        Runnable devicesChangedCallback = CoreAudioDevice.devicesChangedCallback;
        if (devicesChangedCallback != null) {
            devicesChangedCallback.run();
        }
    }

    public static void setDevicesChangedCallback(Runnable devicesChangedCallback) {
        CoreAudioDevice.devicesChangedCallback = devicesChangedCallback;
    }

    public static void log(byte[] error) {
        String errorString = CoreAudioDevice.newString(error);
        logger.info((Object)errorString);
    }

    protected static String newString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        boolean isLoaded = false;
        try {
            String libname = null;
            if (OSUtils.IS_MAC) {
                libname = "jnmaccoreaudio";
            } else if (OSUtils.IS_WINDOWS) {
                libname = "jnwincoreaudio";
            }
            if (libname != null) {
                JNIUtils.loadLibrary((String)libname, CoreAudioDevice.class);
                isLoaded = true;
            }
        }
        catch (NullPointerException | SecurityException | UnsatisfiedLinkError npe) {
            logger.info((Object)"Failed to load CoreAudioDevice library: ", npe);
        }
        CoreAudioDevice.isLoaded = isLoaded;
    }
}

