/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import org.jitsi.impl.neomedia.transform.fec.FlexFec03Header;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03Mask;
import org.jitsi.util.RTPUtils;

public class FlexFec03HeaderReader {
    private static int HEADER_MIN_SIZE_BYTES = 20;
    private static int MASK_START_OFFSET_BYTES = 18;

    public static FlexFec03Header readFlexFecHeader(byte[] buffer, int flexFecOffset, int length) {
        FlexFec03Mask mask;
        boolean retransmissionBit;
        if (length < HEADER_MIN_SIZE_BYTES) {
            return null;
        }
        boolean bl = retransmissionBit = (buffer[flexFecOffset] & 0x80) >> 7 == 1;
        if (retransmissionBit) {
            return null;
        }
        int maskType = (buffer[flexFecOffset] & 0x40) >> 6;
        if (maskType != 0) {
            return null;
        }
        int ssrcCount = buffer[flexFecOffset + 8] & 0xFF;
        if (ssrcCount > 1) {
            return null;
        }
        long protectedSsrc = RTPUtils.readUint32AsLong(buffer, flexFecOffset + 12);
        int seqNumBase = RTPUtils.readUint16AsInt(buffer, flexFecOffset + 16);
        try {
            mask = new FlexFec03Mask(buffer, flexFecOffset + MASK_START_OFFSET_BYTES, seqNumBase);
        }
        catch (FlexFec03Mask.MalformedMaskException e) {
            return null;
        }
        int flexFecHeaderSize = HEADER_MIN_SIZE_BYTES - 2 + mask.lengthBytes();
        return new FlexFec03Header(protectedSsrc, seqNumBase, mask.getProtectedSeqNums(), flexFecHeaderSize);
    }
}

