/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.tls.DTLSClientProtocol;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSServerProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DatagramTransportImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsTransformEngine;
import org.jitsi.impl.neomedia.transform.dtls.DtlsUtils;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.impl.neomedia.transform.dtls.TlsClientImpl;
import org.jitsi.impl.neomedia.transform.dtls.TlsServerImpl;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpPolicy;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class DtlsPacketTransformer
implements PacketTransformer,
PropertyChangeListener {
    private static final long CONNECT_RETRY_INTERVAL = 500L;
    private static final int CONNECT_TRIES = 3;
    private static final boolean DROP_UNENCRYPTED_PKTS;
    private static final String DROP_UNENCRYPTED_PKTS_PNAME;
    static final int DTLS_RECORD_HEADER_LENGTH = 13;
    private static final int DTLS_TRANSPORT_RECEIVE_WAITMILLIS = -1;
    private static final org.jitsi.utils.logging.Logger logger;
    private static final int TRANSFORM_QUEUE_CAPACITY;
    private final int componentID;
    private AbstractRTPConnector connector;
    private Thread connectThread;
    private DatagramTransportImpl datagramTransport;
    private DTLSTransport dtlsTransport;
    private MediaType mediaType;
    private final LinkedList<RawPacket> _reverseTransformSrtpQueue = new LinkedList();
    private boolean rtcpmux;
    private SinglePacketTransformer _srtpTransformer;
    private long _srtpTransformerLastChanged = -1L;
    private boolean tlsPeerHasRaisedCloseNotifyWarning;
    private final LinkedList<RawPacket> _transformSrtpQueue = new LinkedList();
    private final DtlsTransformEngine transformEngine;
    private boolean started = false;

    public static boolean isDtlsRecord(byte[] buf, int off, int len) {
        if (len >= 13) {
            short type = TlsUtils.readUint8((byte[])buf, (int)off);
            switch (type) {
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    int length;
                    int major = buf[off + 1] & 0xFF;
                    int minor = buf[off + 2] & 0xFF;
                    ProtocolVersion version = ProtocolVersion.get((int)major, (int)minor);
                    if (!version.isDTLS() || 13 + (length = TlsUtils.readUint16((byte[])buf, (int)(off + 11))) > len) break;
                    return true;
                }
            }
        }
        return false;
    }

    public DtlsPacketTransformer(DtlsTransformEngine transformEngine, int componentID) {
        this.transformEngine = transformEngine;
        this.componentID = componentID;
        this.getProperties().addPropertyChangeListener(this);
        this.propertyChange((String)null);
    }

    @Override
    public synchronized void close() {
        this.getProperties().removePropertyChangeListener(this);
        this.setMediaType(null);
        this.setConnector(null);
    }

    private void closeDatagramTransport() {
        if (this.datagramTransport != null) {
            this.datagramTransport.close();
            this.datagramTransport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterRunInConnectThreadLoop(int i, DatagramTransport datagramTransport) {
        if (i < 0 || i > 3) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        DtlsPacketTransformer dtlsPacketTransformer = this;
        synchronized (dtlsPacketTransformer) {
            if (i > 0 && i < 2) {
                boolean interrupted = false;
                try {
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (interrupted) {
                    currentThread.interrupt();
                }
            }
            return currentThread.equals(this.connectThread) && datagramTransport.equals(this.datagramTransport);
        }
    }

    DtlsControlImpl getDtlsControl() {
        return this.getTransformEngine().getDtlsControl();
    }

    Properties getProperties() {
        return this.getTransformEngine().getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SinglePacketTransformer getSRTPTransformer() {
        SinglePacketTransformer srtpTransformer = this._srtpTransformer;
        if (srtpTransformer != null) {
            return srtpTransformer;
        }
        if (this.rtcpmux && 1 == this.componentID) {
            return this.initializeSRTCPTransformerFromRtp();
        }
        boolean yield = true;
        while (true) {
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                srtpTransformer = this._srtpTransformer;
                if (srtpTransformer != null) {
                    break;
                }
                if (this.connectThread == null) {
                    break;
                }
            }
            if (!yield) break;
            yield = false;
            Thread.yield();
        }
        return srtpTransformer;
    }

    DtlsTransformEngine getTransformEngine() {
        return this.transformEngine;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleRunInConnectThreadException(IOException ioe, String msg, int i) {
        if (this.mediaType == null) {
            return false;
        }
        if (ioe instanceof TlsFatalAlert) {
            TlsFatalAlert tfa = (TlsFatalAlert)ioe;
            short alertDescription = tfa.getAlertDescription();
            if (alertDescription == 10) {
                msg = (String)msg + " Received fatal unexpected message.";
                if (i != 0 && Thread.currentThread().equals(this.connectThread) && this.connector != null && this.mediaType != null) {
                    msg = (String)msg + " Will retry.";
                    logger.error(msg, (Throwable)ioe);
                    return true;
                }
                msg = (String)msg + " Giving up after " + (3 - i) + " retries.";
            } else {
                msg = (String)msg + " Received fatal alert " + alertDescription + ".";
            }
        }
        logger.error(msg, (Throwable)ioe);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SinglePacketTransformer initializeSRTCPTransformerFromRtp() {
        SinglePacketTransformer srtpTransformer;
        DtlsPacketTransformer rtpTransformer = (DtlsPacketTransformer)this.getTransformEngine().getRTPTransformer();
        if (rtpTransformer != this && (srtpTransformer = rtpTransformer.getSRTPTransformer()) instanceof SRTPTransformer) {
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                if (this._srtpTransformer == null) {
                    this.setSrtpTransformer(new SRTCPTransformer((SRTPTransformer)srtpTransformer));
                }
            }
        }
        return this._srtpTransformer;
    }

    SinglePacketTransformer initializeSRTPTransformer(int srtpProtectionProfile, TlsContext tlsContext) {
        SrtpContextFactory reverseSrtpContextFactory;
        SrtpContextFactory forwardSrtpContextFactory;
        int RTP_auth_tag_length;
        int RTCP_auth_tag_length;
        int auth_key_length;
        int auth_function;
        int cipher;
        int cipher_salt_length;
        int cipher_key_length;
        boolean rtcp;
        switch (this.componentID) {
            case 1: {
                rtcp = true;
                break;
            }
            case 0: {
                rtcp = false;
                break;
            }
            default: {
                throw new IllegalStateException("componentID");
            }
        }
        switch (srtpProtectionProfile) {
            case 2: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 1: {
                cipher_key_length = 16;
                cipher_salt_length = 14;
                cipher = 1;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            case 6: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTCP_auth_tag_length = 10;
                RTP_auth_tag_length = 4;
                break;
            }
            case 5: {
                cipher_key_length = 0;
                cipher_salt_length = 0;
                cipher = 0;
                auth_function = 1;
                auth_key_length = 20;
                RTP_auth_tag_length = 10;
                RTCP_auth_tag_length = 10;
                break;
            }
            default: {
                throw new IllegalArgumentException("srtpProtectionProfile");
            }
        }
        byte[] keyingMaterial = tlsContext.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (cipher_key_length + cipher_salt_length));
        byte[] client_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] server_write_SRTP_master_key = new byte[cipher_key_length];
        byte[] client_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[] server_write_SRTP_master_salt = new byte[cipher_salt_length];
        byte[][] keyingMaterialValues = new byte[][]{client_write_SRTP_master_key, server_write_SRTP_master_key, client_write_SRTP_master_salt, server_write_SRTP_master_salt};
        int keyingMaterialOffset = 0;
        for (int i = 0; i < keyingMaterialValues.length; ++i) {
            byte[] keyingMaterialValue = keyingMaterialValues[i];
            System.arraycopy(keyingMaterial, keyingMaterialOffset, keyingMaterialValue, 0, keyingMaterialValue.length);
            keyingMaterialOffset += keyingMaterialValue.length;
        }
        SrtpPolicy srtcpPolicy = new SrtpPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTCP_auth_tag_length, cipher_salt_length);
        SrtpPolicy srtpPolicy = new SrtpPolicy(cipher, cipher_key_length, auth_function, auth_key_length, RTP_auth_tag_length, cipher_salt_length);
        LoggerImpl logger2 = new LoggerImpl(this.getClass().getName());
        SrtpContextFactory clientSrtpContextFactory = new SrtpContextFactory(tlsContext instanceof TlsClientContext, client_write_SRTP_master_key, client_write_SRTP_master_salt, srtpPolicy, srtcpPolicy, (Logger)logger2);
        SrtpContextFactory serverSrtpContextFactory = new SrtpContextFactory(tlsContext instanceof TlsServerContext, server_write_SRTP_master_key, server_write_SRTP_master_salt, srtpPolicy, srtcpPolicy, (Logger)logger2);
        if (tlsContext instanceof TlsClientContext) {
            forwardSrtpContextFactory = clientSrtpContextFactory;
            reverseSrtpContextFactory = serverSrtpContextFactory;
        } else if (tlsContext instanceof TlsServerContext) {
            forwardSrtpContextFactory = serverSrtpContextFactory;
            reverseSrtpContextFactory = clientSrtpContextFactory;
        } else {
            throw new IllegalArgumentException("tlsContext");
        }
        SinglePacketTransformer srtpTransformer = rtcp ? new SRTCPTransformer(forwardSrtpContextFactory, reverseSrtpContextFactory) : new SRTPTransformer(forwardSrtpContextFactory, reverseSrtpContextFactory);
        return srtpTransformer;
    }

    private boolean isSrtpDisabled() {
        return this.getProperties().isSrtpDisabled();
    }

    private synchronized void maybeStart() {
        if (this.mediaType != null && this.connector != null && !this.started) {
            this.start();
        }
    }

    void notifyAlertRaised(TlsPeer tlsPeer, short alertLevel, short alertDescription, String message, Throwable cause) {
        if (1 == alertLevel && 0 == alertDescription) {
            this.tlsPeerHasRaisedCloseNotifyWarning = true;
        } else {
            logger.debug((Object)("TLS alert, level=" + alertLevel + ", description=" + alertDescription + ", message=" + message), cause);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.propertyChange(ev.getPropertyName());
    }

    private void propertyChange(String propertyName) {
        if (propertyName == null) {
            this.propertyChange(Properties.RTCPMUX_PNAME);
            this.propertyChange(Properties.MEDIA_TYPE_PNAME);
            this.propertyChange(Properties.CONNECTOR_PNAME);
        } else if (Properties.CONNECTOR_PNAME.equals(propertyName)) {
            this.setConnector((AbstractRTPConnector)this.getProperties().get(propertyName));
        } else if (Properties.MEDIA_TYPE_PNAME.equals(propertyName)) {
            this.setMediaType((MediaType)this.getProperties().get(propertyName));
        } else if (Properties.RTCPMUX_PNAME.equals(propertyName)) {
            Object newValue = this.getProperties().get(propertyName);
            this.setRtcpmux(newValue != null && (Boolean)newValue != false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTransformSrtp(RawPacket[] pkts, boolean transform) {
        if (pkts != null) {
            LinkedList<RawPacket> q;
            LinkedList<RawPacket> linkedList = q = transform ? this._transformSrtpQueue : this._reverseTransformSrtpQueue;
            synchronized (linkedList) {
                for (RawPacket pkt : pkts) {
                    if (pkt == null) continue;
                    while (q.size() >= TRANSFORM_QUEUE_CAPACITY && q.poll() != null) {
                    }
                    q.add(pkt);
                }
            }
        }
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        return this.transform(pkts, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reverseTransformDtls(RawPacket pkt, List<RawPacket> outPkts) {
        block12: {
            if (this.rtcpmux && 1 == this.componentID) {
                logger.warn((Object)"Dropping a DTLS packet, because it was received on the RTCP channel while rtcpmux is in use.");
                return;
            }
            DtlsPacketTransformer dtlsPacketTransformer = this;
            synchronized (dtlsPacketTransformer) {
                if (this.datagramTransport == null) {
                    logger.warn((Object)"Dropping a DTLS packet. This DtlsPacketTransformer has not been started successfully or has been closed.");
                } else {
                    this.datagramTransport.queueReceive(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
                }
            }
            if (outPkts == null) {
                return;
            }
            DTLSTransport dtlsTransport = this.dtlsTransport;
            if (dtlsTransport != null) {
                try {
                    while (true) {
                        int receiveLimit = dtlsTransport.getReceiveLimit();
                        byte[] buf = new byte[receiveLimit];
                        RawPacket p = new RawPacket(buf, 0, buf.length);
                        int received = dtlsTransport.receive(buf, 0, buf.length, -1);
                        if (received > 0) {
                            p.setLength(received);
                            outPkts.add(p);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    if (this.mediaType == null || this.tlsPeerHasRaisedCloseNotifyWarning) break block12;
                    logger.error((Object)"Failed to decode a DTLS record!", (Throwable)ioe);
                }
            }
        }
    }

    private void runInConnectThread(DTLSProtocol dtlsProtocol, TlsPeer tlsPeer, DatagramTransport datagramTransport) {
        if (dtlsProtocol instanceof DTLSClientProtocol) {
            DTLSClientProtocol dtlsClientProtocol = (DTLSClientProtocol)dtlsProtocol;
            TlsClientImpl tlsClient = (TlsClientImpl)tlsPeer;
            for (int i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    this.dtlsTransport = dtlsClientProtocol.connect((TlsClient)tlsClient, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (this.handleRunInConnectThreadException(ioe, "Failed to connect this DTLS client to a DTLS server!", i)) {
                        continue;
                    }
                    break;
                }
            }
        } else if (dtlsProtocol instanceof DTLSServerProtocol) {
            DTLSServerProtocol dtlsServerProtocol = (DTLSServerProtocol)dtlsProtocol;
            TlsServerImpl tlsServer = (TlsServerImpl)tlsPeer;
            for (int i = 2; i >= 0 && this.enterRunInConnectThreadLoop(i, datagramTransport); --i) {
                try {
                    this.dtlsTransport = dtlsServerProtocol.accept((TlsServer)tlsServer, datagramTransport);
                    break;
                }
                catch (IOException ioe) {
                    if (this.handleRunInConnectThreadException(ioe, "Failed to accept a connection from a DTLS client!", i)) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            throw new IllegalStateException("dtlsProtocol");
        }
    }

    public void sendApplicationData(byte[] buf, int off, int len) {
        DTLSTransport dtlsTransport = this.dtlsTransport;
        Exception throwable = null;
        if (dtlsTransport != null) {
            try {
                dtlsTransport.send(buf, off, len);
            }
            catch (IOException ioe) {
                throwable = ioe;
            }
        } else {
            throwable = new NullPointerException("dtlsTransport");
        }
        if (throwable != null && this.mediaType != null && !this.tlsPeerHasRaisedCloseNotifyWarning) {
            logger.error((Object)"Failed to send application data over DTLS transport: ", (Throwable)throwable);
        }
    }

    private synchronized void setConnector(AbstractRTPConnector connector) {
        if (this.connector != connector) {
            this.connector = connector;
            DatagramTransportImpl datagramTransport = this.datagramTransport;
            if (datagramTransport != null) {
                datagramTransport.setConnector(connector);
            }
            if (connector != null) {
                this.maybeStart();
            }
        }
    }

    private synchronized void setMediaType(MediaType mediaType) {
        if (this.mediaType != mediaType) {
            MediaType oldValue = this.mediaType;
            this.mediaType = mediaType;
            if (oldValue != null) {
                this.stop();
            }
            if (this.mediaType != null) {
                this.maybeStart();
            }
        }
    }

    void setRtcpmux(boolean rtcpmux) {
        this.rtcpmux = rtcpmux;
    }

    synchronized void setSrtpTransformer(SinglePacketTransformer srtpTransformer) {
        if (this._srtpTransformer != srtpTransformer) {
            SinglePacketTransformer oldTransformer = this._srtpTransformer;
            if (oldTransformer != null) {
                oldTransformer.close();
            }
            this._srtpTransformer = srtpTransformer;
            this._srtpTransformerLastChanged = System.currentTimeMillis();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void start() {
        Object tlsPeer;
        DTLSClientProtocol dtlsProtocolObj;
        if (this.datagramTransport != null) {
            if (this.connectThread == null && this.dtlsTransport == null) {
                logger.warn((Object)(this.getClass().getName() + " has been started but has failed to establish the DTLS connection!"));
            }
            return;
        }
        if (this.rtcpmux && 1 == this.componentID) {
            return;
        }
        AbstractRTPConnector connector = this.connector;
        this.started = true;
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        DtlsControl.Setup setup = this.getProperties().getSetup();
        if (DtlsControl.Setup.ACTIVE.equals((Object)setup)) {
            dtlsProtocolObj = new DTLSClientProtocol();
            tlsPeer = new TlsClientImpl(this);
        } else {
            dtlsProtocolObj = new DTLSServerProtocol();
            tlsPeer = new TlsServerImpl(this);
        }
        this.tlsPeerHasRaisedCloseNotifyWarning = false;
        DatagramTransportImpl datagramTransport = new DatagramTransportImpl(this.componentID);
        datagramTransport.setConnector(connector);
        Thread connectThread = new Thread((DTLSProtocol)dtlsProtocolObj, (TlsPeer)tlsPeer, datagramTransport){
            final /* synthetic */ DTLSProtocol val$dtlsProtocolObj;
            final /* synthetic */ TlsPeer val$tlsPeer;
            final /* synthetic */ DatagramTransportImpl val$datagramTransport;
            {
                this.val$dtlsProtocolObj = dTLSProtocol;
                this.val$tlsPeer = tlsPeer;
                this.val$datagramTransport = datagramTransportImpl;
            }

            @Override
            public void run() {
                try {
                    DtlsPacketTransformer.this.runInConnectThread(this.val$dtlsProtocolObj, this.val$tlsPeer, this.val$datagramTransport);
                }
                finally {
                    if (Thread.currentThread().equals(DtlsPacketTransformer.this.connectThread)) {
                        DtlsPacketTransformer.this.connectThread = null;
                    }
                }
            }
        };
        connectThread.setDaemon(true);
        connectThread.setName(DtlsPacketTransformer.class.getName() + ".connectThread");
        this.connectThread = connectThread;
        this.datagramTransport = datagramTransport;
        boolean started = false;
        try {
            connectThread.start();
            started = true;
        }
        finally {
            if (!started) {
                if (connectThread.equals(this.connectThread)) {
                    this.connectThread = null;
                }
                if (datagramTransport.equals(this.datagramTransport)) {
                    this.datagramTransport = null;
                }
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop() {
        this.started = false;
        if (this.connectThread != null) {
            this.connectThread = null;
        }
        try {
            if (this.dtlsTransport != null) {
                try {
                    this.dtlsTransport.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)("Failed to (properly) close " + this.dtlsTransport.getClass()), (Throwable)ioe);
                }
                this.dtlsTransport = null;
            }
            if (this._srtpTransformer != null) {
                this._srtpTransformer.close();
                this._srtpTransformer = null;
            }
        }
        finally {
            try {
                this.closeDatagramTransport();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return this.transform(pkts, true);
    }

    private RawPacket[] transform(RawPacket[] inPkts, boolean transform) {
        List<RawPacket> outPkts = new ArrayList<RawPacket>();
        outPkts = this.transformDtls(inPkts, transform, outPkts);
        outPkts = this.transformNonDtls(inPkts, transform, outPkts);
        return outPkts.toArray(new RawPacket[0]);
    }

    private List<RawPacket> transformDtls(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        if (inPkts != null) {
            for (int i = 0; i < inPkts.length; ++i) {
                int len;
                int off;
                byte[] buf;
                RawPacket inPkt = inPkts[i];
                if (inPkt == null || !DtlsPacketTransformer.isDtlsRecord(buf = inPkt.getBuffer(), off = inPkt.getOffset(), len = inPkt.getLength())) continue;
                if (transform) {
                    outPkts.add(inPkt);
                } else {
                    this.reverseTransformDtls(inPkt, outPkts);
                }
                inPkts[i] = null;
            }
        }
        return outPkts;
    }

    private List<RawPacket> transformNonDtls(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        if (this.isSrtpDisabled()) {
            if (transform) {
                outPkts = this.transformNonSrtp(inPkts, outPkts);
            }
        } else {
            this.transformSrtp(inPkts, transform, outPkts);
        }
        return outPkts;
    }

    private List<RawPacket> transformNonSrtp(RawPacket[] inPkts, List<RawPacket> outPkts) {
        if (inPkts != null) {
            for (RawPacket inPkt : inPkts) {
                if (inPkt == null) continue;
                byte[] buf = inPkt.getBuffer();
                int off = inPkt.getOffset();
                int len = inPkt.getLength();
                this.sendApplicationData(buf, off, len);
            }
        }
        return outPkts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformSrtp(RawPacket[] inPkts, boolean transform, List<RawPacket> outPkts) {
        SinglePacketTransformer srtpTransformer = this.getSRTPTransformer();
        if (srtpTransformer == null) {
            if (!DROP_UNENCRYPTED_PKTS) {
                this.queueTransformSrtp(inPkts, transform);
            }
        } else {
            LinkedList<RawPacket> q;
            LinkedList<RawPacket> linkedList = q = transform ? this._transformSrtpQueue : this._reverseTransformSrtpQueue;
            if (q.size() > 0) {
                LinkedList<RawPacket> linkedList2 = q;
                synchronized (linkedList2) {
                    RawPacket template = inPkts != null && inPkts.length > 0 ? inPkts[0] : null;
                    try {
                        this.transformSrtp(srtpTransformer, q, transform, outPkts, template);
                    }
                    finally {
                        this.clearQueue(q, template);
                    }
                }
            }
            if (inPkts != null && inPkts.length != 0) {
                this.transformSrtp(srtpTransformer, Arrays.asList(inPkts), transform, outPkts, null);
            }
        }
    }

    private void transformSrtp(SinglePacketTransformer srtpTransformer, Collection<RawPacket> inPkts, boolean transform, List<RawPacket> outPkts, RawPacket template) {
        for (RawPacket inPkt : inPkts) {
            RawPacket outPkt;
            if (inPkt == null || !this.match(template, inPkt) || (outPkt = transform ? srtpTransformer.transform(inPkt) : srtpTransformer.reverseTransform(inPkt)) == null) continue;
            outPkts.add(outPkt);
        }
    }

    private void clearQueue(LinkedList<RawPacket> q, RawPacket template) {
        long srtpTransformerLastChanged = this._srtpTransformerLastChanged;
        if (srtpTransformerLastChanged >= 0L && System.currentTimeMillis() - srtpTransformerLastChanged > 3000L) {
            q.clear();
            return;
        }
        q.removeIf(rawPacket -> this.match(template, (RawPacket)rawPacket));
    }

    private boolean match(RawPacket template, RawPacket pkt) {
        if (template == null) {
            return true;
        }
        if (pkt == null) {
            return false;
        }
        if (RTPPacketPredicate.INSTANCE.test(template)) {
            return template.getSSRC() == pkt.getSSRC() || template.getPayloadType() == pkt.getPayloadType();
        }
        if (RTCPPacketPredicate.INSTANCE.test(template)) {
            return template.getRTCPSSRC() == pkt.getRTCPSSRC();
        }
        return true;
    }

    private static byte[] exportKeyingMaterial(TlsContext context, String asciiLabel, byte[] context_value, int length, byte[] masterSecret) {
        if (context_value != null && !TlsUtils.isValidUint16((int)context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = context.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16((int)context_value.length, (byte[])seed, (int)seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF((SecurityParameters)context.getSecurityParametersHandshake(), (TlsSecret)new BcTlsSecret(DtlsUtils.BC_TLS_CRYPTO, masterSecret), (String)asciiLabel, (byte[])seed, (int)length).extract();
    }

    static {
        DROP_UNENCRYPTED_PKTS_PNAME = DtlsPacketTransformer.class.getName() + ".dropUnencryptedPkts";
        logger = org.jitsi.utils.logging.Logger.getLogger(DtlsPacketTransformer.class);
        TRANSFORM_QUEUE_CAPACITY = RTPConnectorOutputStream.PACKET_QUEUE_CAPACITY;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        DROP_UNENCRYPTED_PKTS = ConfigUtils.getBoolean((ConfigurationService)cfg, (String)DROP_UNENCRYPTED_PKTS_PNAME, (boolean)false);
    }
}

