/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;

public class CaptureDeviceInfo2
extends CaptureDeviceInfo {
    private final String transportType;
    private final String uid;
    private final String modelIdentifier;

    public CaptureDeviceInfo2(CaptureDeviceInfo captureDeviceInfo, String uid, String transportType, String modelIdentifier) {
        this(captureDeviceInfo.getName(), captureDeviceInfo.getLocator(), captureDeviceInfo.getFormats(), uid, transportType, modelIdentifier);
    }

    public CaptureDeviceInfo2(String name, MediaLocator locator, Format[] formats, String uid, String transportType, String modelIdentifier) {
        super(name, locator, formats);
        this.uid = uid;
        this.transportType = transportType;
        this.modelIdentifier = modelIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CaptureDeviceInfo2) {
            CaptureDeviceInfo2 cdi2 = (CaptureDeviceInfo2)((Object)obj);
            MediaLocator locator = this.getLocator();
            MediaLocator cdi2Locator = cdi2.getLocator();
            if (locator == null) {
                if (cdi2Locator != null) {
                    return false;
                }
            } else {
                if (cdi2Locator == null) {
                    return false;
                }
                String protocol = locator.getProtocol();
                String cdi2Protocol = cdi2Locator.getProtocol();
                if (protocol == null) {
                    if (cdi2Protocol != null) {
                        return false;
                    }
                } else {
                    if (cdi2Protocol == null) {
                        return false;
                    }
                    if (!protocol.equals(cdi2Protocol)) {
                        return false;
                    }
                }
            }
            return this.getIdentifier().equals(cdi2.getIdentifier());
        }
        return false;
    }

    public String getIdentifier() {
        return this.uid == null ? this.name : this.uid;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public String getUID() {
        return this.uid != null ? this.uid : this.getModelIdentifier();
    }

    public String getModelIdentifier() {
        return this.modelIdentifier == null ? this.name : this.modelIdentifier;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public boolean isSameTransportType(String transportType) {
        return this.transportType == null ? transportType == null : this.transportType.equals(transportType);
    }
}

