/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.CertificateInfo;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsUtils;
import org.jitsi.utils.logging.Logger;

public class TlsClientImpl
extends DefaultTlsClient {
    private static final Logger logger = Logger.getLogger(TlsClientImpl.class);
    private final TlsAuthentication authentication = new TlsAuthenticationImpl();
    private int chosenProtectionProfile;
    private final byte[] mki = TlsUtils.EMPTY_BYTES;
    private final DtlsPacketTransformer packetTransformer;

    public TlsClientImpl(DtlsPacketTransformer packetTransformer) {
        super((TlsCrypto)DtlsUtils.BC_TLS_CRYPTO);
        this.packetTransformer = packetTransformer;
    }

    public synchronized TlsAuthentication getAuthentication() {
        return this.authentication;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.DTLSv12.only();
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        if (!this.isSrtpDisabled() && TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions) == null) {
            if (clientExtensions == null) {
                clientExtensions = new Hashtable();
            }
            TlsSRTPUtils.addUseSRTPExtension(clientExtensions, (UseSRTPData)new UseSRTPData(DtlsControlImpl.SRTP_PROTECTION_PROFILES, this.mki));
        }
        return clientExtensions;
    }

    private boolean isSrtpDisabled() {
        return this.packetTransformer.getProperties().isSrtpDisabled();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        this.packetTransformer.notifyAlertRaised((TlsPeer)this, alertLevel, alertDescription, message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyHandshakeComplete() {
        if (this.packetTransformer.getProperties().isSrtpDisabled()) {
            return;
        }
        SinglePacketTransformer srtpTransformer = this.packetTransformer.initializeSRTPTransformer(this.chosenProtectionProfile, (TlsContext)this.context);
        DtlsPacketTransformer dtlsPacketTransformer = this.packetTransformer;
        synchronized (dtlsPacketTransformer) {
            this.packetTransformer.setSrtpTransformer(srtpTransformer);
        }
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        int chosenProtectionProfile;
        if (this.isSrtpDisabled()) {
            super.processServerExtensions(serverExtensions);
            return;
        }
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions);
        if (useSRTPData == null) {
            String msg = "DTLS extended server hello does not include the use_srtp extension!";
            IOException ioe = new IOException(msg);
            logger.error((Object)msg, (Throwable)ioe);
            throw ioe;
        }
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        int n = chosenProtectionProfile = protectionProfiles.length == 1 ? DtlsControlImpl.chooseSRTPProtectionProfile(protectionProfiles[0]) : 0;
        if (chosenProtectionProfile == 0) {
            String msg = "No chosen SRTP protection profile!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error((Object)msg, (Throwable)tfa);
            throw tfa;
        }
        byte[] mki = useSRTPData.getMki();
        if (!Arrays.equals(mki, this.mki)) {
            String msg = "Server's MKI does not match the one offered by this client!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error((Object)msg, (Throwable)tfa);
            throw tfa;
        }
        super.processServerExtensions(serverExtensions);
        this.chosenProtectionProfile = chosenProtectionProfile;
    }

    private class TlsAuthenticationImpl
    implements TlsAuthentication {
        private TlsCredentials clientCredentials;

        private TlsAuthenticationImpl() {
        }

        public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) {
            if (this.clientCredentials == null) {
                CertificateInfo certificateInfo = TlsClientImpl.this.packetTransformer.getDtlsControl().getCertificateInfo();
                String algName = new DefaultAlgorithmNameFinder().getAlgorithmName(new ASN1ObjectIdentifier(certificateInfo.getCertificate().getCertificateAt(0).getSigAlgOID()));
                SignatureAndHashAlgorithm sigAndHashAlg = null;
                switch (algName) {
                    case "SHA1WITHRSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)2, (short)1);
                        break;
                    }
                    case "SHA224WITHRSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)3, (short)1);
                        break;
                    }
                    case "SHA256WITHRSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)4, (short)1);
                        break;
                    }
                    case "SHA384WITHRSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)5, (short)1);
                        break;
                    }
                    case "SHA512WITHRSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)6, (short)1);
                        break;
                    }
                    case "SHA1WITHECDSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)2, (short)3);
                        break;
                    }
                    case "SHA224WITHECDSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)3, (short)3);
                        break;
                    }
                    case "SHA256WITHECDSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)4, (short)3);
                        break;
                    }
                    case "SHA384WITHECDSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)5, (short)3);
                        break;
                    }
                    case "SHA512WITHECDSA": {
                        sigAndHashAlg = SignatureAndHashAlgorithm.getInstance((short)6, (short)3);
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unknown algOid in certificate: " + algName));
                        return null;
                    }
                }
                this.clientCredentials = new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)TlsClientImpl.this.context), (BcTlsCrypto)TlsClientImpl.this.context.getCrypto(), certificateInfo.getKeyPair().getPrivate(), certificateInfo.getCertificate(), sigAndHashAlg);
            }
            return this.clientCredentials;
        }

        public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
            try {
                TlsClientImpl.this.packetTransformer.getDtlsControl().verifyAndValidateCertificate(serverCertificate.getCertificate());
            }
            catch (Exception e) {
                logger.error((Object)"Failed to verify and/or validate server certificate!", (Throwable)e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }
}

