/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import javax.media.rtp.OutputDataStream;
import org.jitsi.impl.neomedia.transform.AbstractTransformOutputStream;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.service.neomedia.RawPacket;

public class TransformOutputStreamImpl
extends AbstractTransformOutputStream {
    private final OutputDataStream _outputDataStream;
    private TransformEngineChain.PacketTransformerChain _transformerAsChain;

    public TransformOutputStreamImpl(OutputDataStream outputDataStream) {
        this._outputDataStream = outputDataStream;
    }

    @Override
    public final void setTransformer(PacketTransformer transformer) {
        if (this.getTransformer() != transformer) {
            super.setTransformer(transformer);
            transformer = this.getTransformer();
            this._transformerAsChain = transformer instanceof TransformEngineChain.PacketTransformerChain ? (TransformEngineChain.PacketTransformerChain)transformer : null;
        }
    }

    protected RawPacket[] transform(RawPacket[] pkts, Object after) {
        TransformEngineChain.PacketTransformerChain transformerAsChain;
        if (after != null && (transformerAsChain = this._transformerAsChain) != null) {
            return transformerAsChain.transform(pkts, (TransformEngine)after);
        }
        return this.transform(pkts);
    }

    public int write(byte[] buf, int off, int len) {
        return this._outputDataStream.write(buf, off, len);
    }
}

