/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.rtcp.RTCPTCCPacket;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTCPPacketListenerAdapter;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorAbsSendTime;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.ByteArrayBufferImpl;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.rtp.CallStatsObserver;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.logging.TimeSeriesLogger;

public class TransportCCEngine
extends RTCPPacketListenerAdapter
implements RemoteBitrateObserver,
CallStatsObserver {
    private static final int MAX_INCOMING_PACKETS_HISTORY = 200;
    private static final int MAX_OUTGOING_PACKETS_HISTORY = 1000;
    private static final Logger logger = Logger.getLogger(TransportCCEngine.class);
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(TransportCCEngine.class);
    private final IngressEngine ingressEngine = new IngressEngine();
    private final EgressEngine egressEngine = new EgressEngine();
    private int extensionId = -1;
    private AtomicInteger outgoingSeq = new AtomicInteger(1);
    private AtomicInteger outgoingFbPacketCount = new AtomicInteger();
    private final List<MediaStream> mediaStreams = new LinkedList<MediaStream>();
    private VideoMediaStream anyVideoMediaStream;
    private RTCPTCCPacket.PacketMap incomingPackets;
    private final Object incomingPacketsSyncRoot = new Object();
    private final Object sentPacketsSyncRoot = new Object();
    private final DiagnosticContext diagnosticContext;
    private long firstIncomingTs = -1L;
    private long remoteReferenceTimeMs = -1L;
    private long localReferenceTimeMs = -1L;
    private Map<Integer, PacketDetail> sentPacketDetails = new LRUCache(1000);
    private final RemoteBitrateEstimatorAbsSendTime bitrateEstimatorAbsSendTime;

    public TransportCCEngine(@NotNull DiagnosticContext diagnosticContext) {
        this.diagnosticContext = diagnosticContext;
        this.bitrateEstimatorAbsSendTime = new RemoteBitrateEstimatorAbsSendTime(this, diagnosticContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packetReceived(int seq, int pt, boolean marked) {
        long now = System.currentTimeMillis();
        Object object = this.incomingPacketsSyncRoot;
        synchronized (object) {
            if (this.incomingPackets == null) {
                this.incomingPackets = new RTCPTCCPacket.PacketMap();
            }
            if (this.incomingPackets.size() >= 200) {
                Iterator iter = this.incomingPackets.entrySet().iterator();
                if (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
                logger.info((Object)"Reached max size, removing an entry.");
            }
            if (this.incomingPackets.isEmpty()) {
                this.firstIncomingTs = now;
            }
            this.incomingPackets.put(seq, now);
        }
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("ingress_tcc_pkt", now).addField("seq", (Object)seq).addField("pt", (Object)pt));
        }
        this.maybeSendRtcp(marked, now);
    }

    private long getSourceSSRC() {
        VideoMediaStream stream = this.anyVideoMediaStream;
        if (stream == null) {
            return -1L;
        }
        MediaStreamTrackReceiver receiver = stream.getMediaStreamTrackReceiver();
        if (receiver == null) {
            return -1L;
        }
        MediaStreamTrackDesc[] tracks = receiver.getMediaStreamTracks();
        if (tracks == null || tracks.length == 0) {
            return -1L;
        }
        RTPEncodingDesc[] encodings = tracks[0].getRTPEncodings();
        if (encodings == null || encodings.length == 0) {
            return -1L;
        }
        return encodings[0].getPrimarySSRC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSendRtcp(boolean marked, long now) {
        RTCPTCCPacket.PacketMap packets = null;
        Object object = this.incomingPacketsSyncRoot;
        synchronized (object) {
            if (this.incomingPackets == null || this.incomingPackets.isEmpty()) {
                return;
            }
            long delta = this.firstIncomingTs == -1L ? 0L : now - this.firstIncomingTs;
            int packetCount = 1 + RTPUtils.subtractNumber((Integer)this.incomingPackets.lastKey(), (Integer)this.incomingPackets.firstKey());
            if (delta > 100L || delta > 20L && marked || this.incomingPackets.size() > 100 || packetCount >= 180) {
                packets = this.incomingPackets;
                this.incomingPackets = null;
                this.firstIncomingTs = -1L;
            }
        }
        if (packets != null) {
            MediaStream stream = this.getMediaStream();
            if (stream == null) {
                logger.warn((Object)"No media stream, can't send RTCP.");
                return;
            }
            try {
                long senderSSRC = this.anyVideoMediaStream.getStreamRTPManager().getLocalSSRC();
                if (senderSSRC == -1L) {
                    logger.warn((Object)"No sender SSRC, can't send RTCP.");
                    return;
                }
                long sourceSSRC = this.getSourceSSRC();
                if (sourceSSRC == -1L) {
                    logger.warn((Object)"No source SSRC, can't send RTCP.");
                    return;
                }
                RTCPTCCPacket rtcpPacket = new RTCPTCCPacket(senderSSRC, sourceSSRC, packets, (byte)(this.outgoingFbPacketCount.getAndIncrement() & 0xFF), this.diagnosticContext);
                stream.injectPacket(rtcpPacket.toRawPacket(), false, this.egressEngine);
            }
            catch (IllegalArgumentException iae) {
                logger.warn((Object)"Not sending transport-cc feedback, delta or packetcount too big.");
            }
            catch (IOException | TransmissionFailedException e) {
                logger.error((Object)"Failed to send transport feedback RTCP: ", e);
            }
        }
    }

    @Override
    public void onRttUpdate(long avgRttMs, long maxRttMs) {
        this.bitrateEstimatorAbsSendTime.onRttUpdate(avgRttMs, maxRttMs);
    }

    public void setExtensionID(int id) {
        this.extensionId = id;
    }

    @Override
    public void onReceiveBitrateChanged(Collection<Long> ssrcs, long bitrate) {
        for (MediaStream stream : this.mediaStreams) {
            if (!(stream instanceof VideoMediaStream)) continue;
            VideoMediaStream videoStream = (VideoMediaStream)stream;
            videoStream.getOrCreateBandwidthEstimator().updateReceiverEstimate(bitrate);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tccReceived(RTCPTCCPacket tccPacket) {
        RTCPTCCPacket.PacketMap packetMap = tccPacket.getPackets();
        long previousArrivalTimeMs = -1L;
        for (Map.Entry entry : packetMap.entrySet()) {
            PacketDetail packetDetail;
            long arrivalTime250Us = (Long)entry.getValue();
            if (arrivalTime250Us == -1L) continue;
            if (this.remoteReferenceTimeMs == -1L) {
                this.remoteReferenceTimeMs = RTCPTCCPacket.getReferenceTime250us(new ByteArrayBufferImpl(tccPacket.fci, 0, tccPacket.fci.length)) / 4L;
                this.localReferenceTimeMs = System.currentTimeMillis();
            }
            Object object = this.sentPacketsSyncRoot;
            synchronized (object) {
                packetDetail = this.sentPacketDetails.remove(entry.getKey());
            }
            if (packetDetail == null) continue;
            long arrivalTimeMs = arrivalTime250Us / 4L - this.remoteReferenceTimeMs + this.localReferenceTimeMs;
            if (timeSeriesLogger.isTraceEnabled()) {
                if (previousArrivalTimeMs != -1L) {
                    long diff_ms = arrivalTimeMs - previousArrivalTimeMs;
                    timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("ingress_tcc_ack").addField("seq", entry.getKey()).addField("arrival_time_ms", (Object)arrivalTimeMs).addField("diff_ms", (Object)diff_ms));
                } else {
                    timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("ingress_tcc_ack").addField("seq", entry.getKey()).addField("arrival_time_ms", (Object)arrivalTimeMs));
                }
            }
            previousArrivalTimeMs = arrivalTimeMs;
            long sendTime24bits = RemoteBitrateEstimatorAbsSendTime.convertMsTo24Bits(packetDetail.packetSendTimeMs);
            this.bitrateEstimatorAbsSendTime.incomingPacketInfo(arrivalTimeMs, sendTime24bits, packetDetail.packetLength, tccPacket.getSourceSSRC());
        }
    }

    public TransformEngine getEgressEngine() {
        return this.egressEngine;
    }

    public TransformEngine getIngressEngine() {
        return this.ingressEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaStream(MediaStream mediaStream) {
        List<MediaStream> list = this.mediaStreams;
        synchronized (list) {
            this.mediaStreams.add(mediaStream);
            MediaStreamStats2 stats = mediaStream.getMediaStreamStats();
            stats.addRTCPPacketListener(this);
            if (mediaStream instanceof VideoMediaStream) {
                this.anyVideoMediaStream = (VideoMediaStream)mediaStream;
                this.diagnosticContext.put((Object)"video_stream", (Object)mediaStream.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaStream(MediaStream mediaStream) {
        List<MediaStream> list = this.mediaStreams;
        synchronized (list) {
            while (this.mediaStreams.remove(mediaStream)) {
            }
            MediaStreamStats2 stats = mediaStream.getMediaStreamStats();
            stats.removeRTCPPacketListener(this);
            if (mediaStream == this.anyVideoMediaStream) {
                this.anyVideoMediaStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaStream getMediaStream() {
        List<MediaStream> list = this.mediaStreams;
        synchronized (list) {
            return this.mediaStreams.isEmpty() ? null : this.mediaStreams.get(0);
        }
    }

    public class IngressEngine
    extends SinglePacketTransformerAdapter
    implements TransformEngine {
        private IngressEngine() {
            super(RTPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            RawPacket.HeaderExtension he;
            if (TransportCCEngine.this.extensionId != -1 && (he = pkt.getHeaderExtension((byte)TransportCCEngine.this.extensionId)) != null && he.getExtLength() == 2) {
                int seq = RTPUtils.readUint16AsInt(he.getBuffer(), he.getOffset() + 1);
                TransportCCEngine.this.packetReceived(seq, RawPacket.getPayloadType(pkt), pkt.isPacketMarked());
            }
            return pkt;
        }

        @Override
        public PacketTransformer getRTPTransformer() {
            return this;
        }

        @Override
        public PacketTransformer getRTCPTransformer() {
            return null;
        }
    }

    public class EgressEngine
    extends SinglePacketTransformerAdapter
    implements TransformEngine {
        private EgressEngine() {
            super(RTPPacketPredicate.INSTANCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RawPacket transform(RawPacket pkt) {
            if (TransportCCEngine.this.extensionId != -1) {
                RawPacket.HeaderExtension ext = pkt.getHeaderExtension((byte)TransportCCEngine.this.extensionId);
                if (ext == null) {
                    ext = pkt.addExtension((byte)TransportCCEngine.this.extensionId, 2);
                }
                int seq = TransportCCEngine.this.outgoingSeq.getAndIncrement() & 0xFFFF;
                RTPUtils.writeShort(ext.getBuffer(), ext.getOffset() + 1, (short)seq);
                if (timeSeriesLogger.isTraceEnabled()) {
                    timeSeriesLogger.trace((Map)TransportCCEngine.this.diagnosticContext.makeTimeSeriesPoint("egress_tcc_pkt").addField("rtp_seq", (Object)pkt.getSequenceNumber()).addField("pt", (Object)RawPacket.getPayloadType(pkt)).addField("tcc_seq", (Object)seq));
                }
                Object object = TransportCCEngine.this.sentPacketsSyncRoot;
                synchronized (object) {
                    TransportCCEngine.this.sentPacketDetails.put(seq, new PacketDetail(pkt.getLength(), System.currentTimeMillis()));
                }
            }
            return pkt;
        }

        @Override
        public PacketTransformer getRTPTransformer() {
            return this;
        }

        @Override
        public PacketTransformer getRTCPTransformer() {
            return null;
        }
    }

    private class PacketDetail {
        int packetLength;
        long packetSendTimeMs;

        PacketDetail(int length, long time) {
            this.packetLength = length;
            this.packetSendTimeMs = time;
        }
    }
}

