/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.utils.ByteArrayBuffer;

public class NACKPacket
extends RTCPFBPacket {
    public static final int FMT = 1;
    private Collection<Integer> lostPackets = null;

    public static boolean isNACKPacket(ByteArrayBuffer baf) {
        int rc = RTCPUtils.getReportCount(baf);
        return rc == 1 && NACKPacket.isRTPFBPacket(baf);
    }

    public static Collection<Integer> getLostPackets(ByteArrayBuffer baf) {
        return NACKPacket.getLostPacketsFci(NACKPacket.getFCI(baf));
    }

    public static Collection<Integer> getLostPacketsFci(ByteArrayBuffer fciBuffer) {
        LinkedList<Integer> lostPackets = new LinkedList<Integer>();
        if (fciBuffer == null) {
            return lostPackets;
        }
        byte[] fci = fciBuffer.getBuffer();
        int off = fciBuffer.getOffset();
        int len = fciBuffer.getLength();
        for (int i = 0; i < len / 4; ++i) {
            int j;
            int pid = (0xFF & fci[off + i * 4 + 0]) << 8 | 0xFF & fci[off + i * 4 + 1];
            lostPackets.add(pid);
            for (j = 0; j < 8; ++j) {
                if (0 == (fci[off + i * 4 + 2] & 1 << j)) continue;
                lostPackets.add((pid + 1 + 8 + j) % 65536);
            }
            for (j = 0; j < 8; ++j) {
                if (0 == (fci[off + i * 4 + 3] & 1 << j)) continue;
                lostPackets.add((pid + 1 + j) % 65536);
            }
        }
        return lostPackets;
    }

    public NACKPacket(RTCPCompoundPacket base) {
        super(base);
    }

    public NACKPacket(long senderSSRC, long sourceSSRC, Collection<Integer> lostPackets) {
        super(1, 205, senderSSRC, sourceSSRC);
        LinkedList<Integer> sorted = new LinkedList<Integer>(lostPackets);
        Collections.sort(sorted);
        LinkedList<byte[]> nackList = new LinkedList<byte[]>();
        int currentPid = -1;
        byte[] currentNack = null;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int seq = (Integer)iterator.next();
            if (currentPid == -1 || currentPid + 16 <= seq) {
                currentPid = seq;
                currentNack = new byte[]{(byte)((seq & 0xFF00) >> 8), (byte)(seq & 0xFF), 0, 0};
                nackList.add(currentNack);
                continue;
            }
            int diff = seq - currentPid;
            if (diff <= 8) {
                currentNack[3] = (byte)(currentNack[3] | (byte)(1 << diff - 1));
                continue;
            }
            currentNack[2] = (byte)(currentNack[2] | (byte)(1 << diff - 8 - 1));
        }
        this.fci = new byte[nackList.size() * 4];
        for (int i = 0; i < nackList.size(); ++i) {
            System.arraycopy(nackList.get(i), 0, this.fci, i * 4, 4);
        }
        this.lostPackets = sorted;
    }

    public synchronized Collection<Integer> getLostPackets() {
        if (this.lostPackets == null) {
            this.lostPackets = NACKPacket.getLostPacketsFci(new RawPacket(this.fci, 0, this.fci.length));
        }
        return this.lostPackets;
    }

    @Override
    public String toString() {
        return "RTCP NACK packet; packet sender: " + this.senderSSRC + "; media sources: " + this.sourceSSRC + "; NACK entries: " + (Serializable)(this.fci == null ? "none" : Integer.valueOf(this.fci.length / 4)) + "; lost packets: " + (this.lostPackets == null ? "none" : Arrays.toString(this.lostPackets.toArray()));
    }
}

