/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.directshow;

import org.jitsi.util.OSUtils;

public class DSFormat {
    public static final int ARGB32;
    public static final int I420;
    public static final int NV12;
    public static final int RGB24;
    public static final int RGB32;
    public static final int UYVY;
    public static final int Y411;
    public static final int Y41P;
    public static final int YUY2;
    public static final int MJPG;
    private final int height;
    private final int pixelFormat;
    private final int width;

    private static native int ARGB32();

    public static native int AYUV();

    private static native int I420();

    public static native int IF09();

    public static native int IMC1();

    public static native int IMC2();

    public static native int IMC3();

    public static native int IMC4();

    public static native int IYUV();

    private static native int MJPG();

    private static native int NV12();

    private static native int RGB24();

    private static native int RGB32();

    private static native int UYVY();

    public static native int Y211();

    private static native int Y411();

    private static native int Y41P();

    private static native int YUY2();

    public static native int YV12();

    public static native int YVU9();

    public static native int YVYU();

    public DSFormat(int width, int height, int pixelFormat) {
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName());
        if (this.pixelFormat != -1) {
            s.append(", pixelFormat 0x");
            s.append(Long.toHexString((long)this.pixelFormat & 0xFFFFFFFFL));
        }
        if (this.width != -1) {
            s.append(", width ").append(this.width);
        }
        if (this.height != -1) {
            s.append(", height ").append(this.height);
        }
        return s.toString();
    }

    static {
        OSUtils.loadLibrary("jndirectshow", DSFormat.class);
        ARGB32 = DSFormat.ARGB32();
        I420 = DSFormat.I420();
        MJPG = DSFormat.MJPG();
        NV12 = DSFormat.NV12();
        RGB24 = DSFormat.RGB24();
        RGB32 = DSFormat.RGB32();
        UYVY = DSFormat.UYVY();
        Y411 = DSFormat.Y411();
        Y41P = DSFormat.Y41P();
        YUY2 = DSFormat.YUY2();
    }
}

