/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.jitsi.service.fileaccess.FailSafeTransaction;

public class FailSafeTransactionImpl
implements FailSafeTransaction {
    private File file;
    private File backup;
    private static final String PART_EXT = ".part";
    private static final String BAK_EXT = ".bak";

    protected FailSafeTransactionImpl(File file) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("null file provided");
        }
        this.file = file;
        this.backup = null;
    }

    @Override
    public void restoreFile() throws IllegalStateException, IOException {
        File back = new File(this.file.getAbsolutePath() + BAK_EXT);
        if (back.exists()) {
            this.failsafeCopy(back, this.file);
            back.delete();
        }
    }

    @Override
    public void beginTransaction() throws IllegalStateException, IOException {
        if (this.backup != null) {
            this.commit();
        }
        this.restoreFile();
        this.backup = new File(this.file.getAbsolutePath() + BAK_EXT);
        this.failsafeCopy(this.file, this.backup);
    }

    @Override
    public void commit() throws IllegalStateException {
        if (this.backup == null) {
            return;
        }
        this.backup.delete();
        this.backup = null;
    }

    @Override
    public void rollback() throws IllegalStateException, IOException {
        if (this.backup == null) {
            return;
        }
        this.failsafeCopy(this.backup, this.file);
        this.backup.delete();
        this.backup = null;
    }

    private void failsafeCopy(File from, File to) throws IllegalStateException, IOException {
        Files.deleteIfExists(to.toPath());
        File ptoF = new File(to.getAbsolutePath() + PART_EXT);
        Files.deleteIfExists(ptoF.toPath());
        Files.copy(from.toPath(), ptoF.toPath(), new CopyOption[0]);
        Files.move(ptoF.toPath(), to.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }
}

