/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import java.util.Comparator;

public class RTPUtils {
    private static final char[] HEXES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final Comparator<? super Integer> sequenceNumberComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            if (a.equals(b)) {
                return 0;
            }
            if (a > b) {
                if (a - b < 65536) {
                    return 1;
                }
                return -1;
            }
            if (b - a < 65536) {
                return -1;
            }
            return 1;
        }
    };

    public static int getSequenceNumberDelta(int a, int b) {
        int diff = a - b;
        if (diff < Short.MIN_VALUE) {
            diff += 65536;
        } else if (diff > 32768) {
            diff -= 65536;
        }
        return diff;
    }

    public static boolean isOlderSequenceNumberThan(int seqNumOne, int seqNumTwo) {
        return RTPUtils.getSequenceNumberDelta(seqNumOne, seqNumTwo) < 0;
    }

    public static int subtractNumber(int a, int b) {
        return RTPUtils.as16Bits(a - b);
    }

    public static int applySequenceNumberDelta(int startingSequenceNumber, int delta) {
        return startingSequenceNumber + delta & 0xFFFF;
    }

    public static int writeInt(byte[] buf, int off, int data) {
        if (buf == null || buf.length < off + 4) {
            return -1;
        }
        buf[off++] = (byte)(data >> 24);
        buf[off++] = (byte)(data >> 16);
        buf[off++] = (byte)(data >> 8);
        buf[off] = (byte)data;
        return 4;
    }

    public static int writeUint24(byte[] buf, int off, int data) {
        if (buf == null || buf.length < off + 3) {
            return -1;
        }
        buf[off++] = (byte)(data >> 16);
        buf[off++] = (byte)(data >> 8);
        buf[off] = (byte)data;
        return 3;
    }

    public static int writeShort(byte[] buf, int off, short data) {
        buf[off++] = (byte)(data >> 8);
        buf[off] = (byte)data;
        return 2;
    }

    public static int readInt(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 24 | (buf[off++] & 0xFF) << 16 | (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static long readUint32AsLong(byte[] buf, int off) {
        return (long)RTPUtils.readInt(buf, off) & 0xFFFFFFFFL;
    }

    public static int readUint16AsInt(byte[] buf, int off) {
        int b1 = 0xFF & buf[off + 0];
        int b2 = 0xFF & buf[off + 1];
        int val = b1 << 8 | b2;
        return val;
    }

    public static int readInt16AsInt(byte[] buf, int off) {
        int ret = (0xFF & buf[off]) << 8 | 0xFF & buf[off + 1];
        if ((ret & 0x8000) != 0) {
            ret |= 0xFFFF0000;
        }
        return ret;
    }

    public static int readUint24AsInt(byte[] buf, int off) {
        int b1 = 0xFF & buf[off + 0];
        int b2 = 0xFF & buf[off + 1];
        int b3 = 0xFF & buf[off + 2];
        return b1 << 16 | b2 << 8 | b3;
    }

    public static int as16Bits(int value) {
        return value & 0xFFFF;
    }

    public static long as32Bits(long value) {
        return value & 0xFFFFFFFFL;
    }

    public static long rtpTimestampDiff(long a, long b) {
        long diff = a - b;
        if (diff < Integer.MIN_VALUE) {
            diff += 0x100000000L;
        } else if (diff > 0x80000000L) {
            diff -= 0x100000000L;
        }
        return diff;
    }

    public static boolean isNewerTimestampThan(long a, long b) {
        return RTPUtils.rtpTimestampDiff(a, b) > 0L;
    }

    private static String toHexString(byte b) {
        StringBuilder hexStringBuilder = new StringBuilder(2);
        hexStringBuilder.append(HEXES[(b & 0xF0) >> 4]);
        hexStringBuilder.append(HEXES[b & 0xF]);
        return hexStringBuilder.toString();
    }

    public static String toHexString(byte[] buf) {
        return RTPUtils.toHexString(buf, 0, buf.length, true);
    }

    public static String toHexString(byte[] buf, int off, int len) {
        return RTPUtils.toHexString(buf, off, len, true);
    }

    public static String toHexString(byte[] buf, int off, int len, boolean format) {
        if (buf == null) {
            return null;
        }
        StringBuilder hexStringBuilder = new StringBuilder(2 * buf.length);
        for (int i = 0; i < len; ++i) {
            if (format) {
                if (i % 16 == 0) {
                    hexStringBuilder.append("\n").append(RTPUtils.toHexString((byte)i)).append("  ");
                } else if (i % 8 == 0) {
                    hexStringBuilder.append(" ");
                }
            }
            byte b = buf[off + i];
            hexStringBuilder.append(RTPUtils.toHexString(b));
            hexStringBuilder.append(" ");
        }
        return hexStringBuilder.toString();
    }
}

