/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import java.util.function.BiConsumer;
import org.jitsi.utils.JNIUtils;

public class OSUtils {
    private static final BiConsumer<String, Class<?>> loadLibrary = OSUtils.class.getClassLoader().getClass().getName().contains("Bundle") ? (libname, clazz) -> System.loadLibrary(libname) : JNIUtils::loadLibrary;
    public static final boolean IS_ANDROID;
    public static final boolean IS_LINUX;
    public static final boolean IS_MAC;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_FREEBSD;

    public static void loadLibrary(String libname, Class<?> clazz) {
        loadLibrary.accept(libname, clazz);
    }

    private OSUtils() {
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Linux")) {
            String javaVmName = System.getProperty("java.vm.name");
            if (javaVmName != null && javaVmName.equalsIgnoreCase("Dalvik")) {
                IS_ANDROID = true;
                IS_LINUX = false;
            } else {
                IS_ANDROID = false;
                IS_LINUX = true;
            }
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Mac")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = true;
            IS_WINDOWS = false;
            IS_FREEBSD = false;
        } else if (osName.startsWith("Windows")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = true;
            IS_FREEBSD = false;
        } else if (osName.startsWith("FreeBSD")) {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_FREEBSD = true;
        } else {
            IS_ANDROID = false;
            IS_LINUX = false;
            IS_MAC = false;
            IS_WINDOWS = false;
            IS_FREEBSD = false;
        }
    }
}

