/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.logging.Logger;

class FECSender
implements PacketTransformer {
    private static final Logger logger = Logger.getLogger(FECSender.class);
    private long ssrc;
    private byte ulpfecPT;
    private int fecRate;
    private int counter = 0;
    private int nbFec = 0;
    private FECPacket fecPacket;

    FECSender(long ssrc, int fecRate, byte ulpfecPT) {
        this.ssrc = ssrc;
        this.fecRate = fecRate;
        this.ulpfecPT = ulpfecPT;
        this.fecPacket = new FECPacket(ssrc, ulpfecPT);
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        return pkts;
    }

    @Override
    public synchronized RawPacket[] transform(RawPacket[] pkts) {
        RawPacket pkt = null;
        for (RawPacket p : pkts) {
            if (p == null || p.getVersion() != 2) continue;
            pkt = p;
            break;
        }
        if (pkt == null) {
            return pkts;
        }
        return this.transformSingle(pkt, pkts);
    }

    private RawPacket[] transformSingle(RawPacket pkt, RawPacket[] pkts) {
        ++this.counter;
        pkt.setSequenceNumber(pkt.getSequenceNumber() + this.nbFec);
        if (this.fecRate != 0) {
            this.fecPacket.addMedia(pkt);
        }
        if (this.fecRate != 0 && this.counter % this.fecRate == 0) {
            this.fecPacket.finish();
            boolean found = false;
            for (int i = 0; i < pkts.length; ++i) {
                if (pkts[i] != null) continue;
                found = true;
                pkts[i] = this.fecPacket;
                break;
            }
            if (!found) {
                RawPacket[] pkts2 = new RawPacket[pkts.length + 1];
                System.arraycopy(pkts, 0, pkts2, 0, pkts.length);
                pkts2[pkts.length] = this.fecPacket;
                pkts = pkts2;
            }
            this.fecPacket = new FECPacket(this.ssrc, this.ulpfecPT);
            ++this.nbFec;
        }
        return pkts;
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Closing FECSender for ssrc=" + this.ssrc + ". Added " + this.nbFec + " ulpfec packets."));
        }
    }

    public void setUlpfecPT(byte ulpfecPT) {
        this.ulpfecPT = ulpfecPT;
        if (this.fecPacket != null) {
            this.fecPacket.payloadType = ulpfecPT;
        }
    }

    public void setFecRate(int newFecRate) {
        if (this.fecRate != newFecRate) {
            this.fecPacket = new FECPacket(this.ssrc, this.ulpfecPT);
            this.fecRate = newFecRate;
            this.counter = 0;
        }
    }

    private static class FECPacket
    extends RawPacket {
        int base = -1;
        int numPackets = 0;
        int protectionLength = -1;
        int lastAddedSeq = -1;
        private byte[] buf = this.getBuffer();
        private final long ssrc;
        private long lastAddedTS = -1L;
        byte payloadType;
        private static final int RTP_HDR_LEN = 12;
        private static final int FEC_HDR_LEN = 14;

        FECPacket(long ssrc, byte payloadType) {
            super(new byte[1500], 0, 1500);
            this.ssrc = ssrc;
            this.payloadType = payloadType;
        }

        private void addMedia(RawPacket media) {
            byte[] mediaBuf = media.getBuffer();
            int mediaOff = media.getOffset();
            int mediaPayloadLen = media.getLength() - 12;
            if (this.buf.length < mediaPayloadLen + 12 + 14) {
                byte[] newBuff = new byte[mediaPayloadLen + 12 + 14];
                System.arraycopy(this.buf, 0, newBuff, 0, this.buf.length);
                for (int i = this.buf.length; i < newBuff.length; ++i) {
                    newBuff[i] = 0;
                }
                this.buf = newBuff;
                this.setBuffer(this.buf);
            }
            if (this.base == -1) {
                this.base = media.getSequenceNumber();
                System.arraycopy(mediaBuf, mediaOff, this.buf, 12, 8);
                this.buf[20] = (byte)(mediaPayloadLen >> 8 & 0xFF);
                this.buf[21] = (byte)(mediaPayloadLen & 0xFF);
                System.arraycopy(mediaBuf, mediaOff + 12, this.buf, 26, mediaPayloadLen);
            } else {
                int i;
                for (i = 0; i < 8; ++i) {
                    int n = 12 + i;
                    this.buf[n] = (byte)(this.buf[n] ^ mediaBuf[mediaOff + i]);
                }
                this.buf[20] = (byte)(this.buf[20] ^ (byte)(mediaPayloadLen >> 8 & 0xFF));
                this.buf[21] = (byte)(this.buf[21] ^ (byte)(mediaPayloadLen & 0xFF));
                for (i = 0; i < mediaPayloadLen; ++i) {
                    int n = 26 + i;
                    this.buf[n] = (byte)(this.buf[n] ^ mediaBuf[mediaOff + 12 + i]);
                }
            }
            this.lastAddedSeq = media.getSequenceNumber();
            this.lastAddedTS = media.getTimestamp();
            if (mediaPayloadLen > this.protectionLength) {
                this.protectionLength = mediaPayloadLen;
            }
            ++this.numPackets;
        }

        private RawPacket finish() {
            this.buf[0] = -128;
            this.setPayloadType(this.payloadType);
            this.setSequenceNumber(this.lastAddedSeq + 1);
            this.setSSRC((int)this.ssrc);
            this.setTimestamp(this.lastAddedTS);
            this.buf[14] = (byte)(this.base >> 8 & 0xFF);
            this.buf[15] = (byte)(this.base & 0xFF);
            this.buf[22] = (byte)(this.protectionLength >> 8 & 0xFF);
            this.buf[23] = (byte)(this.protectionLength & 0xFF);
            int mask = (1 << this.numPackets) - 1 << 16 - this.numPackets;
            this.buf[24] = (byte)(mask >> 8 & 0xFF);
            this.buf[25] = (byte)(mask & 0xFF);
            this.setLength(26 + this.protectionLength);
            return this;
        }
    }
}

