/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.utils.LRUCache;

public class PaddingTermination
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final int SEEN_SET_SZ = 1500;
    private final Map<Long, Set<Integer>> replayContexts = new TreeMap<Long, Set<Integer>>();

    public PaddingTermination() {
        super(RTPPacketPredicate.INSTANCE);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        Long mediaSSRC = pkt.getSSRCAsLong();
        Set<Integer> replayContext = this.replayContexts.get(mediaSSRC);
        if (replayContext == null) {
            replayContext = Collections.newSetFromMap(new LRUCache(1500));
            this.replayContexts.put(mediaSSRC, replayContext);
        }
        return replayContext.add(pkt.getSequenceNumber()) ? pkt : null;
    }
}

