/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.utils.ByteArrayBuffer;

public class FrameMarkingHeaderExtension {
    private static byte S_BIT = (byte)-128;
    private static byte E_BIT = (byte)64;
    private static byte I_BIT = (byte)32;
    private static byte KF_MASK = (byte)(S_BIT | I_BIT);
    private static byte TID_MASK = (byte)7;

    public static boolean isKeyframe(ByteArrayBuffer baf) {
        if (baf == null || baf.getLength() < 2) {
            return false;
        }
        byte b = baf.getBuffer()[baf.getOffset() + 1];
        return (byte)(b & KF_MASK) == KF_MASK;
    }

    public static boolean isStartOfFrame(ByteArrayBuffer baf) {
        if (baf == null || baf.getLength() < 2) {
            return false;
        }
        byte b = baf.getBuffer()[baf.getOffset() + 1];
        return (b & S_BIT) != 0;
    }

    public static boolean isEndOfFrame(ByteArrayBuffer baf) {
        if (baf == null || baf.getLength() < 2) {
            return false;
        }
        byte b = baf.getBuffer()[baf.getOffset() + 1];
        return (b & E_BIT) != 0;
    }

    public static byte getSpatialID(ByteArrayBuffer baf, String encoding) {
        if (baf == null || baf.getLength() < 4) {
            return 0;
        }
        return 0;
    }

    public static byte getTemporalID(ByteArrayBuffer baf) {
        if (baf == null || baf.getLength() < 2) {
            return 0;
        }
        byte b = baf.getBuffer()[baf.getOffset() + 1];
        return (byte)(b & TID_MASK);
    }
}

