/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.RawPacket;

public class PacketBuffer
implements TransformEngine,
PacketTransformer {
    private static final Comparator<? super RawPacket> seqNumComparator = new Comparator<RawPacket>(){

        @Override
        public int compare(RawPacket pkt1, RawPacket pkt2) {
            long b;
            long a = pkt1.getSequenceNumber();
            if (a == (b = (long)pkt2.getSequenceNumber())) {
                return 0;
            }
            if (a > b) {
                if (a - b < 32768L) {
                    return 1;
                }
                return -1;
            }
            if (b - a < 32768L) {
                return -1;
            }
            return 1;
        }
    };
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static int VP8_PAYLOAD_TYPE = 100;
    private static final String PACKET_BUFFER_SIZE_PNAME = PacketBuffer.class.getCanonicalName() + ".SIZE";
    private static int SIZE = cfg.getInt(PACKET_BUFFER_SIZE_PNAME, 300);
    private final Map<Long, Buffer> buffers = new HashMap<Long, Buffer>();

    @Override
    public void close() {
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt != null && pkt.getPaddingSize() != 0) {
                pkts[i] = null;
            }
            if (!this.willBuffer(pkt = pkts[i])) continue;
            Buffer buffer = this.getBuffer(pkt.getSSRCAsLong());
            pkts[i] = buffer.insert(pkt);
        }
        return pkts;
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private boolean willBuffer(RawPacket pkt) {
        return pkt != null && pkt.getPayloadType() == VP8_PAYLOAD_TYPE;
    }

    void disable(long ssrc) {
        this.getBuffer((long)ssrc).disabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(long ssrc) {
        Map<Long, Buffer> map = this.buffers;
        synchronized (map) {
            this.buffers.remove(ssrc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer getBuffer(long ssrc) {
        Map<Long, Buffer> map = this.buffers;
        synchronized (map) {
            Buffer buffer = this.buffers.get(ssrc);
            if (buffer == null) {
                buffer = new Buffer(SIZE, ssrc);
                this.buffers.put(ssrc, buffer);
            }
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RawPacket[] emptyBuffer(long ssrc) {
        Buffer buffer;
        Map<Long, Buffer> map = this.buffers;
        synchronized (map) {
            buffer = this.buffers.get(ssrc);
        }
        if (buffer != null) {
            return buffer.empty();
        }
        return new RawPacket[0];
    }

    private static class Buffer {
        private final SortedSet<RawPacket> buffer = new TreeSet<RawPacket>(seqNumComparator);
        private final int capacity;
        private long ssrc;
        private boolean disabled = false;

        Buffer(int capacity, long ssrc) {
            this.capacity = capacity;
            this.ssrc = ssrc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RawPacket insert(RawPacket pkt) {
            if (this.disabled) {
                return null;
            }
            RawPacket ret = null;
            SortedSet<RawPacket> sortedSet = this.buffer;
            synchronized (sortedSet) {
                this.buffer.add(pkt);
                if (this.buffer.size() > this.capacity) {
                    ret = this.buffer.first();
                    this.buffer.remove(ret);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RawPacket[] empty() {
            SortedSet<RawPacket> sortedSet = this.buffer;
            synchronized (sortedSet) {
                RawPacket[] ret = this.buffer.toArray(new RawPacket[this.buffer.size()]);
                this.buffer.clear();
                return ret;
            }
        }
    }
}

