/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.imgstreaming;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.jitsi.impl.neomedia.imgstreaming.DesktopInteract;
import org.jitsi.impl.neomedia.imgstreaming.ScreenCapture;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.logging.Logger;

public class DesktopInteractImpl
implements DesktopInteract {
    private static final Logger logger = Logger.getLogger(DesktopInteractImpl.class);
    private Robot robot = new Robot();

    @Override
    public boolean captureScreen(int display, byte[] output) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        return this.captureScreen(display, 0, 0, dim.width, dim.height, output);
    }

    @Override
    public boolean captureScreen(int display, long buffer, int bufferLength) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        return this.captureScreen(display, 0, 0, dim.width, dim.height, buffer, bufferLength);
    }

    @Override
    public boolean captureScreen(int display, int x, int y, int width, int height, byte[] output) {
        return (OSUtils.IS_LINUX || OSUtils.IS_MAC || OSUtils.IS_WINDOWS) && ScreenCapture.grabScreen(display, x, y, width, height, output);
    }

    @Override
    public boolean captureScreen(int display, int x, int y, int width, int height, long buffer, int bufferLength) {
        return (OSUtils.IS_LINUX || OSUtils.IS_MAC || OSUtils.IS_WINDOWS) && ScreenCapture.grabScreen(display, x, y, width, height, buffer, bufferLength);
    }

    @Override
    public BufferedImage captureScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        return this.captureScreen(0, 0, dim.width, dim.height);
    }

    @Override
    public BufferedImage captureScreen(int x, int y, int width, int height) {
        BufferedImage img = null;
        Rectangle rect = null;
        if (this.robot == null) {
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Begin capture: " + System.nanoTime()));
        }
        rect = new Rectangle(x, y, width, height);
        img = this.robot.createScreenCapture(rect);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("End capture: " + System.nanoTime()));
        }
        return img;
    }
}

