/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.silk.DefineFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.EncAPI;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_SILK_SDK_EncControlStruct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_encoder_state_FLP;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.control.PacketLossAwareEncoder;
import org.jitsi.utils.logging.Logger;

public class JavaEncoder
extends AbstractCodec2
implements PacketLossAwareEncoder {
    private final Logger logger = Logger.getLogger(JavaEncoder.class);
    private static final int BITRATE = 40000;
    private static final int COMPLEXITY = 2;
    static final int MAX_BYTES_PER_FRAME = 250;
    static final Format[] SUPPORTED_INPUT_FORMATS;
    static final Format[] SUPPORTED_OUTPUT_FORMATS;
    private static final double[] SUPPORTED_SAMPLE_RATES;
    private static final boolean USE_DTX = false;
    private static final int MIN_PACKET_LOSS_PERCENTAGE = 3;
    private boolean useFec;
    private boolean alwaysAssumePacketLoss = true;
    private int duration = 20000000;
    private SKP_SILK_SDK_EncControlStruct encControl;
    private SKP_Silk_encoder_state_FLP encState;
    private final short[] outputLength = new short[1];

    public JavaEncoder() {
        super("SILK Encoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        this.useFec = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.USE_FEC", true);
        this.alwaysAssumePacketLoss = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.AWLAYS_ASSUME_PACKET_LOSS", true);
        String satStr = cfg.getString("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.SPEECH_ACTIVITY_THRESHOLD", "0.5");
        float sat = DefineFLP.LBRR_SPEECH_ACTIVITY_THRES;
        if (satStr != null && satStr.length() != 0) {
            try {
                sat = Float.parseFloat(satStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DefineFLP.LBRR_SPEECH_ACTIVITY_THRES = sat;
        this.addControl(this);
    }

    @Override
    protected void doClose() {
        this.encState = null;
        this.encControl = null;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.encState = new SKP_Silk_encoder_state_FLP();
        this.encControl = new SKP_SILK_SDK_EncControlStruct();
        if (EncAPI.SKP_Silk_SDK_InitEncoder(this.encState, this.encControl) != 0) {
            throw new ResourceUnavailableException("EncAPI.SKP_Silk_SDK_InitEncoder");
        }
        AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
        double sampleRate = inputFormat.getSampleRate();
        int channels = inputFormat.getChannels();
        this.encControl.API_sampleRate = (int)sampleRate;
        this.encControl.bitRate = 40000;
        this.encControl.complexity = 2;
        this.encControl.maxInternalSampleRate = this.encControl.API_sampleRate;
        this.setExpectedPacketLoss(0);
        this.encControl.packetSize = (int)(20.0 * sampleRate * (double)channels / 1000.0);
        this.encControl.useDTX = 0;
        this.encControl.useInBandFEC = this.useFec ? 1 : 0;
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int processed;
        short[] inputData = (short[])inputBuffer.getData();
        int inputLength = inputBuffer.getLength();
        int inputOffset = inputBuffer.getOffset();
        if (inputLength > this.encControl.packetSize) {
            inputLength = this.encControl.packetSize;
        }
        byte[] outputData = JavaEncoder.validateByteArraySize(outputBuffer, 250, false);
        int outputOffset = 0;
        this.outputLength[0] = 250;
        if (EncAPI.SKP_Silk_SDK_Encode(this.encState, this.encControl, inputData, inputOffset, inputLength, outputData, outputOffset, this.outputLength) == 0) {
            outputBuffer.setLength((int)this.outputLength[0]);
            outputBuffer.setOffset(outputOffset);
            processed = 0;
        } else {
            processed = 1;
        }
        inputBuffer.setLength(inputBuffer.getLength() - inputLength);
        inputBuffer.setOffset(inputBuffer.getOffset() + inputLength);
        if (processed != 1) {
            if (processed == 0) {
                this.updateOutput(outputBuffer, this.getOutputFormat(), outputBuffer.getLength(), outputBuffer.getOffset());
                outputBuffer.setDuration((long)this.duration);
            }
            if (inputBuffer.getLength() > 0) {
                processed |= 2;
            }
        }
        return processed;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        return JavaEncoder.getMatchingOutputFormats(inputFormat, SUPPORTED_INPUT_FORMATS, SUPPORTED_OUTPUT_FORMATS);
    }

    static Format[] getMatchingOutputFormats(Format inputFormat, Format[] supportedInputFormats, Format[] supportedOutputFormats) {
        if (inputFormat == null) {
            return supportedOutputFormats;
        }
        Format matchingInputFormat = JavaEncoder.matches(inputFormat, supportedInputFormats);
        if (matchingInputFormat == null) {
            return new Format[0];
        }
        AudioFormat matchingInputAudioFormat = (AudioFormat)matchingInputFormat.intersects(inputFormat);
        AudioFormat outputFormat = new AudioFormat(null, matchingInputAudioFormat.getSampleRate(), -1, -1, -1, -1, -1, -1.0, null);
        Format matchingOutputFormat = JavaEncoder.matches((Format)outputFormat, supportedOutputFormats);
        if (matchingOutputFormat == null) {
            return new Format[0];
        }
        return new Format[]{matchingOutputFormat.intersects((Format)outputFormat)};
    }

    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            outputFormat = this.setOutputFormat((Format)new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                public long computeDuration(long length) {
                    return JavaEncoder.this.duration;
                }
            });
        }
        return outputFormat;
    }

    @Override
    public void setExpectedPacketLoss(int percentage) {
        if (this.opened) {
            if (this.alwaysAssumePacketLoss && 3 >= percentage) {
                percentage = 3;
            }
            this.encControl.packetLossPercentage = percentage;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Setting expected packet loss to: " + percentage));
            }
        }
    }

    public Component getControlComponent() {
        return null;
    }

    static {
        SUPPORTED_SAMPLE_RATES = new double[]{8000.0, 12000.0, 16000.0, 24000.0};
        int supportedCount = SUPPORTED_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[supportedCount];
        SUPPORTED_OUTPUT_FORMATS = new Format[supportedCount];
        for (int i = 0; i < supportedCount; ++i) {
            double supportedSampleRate = SUPPORTED_SAMPLE_RATES[i];
            JavaEncoder.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", supportedSampleRate, 16, 1, 0, 1, -1, -1.0, Format.shortArray);
            JavaEncoder.SUPPORTED_OUTPUT_FORMATS[i] = new AudioFormat("SILK/rtp", supportedSampleRate, -1, 1, -1, -1, -1, -1.0, Format.byteArray);
        }
    }
}

