/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPPacketParserEx;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.ByteArrayBuffer;

public class RTCPFBPacket
extends RTCPPacket {
    public static final int RTPFB = 205;
    public static final int PSFB = 206;
    public byte[] fci;
    public int fmt;
    public long senderSSRC;
    public long sourceSSRC;

    public RTCPFBPacket(int fmt, int type, long senderSSRC, long sourceSSRC) {
        this.type = type;
        this.fmt = fmt;
        this.senderSSRC = senderSSRC;
        this.sourceSSRC = sourceSSRC;
    }

    public RTCPFBPacket(RTCPCompoundPacket base) {
        super((RTCPPacket)base);
    }

    public static boolean isRTCPFBPacket(ByteArrayBuffer baf) {
        return RTCPFBPacket.isRTPFBPacket(baf) || RTCPFBPacket.isPSFBPacket(baf);
    }

    public static boolean isRTPFBPacket(ByteArrayBuffer baf) {
        int pt = RTCPUtils.getPacketType(baf);
        return pt == 205;
    }

    public static boolean isPSFBPacket(ByteArrayBuffer baf) {
        int pt = RTCPUtils.getPacketType(baf);
        return pt == 206;
    }

    public static long getSourceSSRC(ByteArrayBuffer baf) {
        if (baf == null || baf.isInvalid()) {
            return -1L;
        }
        return RTPUtils.readUint32AsLong(baf.getBuffer(), baf.getOffset() + 8);
    }

    public static ByteArrayBuffer getFCI(ByteArrayBuffer baf) {
        if (!RTCPFBPacket.isRTCPFBPacket(baf)) {
            return null;
        }
        int length = RTCPUtils.getLength(baf);
        if (length < 0) {
            return null;
        }
        return new RawPacket(baf.getBuffer(), baf.getOffset() + 12, length - 12);
    }

    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte((byte)(0x80 | this.fmt));
        dataoutputstream.writeByte((byte)this.type);
        int len = this.calcLength();
        dataoutputstream.writeShort(len / 4 - 1);
        dataoutputstream.writeInt((int)this.senderSSRC);
        dataoutputstream.writeInt((int)this.sourceSSRC);
        dataoutputstream.write(this.fci);
        int i = this.fci.length;
        while (i % 4 != 0) {
            dataoutputstream.writeByte(0);
            ++i;
        }
    }

    public int calcLength() {
        int len = 12;
        if (this.fci != null && this.fci.length != 0) {
            len += this.fci.length;
        }
        if (len % 4 != 0) {
            len += 4 - len % 4;
        }
        return len;
    }

    public String toString() {
        return "\tRTCP FB packet from sync source " + this.senderSSRC;
    }

    public RawPacket toRawPacket() throws IOException {
        return RTCPPacketParserEx.toRawPacket(this);
    }

    public long getSenderSSRC() {
        return this.senderSSRC;
    }

    public long getSourceSSRC() {
        return this.sourceSSRC;
    }
}

