/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import org.jitsi.utils.JNIUtils;

public class VPX {
    public static final int CODEC_OK = 0;
    public static final int CODEC_LIST_END = 9;
    public static final int CODEC_USE_XMA = 1;
    public static final int CODEC_USE_OUTPUT_PARTITION = 131072;
    public static final int ERROR_RESILIENT_DEFAULT = 1;
    public static final int ERROR_RESILIENT_PARTITIONS = 2;
    public static final int IMG_FMT_I420 = 258;
    public static final int RC_MODE_VBR = 0;
    public static final int RC_MODE_CBR = 1;
    public static final int RC_MODE_CQ = 2;
    public static final int KF_MODE_AUTO = 1;
    public static final int KF_MODE_DISABLED = 1;
    public static final int DL_REALTIME = 1;
    public static final int CODEC_CX_FRAME_PKT = 0;
    public static final int INTEFACE_VP8_DEC = 0;
    public static final int INTERFACE_VP8_ENC = 1;

    public static native long codec_ctx_malloc();

    public static native int codec_dec_init(long var0, int var2, long var3, long var5);

    public static native int codec_decode(long var0, byte[] var2, int var3, int var4, long var5, long var7);

    public static native long codec_get_frame(long var0, long[] var2);

    public static native int codec_destroy(long var0);

    public static native int codec_enc_init(long var0, int var2, long var3, long var5);

    public static native int codec_enc_config_set(long var0, long var2);

    public static native int codec_encode(long var0, long var2, byte[] var4, int var5, int var6, int var7, long var8, long var10, long var12, long var14);

    public static native long codec_get_cx_data(long var0, long[] var2);

    public static native int codec_cx_pkt_get_kind(long var0);

    public static native int codec_cx_pkt_get_size(long var0);

    public static native long codec_cx_pkt_get_data(long var0);

    public static native long img_malloc();

    public static native int img_get_w(long var0);

    public static native int img_get_h(long var0);

    public static native int img_get_d_w(long var0);

    public static native int img_get_d_h(long var0);

    public static native long img_get_plane0(long var0);

    public static native long img_get_plane1(long var0);

    public static native long img_get_plane2(long var0);

    public static native int img_get_stride0(long var0);

    public static native int img_get_stride1(long var0);

    public static native int img_get_stride2(long var0);

    public static native int img_get_fmt(long var0);

    public static native void img_set_w(long var0, int var2);

    public static native void img_set_h(long var0, int var2);

    public static native void img_set_d_w(long var0, int var2);

    public static native void img_set_d_h(long var0, int var2);

    public static native void img_set_stride0(long var0, int var2);

    public static native void img_set_stride1(long var0, int var2);

    public static native void img_set_stride2(long var0, int var2);

    public static native void img_set_stride3(long var0, int var2);

    public static native void img_set_fmt(long var0, int var2);

    public static native void img_set_bps(long var0, int var2);

    public static native void img_wrap(long var0, int var2, int var3, int var4, int var5, long var6);

    public static native long codec_dec_cfg_malloc();

    public static native void codec_dec_cfg_set_w(long var0, int var2);

    public static native void codec_dec_cfg_set_h(long var0, int var2);

    public static native long codec_enc_cfg_malloc();

    public static native int codec_enc_config_default(int var0, long var1, int var3);

    public static native void codec_enc_cfg_set_profile(long var0, int var2);

    public static native void codec_enc_cfg_set_threads(long var0, int var2);

    public static native void codec_enc_cfg_set_w(long var0, int var2);

    public static native void codec_enc_cfg_set_h(long var0, int var2);

    public static native void codec_enc_cfg_set_error_resilient(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_target_bitrate(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_dropframe_thresh(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_resize_allowed(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_resize_up_thresh(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_resize_down_thresh(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_end_usage(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_min_quantizer(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_max_quantizer(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_undershoot_pct(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_overshoot_pct(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_buf_sz(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_buf_initial_sz(long var0, int var2);

    public static native void codec_enc_cfg_set_rc_buf_optimal_sz(long var0, int var2);

    public static native void codec_enc_cfg_set_kf_mode(long var0, int var2);

    public static native void codec_enc_cfg_set_kf_min_dist(long var0, int var2);

    public static native void codec_enc_cfg_set_kf_max_dist(long var0, int var2);

    public static native long stream_info_malloc();

    public static native int stream_info_get_w(long var0);

    public static native int stream_info_get_h(long var0);

    public static native int stream_info_get_is_kf(long var0);

    public static native int codec_peek_stream_info(int var0, byte[] var1, int var2, int var3, long var4);

    public static native long malloc(long var0);

    public static native void free(long var0);

    public static native void memcpy(byte[] var0, long var1, int var3);

    public static native int codec_err_to_string(int var0, byte[] var1, int var2);

    public static String codec_err_to_string(int err) {
        byte[] buf = new byte[100];
        VPX.codec_err_to_string(err, buf, buf.length);
        return new String(buf);
    }

    static {
        JNIUtils.loadLibrary((String)"jnvpx", VPX.class);
    }

    static class StreamInfo {
        int w;
        int h;
        boolean is_kf;

        StreamInfo(int iface, byte[] buf, int buf_offset, int buf_size) {
            long si = VPX.stream_info_malloc();
            if (VPX.codec_peek_stream_info(iface, buf, buf_offset, buf_size, si) != 0) {
                return;
            }
            this.w = VPX.stream_info_get_w(si);
            this.h = VPX.stream_info_get_h(si);
            boolean bl = this.is_kf = VPX.stream_info_get_is_kf(si) != 0;
            if (si != 0L) {
                VPX.free(si);
            }
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public boolean isKf() {
            return this.is_kf;
        }
    }
}

