/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.BufferControl;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.SenderReport;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RTPConnectorTCPInputStream;
import org.jitsi.impl.neomedia.RTPConnectorUDPInputStream;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.SSRCFactoryImpl;
import org.jitsi.impl.neomedia.codec.REDBlock;
import org.jitsi.impl.neomedia.codec.REDBlockIterator;
import org.jitsi.impl.neomedia.codec.video.h264.DePacketizer;
import org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer;
import org.jitsi.impl.neomedia.codec.video.vp9.DePacketizer;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.ReceiveStreamPushBufferDataSource;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.impl.neomedia.rtp.FrameMarkingHeaderExtension;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorWrapper;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.stats.MediaStreamStats2Impl;
import org.jitsi.impl.neomedia.transform.AbsSendTimeEngine;
import org.jitsi.impl.neomedia.transform.CachingTransformer;
import org.jitsi.impl.neomedia.transform.DebugTransformEngine;
import org.jitsi.impl.neomedia.transform.DiscardTransformEngine;
import org.jitsi.impl.neomedia.transform.OriginalHeaderBlockTransformEngine;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.PaddingTermination;
import org.jitsi.impl.neomedia.transform.REDTransformEngine;
import org.jitsi.impl.neomedia.transform.RTPTransformTCPConnector;
import org.jitsi.impl.neomedia.transform.RTPTransformUDPConnector;
import org.jitsi.impl.neomedia.transform.RetransmissionRequesterImpl;
import org.jitsi.impl.neomedia.transform.RtxTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.impl.neomedia.transform.TransformEngineWrapper;
import org.jitsi.impl.neomedia.transform.TransformTCPOutputStream;
import org.jitsi.impl.neomedia.transform.TransformUDPOutputStream;
import org.jitsi.impl.neomedia.transform.csrc.CsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.csrc.SsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.dtmf.DtmfTransformEngine;
import org.jitsi.impl.neomedia.transform.fec.FECTransformEngine;
import org.jitsi.impl.neomedia.transform.pt.PayloadTypeTransformEngine;
import org.jitsi.impl.neomedia.transform.rtcp.StatisticsEngine;
import org.jitsi.impl.neomedia.transform.zrtp.ZRTPTransformEngine;
import org.jitsi.service.neomedia.AbstractMediaStream;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.RetransmissionRequester;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.control.PacketLossAwareEncoder;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;

public class MediaStreamImpl
extends AbstractMediaStream
implements ReceiveStreamListener,
SendStreamListener,
SessionListener,
RemoteListener {
    private static final Logger logger = Logger.getLogger(MediaStreamImpl.class);
    protected static final String PROPERTY_NAME_RECEIVE_BUFFER_LENGTH = "net.java.sip.communicator.impl.neomedia.RECEIVE_BUFFER_LENGTH";
    private final Map<Byte, RTPExtension> activeRTPExtensions = new Hashtable<Byte, RTPExtension>();
    private CsrcTransformEngine csrcEngine;
    private MediaDeviceSession deviceSession;
    private final PropertyChangeListener deviceSessionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propertyName = ev.getPropertyName();
            if ("OUTPUT_DATA_SOURCE".equals(propertyName)) {
                MediaStreamImpl.this.deviceSessionOutputDataSourceChanged();
            } else if ("SSRC_LIST".equals(propertyName)) {
                MediaStreamImpl.this.deviceSessionSsrcListChanged(ev);
            }
        }
    };
    private MediaDirection direction;
    private final Map<Byte, MediaFormat> dynamicRTPPayloadTypes = new HashMap<Byte, MediaFormat>();
    private long[] localContributingSourceIDs;
    private long localSourceID = (long)new Random().nextInt() & 0xFFFFFFFFL;
    private MediaStreamStats2Impl mediaStreamStatsImpl;
    private boolean mute = false;
    private long numberOfReceivedReceiverReports = 0L;
    private long numberOfReceivedSenderReports = 0L;
    private PayloadTypeTransformEngine ptTransformEngine;
    private final List<ReceiveStream> receiveStreams = new LinkedList<ReceiveStream>();
    private final ReadWriteLock receiveStreamsLock = new ReentrantReadWriteLock();
    private final Vector<Long> remoteSourceIDs = new Vector(1, 1);
    private AbstractRTPConnector rtpConnector;
    private MediaStreamTarget rtpConnectorTarget;
    private StreamRTPManager rtpManager;
    protected boolean sendStreamsAreCreated = false;
    private final SrtpControl srtpControl;
    private SSRCFactory ssrcFactory = new SSRCFactoryImpl(this.localSourceID);
    private boolean started = false;
    private MediaDirection startedDirection;
    private StatisticsEngine statisticsEngine = null;
    private DebugTransformEngine debugTransformEngine;
    private final TransformEngineWrapper<TransformEngine> externalTransformerWrapper = new TransformEngineWrapper();
    private AbsSendTimeEngine absSendTimeEngine;
    private CachingTransformer cachingTransformer = this.createCachingTransformer();
    private TransformEngineChain transformEngineChain;
    private final RetransmissionRequesterImpl retransmissionRequester = this.createRetransmissionRequester();
    private final OriginalHeaderBlockTransformEngine ohbEngine = new OriginalHeaderBlockTransformEngine();
    private final DiagnosticContext diagnosticContext = new DiagnosticContext();
    private int frameMarkingsExtensionId = -1;
    private TransportCCEngine transportCCEngine;

    public static String toString(DataSource dataSource) {
        StringBuilder str = new StringBuilder();
        str.append(dataSource.getClass().getSimpleName());
        str.append(" with hashCode ");
        str.append(dataSource.hashCode());
        MediaLocator locator = dataSource.getLocator();
        if (locator != null) {
            str.append(" and locator ");
            str.append(locator);
        }
        return str.toString();
    }

    public MediaStreamImpl(MediaDevice device, SrtpControl srtpControl) {
        this(null, device, srtpControl);
    }

    public MediaStreamImpl(StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        if (device != null) {
            this.setDevice(device);
        }
        this.srtpControl = srtpControl == null ? NeomediaServiceUtils.getMediaServiceImpl().createSrtpControl(SrtpControlType.NULL) : srtpControl;
        this.srtpControl.registerUser(this);
        this.mediaStreamStatsImpl = new MediaStreamStats2Impl(this);
        if (connector != null) {
            this.setConnector(connector);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode()));
        }
        this.diagnosticContext.put((Object)"stream", (Object)this.hashCode());
    }

    public DiagnosticContext getDiagnosticContext() {
        return this.diagnosticContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicRTPPayloadType(byte rtpPayloadType, MediaFormat format) {
        MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)format;
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            this.dynamicRTPPayloadTypes.put(rtpPayloadType, format);
        }
        String encoding = format.getEncoding();
        if ("red".equals(encoding)) {
            REDTransformEngine redTransformEngine = this.getRedTransformEngine();
            if (redTransformEngine != null) {
                redTransformEngine.setIncomingPT(rtpPayloadType);
                redTransformEngine.setOutgoingPT(rtpPayloadType);
            }
        } else if ("ulpfec".equals(encoding)) {
            TransformEngineWrapper<FECTransformEngine> fecTransformEngineWrapper = this.getFecTransformEngine();
            if (fecTransformEngineWrapper.getWrapped() != null) {
                FECTransformEngine fecTransformEngine = fecTransformEngineWrapper.getWrapped();
                fecTransformEngine.setIncomingPT(rtpPayloadType);
                fecTransformEngine.setOutgoingPT(rtpPayloadType);
            }
        } else if ("flexfec-03".equals(encoding)) {
            TransformEngineWrapper<FECTransformEngine> fecTransformEngineWrapper = this.getFecTransformEngine();
            if (fecTransformEngineWrapper.getWrapped() != null) {
                logger.info((Object)("Updating existing FlexFEC-03 transform engine with payload type " + rtpPayloadType));
                fecTransformEngineWrapper.getWrapped().setIncomingPT(rtpPayloadType);
                fecTransformEngineWrapper.getWrapped().setOutgoingPT(rtpPayloadType);
            } else {
                logger.info((Object)("Creating FlexFEC-03 transform engine with payload type " + rtpPayloadType));
                FECTransformEngine flexFecTransformEngine = new FECTransformEngine(FECTransformEngine.FecType.FLEXFEC_03, rtpPayloadType, rtpPayloadType, this);
                this.setFecTransformEngine(flexFecTransformEngine);
            }
        }
        if (this.rtpManager != null) {
            this.rtpManager.addFormat((Format)mediaFormatImpl.getFormat(), rtpPayloadType);
        }
        this.onDynamicPayloadTypesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDynamicRTPPayloadTypes() {
        TransformEngineWrapper<FECTransformEngine> fecTransformEngineWrapper;
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            this.dynamicRTPPayloadTypes.clear();
        }
        REDTransformEngine redTransformEngine = this.getRedTransformEngine();
        if (redTransformEngine != null) {
            redTransformEngine.setIncomingPT((byte)-1);
            redTransformEngine.setOutgoingPT((byte)-1);
        }
        if ((fecTransformEngineWrapper = this.getFecTransformEngine()) != null && fecTransformEngineWrapper.getWrapped() != null) {
            FECTransformEngine fecTransformEngine = fecTransformEngineWrapper.getWrapped();
            fecTransformEngine.setIncomingPT((byte)-1);
            fecTransformEngine.setOutgoingPT((byte)-1);
        }
        this.onDynamicPayloadTypesChanged();
    }

    @Override
    public void addDynamicRTPPayloadTypeOverride(byte originalPt, byte overloadPt) {
        if (this.ptTransformEngine != null) {
            this.ptTransformEngine.addPTMappingOverride(originalPt, overloadPt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.receiveStreamsLock.writeLock();
        Lock readLock = this.receiveStreamsLock.readLock();
        boolean added = false;
        writeLock.lock();
        try {
            if (!this.receiveStreams.contains(receiveStream) && this.receiveStreams.add(receiveStream)) {
                readLock.lock();
                added = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (added) {
            try {
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession == null || deviceSession.useTranslator) {
                    ReceiveStreamPushBufferDataSource.setNullTransferHandler(receiveStream);
                } else {
                    deviceSession.addReceiveStream(receiveStream);
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return added;
    }

    protected void addRemoteSourceID(long remoteSourceID) {
        Long oldValue = this.getRemoteSourceID();
        if (!this.remoteSourceIDs.contains(remoteSourceID)) {
            this.remoteSourceIDs.add(remoteSourceID);
        }
        this.firePropertyChange("remoteSSRCAvailable", oldValue, remoteSourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRTPExtension(byte extensionID, RTPExtension rtpExtension) {
        if (rtpExtension == null) {
            return;
        }
        boolean active = !MediaDirection.INACTIVE.equals((Object)rtpExtension.getDirection());
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            if (active) {
                this.activeRTPExtensions.put(extensionID, rtpExtension);
            } else {
                this.activeRTPExtensions.remove(extensionID);
            }
        }
        this.enableRTPExtension(extensionID, rtpExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRTPExtensions() {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            RemoteBitrateEstimatorWrapper remoteBitrateEstimatorWrapper;
            this.activeRTPExtensions.clear();
            this.frameMarkingsExtensionId = -1;
            if (this.transportCCEngine != null) {
                this.transportCCEngine.setExtensionID(-1);
            }
            if (this.ohbEngine != null) {
                this.ohbEngine.setExtensionID(-1);
            }
            if ((remoteBitrateEstimatorWrapper = this.getRemoteBitrateEstimator()) != null) {
                remoteBitrateEstimatorWrapper.setAstExtensionID(-1);
                remoteBitrateEstimatorWrapper.setTccExtensionID(-1);
            }
            if (this.absSendTimeEngine != null) {
                this.absSendTimeEngine.setExtensionID(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableRTPExtensions() {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            for (Map.Entry<Byte, RTPExtension> entry : this.activeRTPExtensions.entrySet()) {
                this.enableRTPExtension(entry.getKey(), entry.getValue());
            }
        }
    }

    private void enableRTPExtension(byte extensionID, RTPExtension rtpExtension) {
        boolean active = !MediaDirection.INACTIVE.equals((Object)rtpExtension.getDirection());
        int effectiveId = active ? RTPUtils.as16Bits(extensionID) : -1;
        String uri = rtpExtension.getURI().toString();
        if ("http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time".equals(uri)) {
            RemoteBitrateEstimatorWrapper remoteBitrateEstimatorWrapper;
            if (this.absSendTimeEngine != null) {
                this.absSendTimeEngine.setExtensionID(effectiveId);
            }
            if ((remoteBitrateEstimatorWrapper = this.getRemoteBitrateEstimator()) != null) {
                remoteBitrateEstimatorWrapper.setAstExtensionID(effectiveId);
            }
        } else if ("http://tools.ietf.org/html/draft-ietf-avtext-framemarking-07".equals(uri)) {
            this.frameMarkingsExtensionId = effectiveId;
        } else if ("urn:ietf:params:rtp-hdrext:ohb".equals(uri)) {
            this.ohbEngine.setExtensionID(effectiveId);
        } else if ("http://www.ietf.org/id/draft-holmer-rmcat-transport-wide-cc-extensions-01".equals(uri)) {
            this.transportCCEngine.setExtensionID(effectiveId);
            RemoteBitrateEstimatorWrapper remoteBitrateEstimatorWrapper = this.getRemoteBitrateEstimator();
            if (remoteBitrateEstimatorWrapper != null) {
                remoteBitrateEstimatorWrapper.setTccExtensionID(effectiveId);
            }
        }
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            this.printReceiveStreamStatistics();
        }
        this.stop();
        this.closeSendStreams();
        this.srtpControl.cleanup(this);
        if (this.csrcEngine != null) {
            this.csrcEngine = null;
        }
        if (this.cachingTransformer != null) {
            this.cachingTransformer.close();
            this.cachingTransformer = null;
        }
        if (this.retransmissionRequester != null) {
            this.retransmissionRequester.close();
        }
        if (this.transformEngineChain != null) {
            PacketTransformer t = this.transformEngineChain.getRTPTransformer();
            if (t != null) {
                t.close();
            }
            if ((t = this.transformEngineChain.getRTCPTransformer()) != null) {
                t.close();
            }
            this.transformEngineChain = null;
        }
        if (this.transportCCEngine != null) {
            this.transportCCEngine.removeMediaStream(this);
        }
        if (this.rtpManager != null) {
            if (logger.isInfoEnabled()) {
                this.printFlowStatistics(this.rtpManager);
            }
            this.rtpManager.removeReceiveStreamListener(this);
            this.rtpManager.removeSendStreamListener(this);
            this.rtpManager.removeSessionListener(this);
            this.rtpManager.removeRemoteListener(this);
            try {
                this.rtpManager.dispose();
                this.rtpManager = null;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)"Failed to dispose of RTPManager", t);
            }
        }
        if (this.rtpConnector != null) {
            this.rtpConnector.removeTargets();
        }
        this.rtpConnectorTarget = null;
        if (this.deviceSession != null) {
            this.deviceSession.close();
        }
    }

    private void closeSendStreams() {
        this.stopSendStreams(true);
    }

    protected void configureDataInputStream(RTPConnectorInputStream<?> dataInputStream) {
        dataInputStream.setPriority(this.getPriority());
    }

    protected void configureDataOutputStream(RTPConnectorOutputStream dataOutputStream) {
        dataOutputStream.setPriority(this.getPriority());
    }

    protected void configureRTPManagerBufferControl(StreamRTPManager rtpManager, BufferControl bufferControl) {
    }

    protected DtmfTransformEngine createDtmfTransformEngine() {
        return null;
    }

    protected void createSendStreams() {
        PushBufferStream[] streams;
        DataSource dataSource;
        StreamRTPManager rtpManager = this.getRTPManager();
        MediaDeviceSession deviceSession = this.getDeviceSession();
        DataSource dataSource2 = dataSource = deviceSession == null ? null : deviceSession.getOutputDataSource();
        int streamCount = dataSource instanceof PushBufferDataSource ? ((streams = ((PushBufferDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PushDataSource ? ((streams = ((PushDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PullBufferDataSource ? ((streams = ((PullBufferDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PullDataSource ? ((streams = ((PullDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource == null ? 0 : 1))));
        this.registerCustomCodecFormats(rtpManager);
        for (int streamIndex = 0; streamIndex < streamCount; ++streamIndex) {
            try {
                SendStream sendStream = rtpManager.createSendStream(dataSource, streamIndex);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Created SendStream with hashCode " + sendStream.hashCode() + " for " + MediaStreamImpl.toString(dataSource) + " and streamIndex " + streamIndex + " in RTPManager with hashCode " + rtpManager.hashCode()));
                }
                long localSSRC = sendStream.getSSRC() & 0xFFFFFFFFL;
                if (this.getLocalSourceID() == localSSRC) continue;
                this.setLocalSourceID(localSSRC);
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)("Failed to create send stream for data source " + dataSource + " and stream index " + streamIndex), (Throwable)ioe);
                continue;
            }
            catch (UnsupportedFormatException ufe) {
                logger.error((Object)("Failed to create send stream for data source " + dataSource + " and stream index " + streamIndex + " because of failed format " + ufe.getFailedFormat()), (Throwable)ufe);
            }
        }
        this.sendStreamsAreCreated = true;
        if (logger.isTraceEnabled()) {
            Vector sendStreams = rtpManager.getSendStreams();
            int sendStreamCount = sendStreams == null ? 0 : sendStreams.size();
            logger.trace((Object)("Total number of SendStreams in RTPManager with hashCode " + rtpManager.hashCode() + " is " + sendStreamCount));
        }
    }

    protected SsrcTransformEngine createSsrcTransformEngine() {
        return null;
    }

    protected AbsSendTimeEngine createAbsSendTimeEngine() {
        return new AbsSendTimeEngine();
    }

    protected CachingTransformer createCachingTransformer() {
        return null;
    }

    protected RetransmissionRequesterImpl createRetransmissionRequester() {
        return null;
    }

    private TransformEngineChain createTransformEngineChain() {
        SsrcTransformEngine ssrcEngine;
        RemoteBitrateEstimatorWrapper remoteBitrateEstimator;
        RtxTransformer rtxTransformer;
        PaddingTermination paddingTermination;
        MediaStreamTrackReceiver mediaStreamTrackReceiver;
        DiscardTransformEngine discardEngine;
        REDTransformEngine redTransformEngine;
        ArrayList<Object> engineChain = new ArrayList<Object>(9);
        if (this.csrcEngine == null) {
            this.csrcEngine = new CsrcTransformEngine(this);
        }
        engineChain.add(this.csrcEngine);
        DtmfTransformEngine dtmfEngine = this.createDtmfTransformEngine();
        if (dtmfEngine != null) {
            engineChain.add(dtmfEngine);
        }
        engineChain.add(this.externalTransformerWrapper);
        TransformEngine rtcpFeedbackTermination = this.getRTCPTermination();
        if (rtcpFeedbackTermination != null) {
            engineChain.add(rtcpFeedbackTermination);
        }
        if (this.ptTransformEngine == null) {
            this.ptTransformEngine = new PayloadTypeTransformEngine();
        }
        engineChain.add(this.ptTransformEngine);
        TransformEngineWrapper<FECTransformEngine> fecTransformEngineWrapper = this.getFecTransformEngine();
        if (fecTransformEngineWrapper != null) {
            engineChain.add(fecTransformEngineWrapper);
        }
        if ((redTransformEngine = this.getRedTransformEngine()) != null) {
            engineChain.add(redTransformEngine);
        }
        if (this.statisticsEngine == null) {
            this.statisticsEngine = new StatisticsEngine(this);
        }
        engineChain.add(this.statisticsEngine);
        if (this.retransmissionRequester != null) {
            engineChain.add(this.retransmissionRequester);
        }
        if (this.cachingTransformer != null) {
            engineChain.add(this.cachingTransformer);
        }
        if ((discardEngine = this.createDiscardEngine()) != null) {
            engineChain.add(discardEngine);
        }
        if ((mediaStreamTrackReceiver = this.getMediaStreamTrackReceiver()) != null) {
            engineChain.add(mediaStreamTrackReceiver);
        }
        if ((paddingTermination = this.getPaddingTermination()) != null) {
            engineChain.add(paddingTermination);
        }
        if ((rtxTransformer = this.getRtxTransformer()) != null) {
            engineChain.add(rtxTransformer);
        }
        if ((remoteBitrateEstimator = this.getRemoteBitrateEstimator()) != null) {
            engineChain.add(remoteBitrateEstimator);
        }
        this.absSendTimeEngine = this.createAbsSendTimeEngine();
        if (this.absSendTimeEngine != null) {
            engineChain.add(this.absSendTimeEngine);
        }
        if (this.transportCCEngine != null) {
            engineChain.add(this.transportCCEngine.getEgressEngine());
        }
        this.debugTransformEngine = DebugTransformEngine.createDebugTransformEngine(this);
        if (this.debugTransformEngine != null) {
            engineChain.add(this.debugTransformEngine);
        }
        engineChain.add(this.ohbEngine);
        SrtpControl.TransformEngine srtpTransformEngine = this.srtpControl.getTransformEngine();
        if (srtpTransformEngine != null) {
            engineChain.add(this.srtpControl.getTransformEngine());
        }
        if (this.transportCCEngine != null) {
            engineChain.add(this.transportCCEngine.getIngressEngine());
        }
        if ((ssrcEngine = this.createSsrcTransformEngine()) != null) {
            engineChain.add(ssrcEngine);
        }
        this.enableRTPExtensions();
        return new TransformEngineChain(engineChain.toArray(new TransformEngine[engineChain.size()]));
    }

    protected void deviceSessionChanged(MediaDeviceSession oldValue, MediaDeviceSession newValue) {
        this.recreateSendStreams();
    }

    private void deviceSessionOutputDataSourceChanged() {
        this.recreateSendStreams();
    }

    private void deviceSessionSsrcListChanged(PropertyChangeEvent ev) {
        long[] ssrcArray = (long[])ev.getNewValue();
        if (ssrcArray == null) {
            this.localContributingSourceIDs = null;
            return;
        }
        int elementsToRemove = 0;
        Vector<Long> remoteSourceIDs = this.remoteSourceIDs;
        for (int i = 0; i < ssrcArray.length; ++i) {
            long csrc = ssrcArray[i];
            if (!remoteSourceIDs.contains(csrc)) continue;
            ++elementsToRemove;
        }
        if (elementsToRemove >= ssrcArray.length) {
            this.localContributingSourceIDs = null;
            return;
        }
        int cc = Math.min(ssrcArray.length - elementsToRemove + 1, 15);
        long[] csrcArray = new long[cc];
        int j = 0;
        for (int i = 0; i < ssrcArray.length && j < csrcArray.length - 1; ++i) {
            long ssrc = ssrcArray[i];
            if (remoteSourceIDs.contains(ssrc)) continue;
            csrcArray[j] = ssrc;
            ++j;
        }
        csrcArray[csrcArray.length - 1] = this.getLocalSourceID();
        this.localContributingSourceIDs = csrcArray;
    }

    private void doSetTarget(MediaStreamTarget target) {
        boolean targetIsSet;
        InetSocketAddress newControlAddr;
        InetSocketAddress newDataAddr;
        AbstractRTPConnector connector = this.rtpConnector;
        if (target == null) {
            newDataAddr = null;
            newControlAddr = null;
        } else {
            newDataAddr = target.getDataAddress();
            newControlAddr = target.getControlAddress();
        }
        if (this.rtpConnectorTarget != null && connector != null) {
            boolean removeTargets;
            InetSocketAddress oldDataAddr = this.rtpConnectorTarget.getDataAddress();
            boolean bl = oldDataAddr == null ? newDataAddr != null : (removeTargets = !oldDataAddr.equals(newDataAddr));
            if (!removeTargets) {
                InetSocketAddress oldControlAddr = this.rtpConnectorTarget.getControlAddress();
                boolean bl2 = oldControlAddr == null ? newControlAddr != null : (removeTargets = !oldControlAddr.equals(newControlAddr));
            }
            if (removeTargets) {
                connector.removeTargets();
                this.rtpConnectorTarget = null;
            }
        }
        if (target == null || newDataAddr == null || connector == null) {
            targetIsSet = true;
        } else {
            try {
                int controlPort;
                InetAddress controlInetAddr;
                if (newControlAddr == null) {
                    controlInetAddr = null;
                    controlPort = 0;
                } else {
                    controlInetAddr = newControlAddr.getAddress();
                    controlPort = newControlAddr.getPort();
                }
                connector.addTarget(new SessionAddress(newDataAddr.getAddress(), newDataAddr.getPort(), controlInetAddr, controlPort));
                targetIsSet = true;
            }
            catch (IOException ioe) {
                targetIsSet = false;
                logger.error((Object)("Failed to set target " + target), (Throwable)ioe);
            }
        }
        if (targetIsSet) {
            this.rtpConnectorTarget = target;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Set target of " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode() + " to " + target));
            }
        }
    }

    public TransportCCEngine getTransportCCEngine() {
        return this.transportCCEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getActiveRTPExtensionID(RTPExtension rtpExtension) {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            for (Map.Entry<Byte, RTPExtension> entry : this.activeRTPExtensions.entrySet()) {
                if (!entry.getValue().equals(rtpExtension)) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Byte, RTPExtension> getActiveRTPExtensions() {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            return new HashMap<Byte, RTPExtension>(this.activeRTPExtensions);
        }
    }

    protected CsrcTransformEngine getCsrcEngine() {
        return this.csrcEngine;
    }

    @Override
    public AbstractMediaDevice getDevice() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? null : deviceSession.getDevice();
    }

    private MediaDirection getDeviceDirection() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? MediaDirection.SENDRECV : deviceSession.getDevice().getDirection();
    }

    public MediaDeviceSession getDeviceSession() {
        return this.deviceSession;
    }

    @Override
    public MediaDirection getDirection() {
        return this.direction == null ? this.getDeviceDirection() : this.direction;
    }

    @Override
    public byte getDynamicRTPPayloadType(String encoding) {
        for (Map.Entry<Byte, MediaFormat> dynamicRTPPayloadType : this.getDynamicRTPPayloadTypes().entrySet()) {
            if (!dynamicRTPPayloadType.getValue().getEncoding().equals(encoding)) continue;
            return dynamicRTPPayloadType.getKey();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Byte, MediaFormat> getDynamicRTPPayloadTypes() {
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            return new HashMap<Byte, MediaFormat>(this.dynamicRTPPayloadTypes);
        }
    }

    protected TransformEngineWrapper<FECTransformEngine> getFecTransformEngine() {
        return null;
    }

    protected void setFecTransformEngine(FECTransformEngine fecTransformEngine) {
    }

    @Override
    public MediaFormat getFormat() {
        MediaDeviceSession devSess = this.getDeviceSession();
        return devSess == null ? null : devSess.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaFormat getFormat(byte pt) {
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            return this.dynamicRTPPayloadTypes.get(pt);
        }
    }

    public long[] getLocalContributingSourceIDs() {
        return this.localContributingSourceIDs;
    }

    public InetSocketAddress getLocalControlAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getControlSocket().getLocalSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getControlTCPSocket().getLocalSocketAddress();
            }
        }
        return null;
    }

    public InetSocketAddress getLocalDataAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getDataSocket().getLocalSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getDataTCPSocket().getLocalSocketAddress();
            }
        }
        return null;
    }

    @Override
    public long getLocalSourceID() {
        return this.localSourceID;
    }

    @Override
    public MediaStreamStats2Impl getMediaStreamStats() {
        return this.mediaStreamStatsImpl;
    }

    public MediaType getMediaType() {
        MediaFormat format = this.getFormat();
        MediaType mediaType = null;
        if (format != null) {
            mediaType = format.getMediaType();
        }
        if (mediaType == null) {
            MediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                mediaType = deviceSession.getDevice().getMediaType();
            }
            if (mediaType == null) {
                if (this instanceof AudioMediaStream) {
                    mediaType = MediaType.AUDIO;
                } else if (this instanceof VideoMediaStream) {
                    mediaType = MediaType.VIDEO;
                }
            }
        }
        return mediaType;
    }

    protected int getPriority() {
        return Thread.currentThread().getPriority();
    }

    public ReceiveStream getReceiveStream(int ssrc) {
        for (ReceiveStream receiveStream : this.getReceiveStreams()) {
            int receiveStreamSSRC = (int)receiveStream.getSSRC();
            if (receiveStreamSSRC != ssrc) continue;
            return receiveStream;
        }
        return null;
    }

    public Collection<ReceiveStream> getReceiveStreams() {
        Vector rtpManagerReceiveStreams;
        HashSet<ReceiveStream> receiveStreams = new HashSet<ReceiveStream>();
        Lock readLock = this.receiveStreamsLock.readLock();
        readLock.lock();
        try {
            receiveStreams.addAll(this.receiveStreams);
        }
        finally {
            readLock.unlock();
        }
        StreamRTPManager rtpManager = this.queryRTPManager();
        if (rtpManager != null && (rtpManagerReceiveStreams = rtpManager.getReceiveStreams()) != null) {
            receiveStreams.addAll(rtpManagerReceiveStreams);
        }
        return receiveStreams;
    }

    protected REDTransformEngine getRedTransformEngine() {
        return null;
    }

    public long[] getRemoteContributingSourceIDs() {
        return this.getDeviceSession().getRemoteSSRCList();
    }

    @Override
    public InetSocketAddress getRemoteControlAddress() {
        StreamConnector connector;
        if (this.rtpConnector != null && (connector = this.rtpConnector.getConnector()) != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getControlSocket().getRemoteSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getControlTCPSocket().getRemoteSocketAddress();
            }
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteDataAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getDataSocket().getRemoteSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getDataTCPSocket().getRemoteSocketAddress();
            }
        }
        return null;
    }

    @Override
    public long getRemoteSourceID() {
        return this.remoteSourceIDs.isEmpty() ? -1L : this.remoteSourceIDs.lastElement();
    }

    @Override
    public List<Long> getRemoteSourceIDs() {
        return Collections.unmodifiableList(this.remoteSourceIDs);
    }

    protected AbstractRTPConnector getRTPConnector() {
        return this.rtpConnector;
    }

    public StreamRTPManager getRTPManager() {
        if (this.rtpManager == null) {
            AbstractRTPConnector rtpConnector = this.getRTPConnector();
            if (rtpConnector == null) {
                throw new IllegalStateException("rtpConnector");
            }
            this.rtpManager = new StreamRTPManager(this, this.rtpTranslator);
            this.registerCustomCodecFormats(this.rtpManager);
            this.rtpManager.addReceiveStreamListener(this);
            this.rtpManager.addSendStreamListener(this);
            this.rtpManager.addSessionListener(this);
            this.rtpManager.addRemoteListener(this);
            BufferControl bc = this.rtpManager.getControl(BufferControl.class);
            if (bc != null) {
                this.configureRTPManagerBufferControl(this.rtpManager, bc);
            }
            this.rtpManager.setSSRCFactory(this.ssrcFactory);
            this.rtpManager.initialize(rtpConnector);
            long localSSRC = this.rtpManager.getLocalSSRC();
            this.setLocalSourceID(localSSRC == Long.MAX_VALUE ? -1L : localSSRC & 0xFFFFFFFFL);
        }
        return this.rtpManager;
    }

    @Override
    public StreamRTPManager getStreamRTPManager() {
        return this.queryRTPManager();
    }

    @Override
    public SrtpControl getSrtpControl() {
        return this.srtpControl;
    }

    @Override
    public MediaStreamTarget getTarget() {
        return this.rtpConnectorTarget;
    }

    @Override
    public StreamConnector.Protocol getTransportProtocol() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector == null) {
            return null;
        }
        return connector.getProtocol();
    }

    @Override
    public boolean isMute() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? this.mute : deviceSession.isMute();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private void maybeUpdateDynamicRTPPayloadTypes(StreamRTPManager rtpManager) {
        if (rtpManager == null && (rtpManager = this.queryRTPManager()) == null) {
            return;
        }
        MediaFormat mediaFormat = this.getFormat();
        if (!(mediaFormat instanceof MediaFormatImpl)) {
            return;
        }
        MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)mediaFormat;
        Object format = mediaFormatImpl.getFormat();
        if (!(format instanceof ParameterizedVideoFormat)) {
            return;
        }
        for (Map.Entry<Byte, MediaFormat> dynamicRTPPayloadType : this.getDynamicRTPPayloadTypes().entrySet()) {
            MediaFormatImpl dynamicMediaFormatImpl;
            Object dynamicFormat;
            MediaFormat dynamicMediaFormat = dynamicRTPPayloadType.getValue();
            if (!(dynamicMediaFormat instanceof MediaFormatImpl) || !format.matches(dynamicFormat = (dynamicMediaFormatImpl = (MediaFormatImpl)dynamicMediaFormat).getFormat()) || !dynamicFormat.matches(format)) continue;
            rtpManager.addFormat((Format)format, dynamicRTPPayloadType.getKey().byteValue());
        }
    }

    private void printFlowStatistics(StreamRTPManager rtpManager) {
        try {
            if (!logger.isDebugEnabled()) {
                return;
            }
            GlobalTransmissionStats s = rtpManager.getGlobalTransmissionStats();
            String rtpstat = "rtpstat:";
            MediaStreamStats2Impl mss = this.getMediaStreamStats();
            StringBuilder buff = new StringBuilder(rtpstat);
            MediaType mediaType = this.getMediaType();
            String mediaTypeStr = mediaType == null ? "" : mediaType.toString();
            String eol = "\n" + rtpstat;
            buff.append("call stats for outgoing ").append(mediaTypeStr).append(" stream SSRC: ").append(this.getLocalSourceID()).append(eol).append("bytes sent: ").append(s.getBytesSent()).append(eol).append("RTP sent: ").append(s.getRTPSent()).append(eol).append("remote reported min interarrival jitter: ").append(mss.getMinUploadJitterMs()).append("ms").append(eol).append("remote reported max interarrival jitter: ").append(mss.getMaxUploadJitterMs()).append("ms").append(eol).append("local collisions: ").append(s.getLocalColls()).append(eol).append("remote collisions: ").append(s.getRemoteColls()).append(eol).append("RTCP sent: ").append(s.getRTCPSent()).append(eol).append("transmit failed: ").append(s.getTransmitFailed());
            logger.debug((Object)buff);
            GlobalReceptionStats rs = rtpManager.getGlobalReceptionStats();
            MediaFormat format = this.getFormat();
            buff = new StringBuilder(rtpstat);
            buff.append("call stats for incoming ").append(format == null ? "" : format).append(" stream SSRC: ").append(this.getRemoteSourceID()).append(eol).append("packets received: ").append(rs.getPacketsRecd()).append(eol).append("bytes received: ").append(rs.getBytesRecd()).append(eol).append("packets lost: ").append(mss.getReceiveStats().getPacketsLost()).append(eol).append("min interarrival jitter: ").append(this.statisticsEngine.getMinInterArrivalJitter()).append(eol).append("max interarrival jitter: ").append(this.statisticsEngine.getMaxInterArrivalJitter()).append(eol).append("RTCPs received: ").append(rs.getRTCPRecd()).append(eol).append("bad RTCP packets: ").append(rs.getBadRTCPPkts()).append(eol).append("bad RTP packets: ").append(rs.getBadRTPkts()).append(eol).append("local collisions: ").append(rs.getLocalColls()).append(eol).append("malformed BYEs: ").append(rs.getMalformedBye()).append(eol).append("malformed RRs: ").append(rs.getMalformedRR()).append(eol).append("malformed SDESs: ").append(rs.getMalformedSDES()).append(eol).append("malformed SRs: ").append(rs.getMalformedSR()).append(eol).append("packets looped: ").append(rs.getPacketsLooped()).append(eol).append("remote collisions: ").append(rs.getRemoteColls()).append(eol).append("SRs received: ").append(rs.getSRRecd()).append(eol).append("transmit failed: ").append(rs.getTransmitFailed()).append(eol).append("unknown types: ").append(rs.getUnknownTypes());
            logger.debug((Object)buff);
        }
        catch (Throwable t) {
            logger.error((Object)"Error writing statistics", t);
        }
    }

    private void printReceiveStreamStatistics() {
        this.mediaStreamStatsImpl.updateStats();
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("\nReceive stream stats: discarded RTP packets: ").append(this.mediaStreamStatsImpl.getNbDiscarded()).append("\nReceive stream stats: decoded with FEC: ").append(this.mediaStreamStatsImpl.getNbFec());
            logger.debug((Object)sb);
        }
    }

    public StreamRTPManager queryRTPManager() {
        return this.rtpManager;
    }

    protected void recreateSendStreams() {
        if (this.sendStreamsAreCreated) {
            this.closeSendStreams();
            if (this.getDeviceSession() != null && this.rtpManager != null && (MediaDirection.SENDONLY.equals((Object)this.startedDirection) || MediaDirection.SENDRECV.equals((Object)this.startedDirection))) {
                this.startSendStreams();
            }
        }
    }

    protected void registerCustomCodecFormats(StreamRTPManager rtpManager) {
        for (Map.Entry<Byte, MediaFormat> dynamicRTPPayloadType : this.getDynamicRTPPayloadTypes().entrySet()) {
            MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)dynamicRTPPayloadType.getValue();
            Object format = mediaFormatImpl.getFormat();
            rtpManager.addFormat((Format)format, dynamicRTPPayloadType.getKey().byteValue());
        }
        this.maybeUpdateDynamicRTPPayloadTypes(rtpManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.receiveStreamsLock.writeLock();
        Lock readLock = this.receiveStreamsLock.readLock();
        boolean removed = false;
        writeLock.lock();
        try {
            if (this.receiveStreams.remove(receiveStream)) {
                readLock.lock();
                removed = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (removed) {
            try {
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession != null) {
                    deviceSession.removeReceiveStream(receiveStream);
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return removed;
    }

    @Override
    public void removeReceiveStreamForSsrc(long ssrc) {
        ReceiveStream toRemove = this.getReceiveStream((int)ssrc);
        if (toRemove != null) {
            this.removeReceiveStream(toRemove);
        }
        this.mediaStreamStatsImpl.removeReceiveSsrc(ssrc);
    }

    protected void rtpConnectorChanged(AbstractRTPConnector oldValue, AbstractRTPConnector newValue) {
        if (newValue != null) {
            if (newValue instanceof RTPTransformUDPConnector) {
                this.transformEngineChain = this.createTransformEngineChain();
                ((RTPTransformUDPConnector)newValue).setEngine(this.transformEngineChain);
            } else if (newValue instanceof RTPTransformTCPConnector) {
                this.transformEngineChain = this.createTransformEngineChain();
                ((RTPTransformTCPConnector)newValue).setEngine(this.transformEngineChain);
            }
            if (this.rtpConnectorTarget != null) {
                this.doSetTarget(this.rtpConnectorTarget);
            }
            this.addRTPExtension((byte)0, null);
        }
        this.srtpControl.setConnector(newValue);
        try {
            this.firePropertyChange(MediaStreamImpl.class.getName() + ".rtpConnector", oldValue, newValue);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)t);
        }
    }

    private void rtpConnectorInputStreamCreated(RTPConnectorInputStream<?> inputStream, boolean data) {
        try {
            this.firePropertyChange(MediaStreamImpl.class.getName() + ".rtpConnector." + (data ? "data" : "control") + "InputStream", null, inputStream);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)t);
        }
    }

    @Override
    public void setConnector(StreamConnector connector) {
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        AbstractRTPConnector oldValue = this.rtpConnector;
        if (oldValue != null && oldValue.getConnector() == connector) {
            return;
        }
        switch (connector.getProtocol()) {
            case UDP: {
                this.rtpConnector = new RTPTransformUDPConnector(connector){

                    @Override
                    protected RTPConnectorUDPInputStream createControlInputStream() throws IOException {
                        RTPConnectorUDPInputStream s = super.createControlInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, false);
                        return s;
                    }

                    @Override
                    protected RTPConnectorUDPInputStream createDataInputStream() throws IOException {
                        RTPConnectorUDPInputStream s = super.createDataInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, true);
                        if (s != null) {
                            MediaStreamImpl.this.configureDataInputStream(s);
                        }
                        return s;
                    }

                    @Override
                    protected TransformUDPOutputStream createDataOutputStream() throws IOException {
                        TransformUDPOutputStream s = super.createDataOutputStream();
                        if (s != null) {
                            MediaStreamImpl.this.configureDataOutputStream(s);
                        }
                        return s;
                    }
                };
                break;
            }
            case TCP: {
                this.rtpConnector = new RTPTransformTCPConnector(connector){

                    @Override
                    protected RTPConnectorTCPInputStream createControlInputStream() throws IOException {
                        RTPConnectorTCPInputStream s = super.createControlInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, false);
                        return s;
                    }

                    @Override
                    protected RTPConnectorTCPInputStream createDataInputStream() throws IOException {
                        RTPConnectorTCPInputStream s = super.createDataInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, true);
                        if (s != null) {
                            MediaStreamImpl.this.configureDataInputStream(s);
                        }
                        return s;
                    }

                    @Override
                    protected TransformTCPOutputStream createDataOutputStream() throws IOException {
                        TransformTCPOutputStream s = super.createDataOutputStream();
                        if (s != null) {
                            MediaStreamImpl.this.configureDataOutputStream(s);
                        }
                        return s;
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("connector");
            }
        }
        this.rtpConnectorChanged(oldValue, this.rtpConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDevice(MediaDevice device) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        AbstractMediaDevice abstractMediaDevice = (AbstractMediaDevice)device;
        if (this.deviceSession == null || this.deviceSession.getDevice() != device) {
            MediaDirection startedDirection;
            MediaFormat format;
            this.assertDirection(this.direction, device.getDirection(), "device");
            MediaDeviceSession oldValue = this.deviceSession;
            if (this.deviceSession != null) {
                format = this.getFormat();
                startedDirection = this.deviceSession.getStartedDirection();
                this.deviceSession.removePropertyChangeListener(this.deviceSessionPropertyChangeListener);
                this.deviceSession.setDisposePlayerOnClose(!(this.deviceSession instanceof VideoMediaDeviceSession));
                this.deviceSession.close();
                this.deviceSession = null;
            } else {
                format = null;
                startedDirection = MediaDirection.INACTIVE;
            }
            this.deviceSession = abstractMediaDevice.createSession();
            if (oldValue != null) {
                this.deviceSession.copyPlayback(oldValue);
            }
            this.deviceSession.addPropertyChangeListener(this.deviceSessionPropertyChangeListener);
            this.direction = null;
            if (this.deviceSession != null) {
                if (format != null) {
                    this.deviceSession.setFormat(format);
                }
                this.deviceSession.setMute(this.mute);
            }
            this.deviceSessionChanged(oldValue, this.deviceSession);
            if (this.deviceSession != null) {
                this.deviceSession.start(startedDirection);
                Lock receiveStreamsReadLock = this.receiveStreamsLock.readLock();
                receiveStreamsReadLock.lock();
                try {
                    for (ReceiveStream receiveStream : this.receiveStreams) {
                        this.deviceSession.addReceiveStream(receiveStream);
                    }
                }
                finally {
                    receiveStreamsReadLock.unlock();
                }
            }
        }
    }

    @Override
    public void setDirection(MediaDirection direction) {
        AbstractRTPConnector connector;
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        if (this.direction == direction) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Changing direction of stream " + this.hashCode() + " from:" + (Object)((Object)this.direction) + " to:" + (Object)((Object)direction)));
        }
        this.assertDirection(direction, this.getDeviceDirection(), "direction");
        this.direction = direction;
        switch (this.direction) {
            case INACTIVE: {
                this.stop(MediaDirection.SENDRECV);
                return;
            }
            case RECVONLY: {
                this.stop(MediaDirection.SENDONLY);
                break;
            }
            case SENDONLY: {
                this.stop(MediaDirection.RECVONLY);
                break;
            }
            case SENDRECV: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.started) {
            this.start(this.direction);
        }
        if ((connector = this.getRTPConnector()) != null) {
            connector.setDirection(direction);
        }
    }

    @Override
    public void setFormat(MediaFormat format) {
        MediaDeviceSession devSess = this.getDeviceSession();
        MediaFormatImpl<? extends Format> thisFormat = null;
        if (devSess != null && (thisFormat = devSess.getFormat()) != null && thisFormat.equals(format) && thisFormat.advancedAttributesAreEqual(thisFormat.getAdvancedAttributes(), format.getAdvancedAttributes())) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Changing format of stream " + this.hashCode() + " from: " + thisFormat + " to: " + format));
        }
        this.handleAttributes(format, format.getAdvancedAttributes());
        this.handleAttributes(format, format.getFormatParameters());
        if (devSess != null) {
            devSess.setFormat(format);
        }
        this.maybeUpdateDynamicRTPPayloadTypes(null);
    }

    protected void setLocalSourceID(long localSourceID) {
        if (this.localSourceID != localSourceID) {
            Long oldValue = this.localSourceID;
            this.localSourceID = localSourceID;
            SrtpControl.TransformEngine transformEngine = this.srtpControl.getTransformEngine();
            if (transformEngine instanceof ZRTPTransformEngine) {
                ((ZRTPTransformEngine)transformEngine).setOwnSSRC(this.getLocalSourceID());
            }
            this.firePropertyChange("localSSRCAvailable", oldValue, this.localSourceID);
        }
    }

    @Override
    public void setMute(boolean mute) {
        if (this.mute != mute) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)((mute ? "Muting" : "Unmuting") + " stream with hashcode " + this.hashCode()));
            }
            this.mute = mute;
            MediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                deviceSession.setMute(this.mute);
            }
        }
    }

    @Override
    public void setSSRCFactory(SSRCFactory ssrcFactory) {
        if (this.ssrcFactory != ssrcFactory) {
            this.ssrcFactory = ssrcFactory;
            StreamRTPManager rtpManager = this.rtpManager;
            RTPTranslator translator = this.rtpTranslator;
            if (rtpManager != null) {
                rtpManager.setSSRCFactory(ssrcFactory);
            } else if (translator instanceof RTPTranslatorImpl) {
                ((RTPTranslatorImpl)translator).setSSRCFactory(ssrcFactory);
            }
        }
    }

    @Override
    public void setTarget(MediaStreamTarget target) {
        if (target == null ? this.rtpConnectorTarget == null : target.equals(this.rtpConnectorTarget)) {
            return;
        }
        this.doSetTarget(target);
    }

    @Override
    public void start() {
        this.start(this.getDirection());
        this.started = true;
    }

    private void start(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        boolean getRTPManagerForRTPTranslator = true;
        MediaDeviceSession deviceSession = this.getDeviceSession();
        if (direction.allowsSending() && (this.startedDirection == null || !this.startedDirection.allowsSending())) {
            getRTPManagerForRTPTranslator = false;
            this.startSendStreams();
            if (deviceSession != null) {
                deviceSession.start(MediaDirection.SENDONLY);
            }
            if (MediaDirection.RECVONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDRECV;
            } else if (this.startedDirection == null) {
                this.startedDirection = MediaDirection.SENDONLY;
            }
            if (logger.isInfoEnabled()) {
                MediaType mediaType = this.getMediaType();
                MediaStreamStats2Impl stats = this.getMediaStreamStats();
                logger.info((Object)(mediaType + " codec/freq: " + stats.getEncoding() + "/" + stats.getEncodingClockRate() + " Hz"));
                logger.info((Object)(mediaType + " remote IP/port: " + stats.getRemoteIPAddress() + "/" + stats.getRemotePort()));
            }
        }
        if (direction.allowsReceiving() && (this.startedDirection == null || !this.startedDirection.allowsReceiving())) {
            getRTPManagerForRTPTranslator = false;
            this.startReceiveStreams();
            if (deviceSession != null) {
                deviceSession.start(MediaDirection.RECVONLY);
            }
            if (MediaDirection.SENDONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDRECV;
            } else if (this.startedDirection == null) {
                this.startedDirection = MediaDirection.RECVONLY;
            }
        }
        if (getRTPManagerForRTPTranslator && this.rtpTranslator != null) {
            this.getRTPManager();
        }
    }

    private void startReceiveStreams() {
        this.getRTPManager();
        for (ReceiveStream receiveStream : this.getReceiveStreams()) {
            try {
                DataSource receiveStreamDataSource = receiveStream.getDataSource();
                if (receiveStreamDataSource == null) continue;
                receiveStreamDataSource.start();
            }
            catch (IOException ioex) {
                logger.warn((Object)("Failed to start receive stream " + receiveStream), (Throwable)ioex);
            }
        }
    }

    private void startSendStreams() {
        StreamRTPManager rtpManager;
        Vector sendStreams;
        if (!this.sendStreamsAreCreated) {
            this.createSendStreams();
        }
        if ((sendStreams = (rtpManager = this.getRTPManager()).getSendStreams()) != null) {
            for (SendStream sendStream : sendStreams) {
                try {
                    DataSource sendStreamDataSource = sendStream.getDataSource();
                    sendStreamDataSource.connect();
                    sendStream.start();
                    sendStreamDataSource.start();
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Started SendStream with hashCode " + sendStream.hashCode()));
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to start stream " + sendStream), (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void stop() {
        this.stop(MediaDirection.SENDRECV);
        this.started = false;
    }

    private void stop(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        if (this.rtpManager == null) {
            return;
        }
        if ((MediaDirection.SENDRECV.equals((Object)direction) || MediaDirection.SENDONLY.equals((Object)direction)) && (MediaDirection.SENDRECV.equals((Object)this.startedDirection) || MediaDirection.SENDONLY.equals((Object)this.startedDirection))) {
            this.stopSendStreams(this instanceof VideoMediaStream);
            if (this.deviceSession != null) {
                this.deviceSession.stop(MediaDirection.SENDONLY);
            }
            if (MediaDirection.SENDRECV.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.RECVONLY;
            } else if (MediaDirection.SENDONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = null;
            }
        }
        if ((MediaDirection.SENDRECV.equals((Object)direction) || MediaDirection.RECVONLY.equals((Object)direction)) && (MediaDirection.SENDRECV.equals((Object)this.startedDirection) || MediaDirection.RECVONLY.equals((Object)this.startedDirection))) {
            this.stopReceiveStreams();
            if (this.deviceSession != null) {
                this.deviceSession.stop(MediaDirection.RECVONLY);
            }
            if (MediaDirection.SENDRECV.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDONLY;
            } else if (MediaDirection.RECVONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = null;
            }
        }
    }

    private void stopReceiveStreams() {
        for (ReceiveStream receiveStream : this.getReceiveStreams()) {
            try {
                DataSource receiveStreamDataSource;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Stopping receive stream with hashcode " + receiveStream.hashCode()));
                }
                if ((receiveStreamDataSource = receiveStream.getDataSource()) == null) continue;
                receiveStreamDataSource.stop();
            }
            catch (IOException ioex) {
                logger.warn((Object)("Failed to stop receive stream " + receiveStream), (Throwable)ioex);
            }
        }
    }

    private Iterable<SendStream> stopSendStreams(boolean close) {
        if (this.rtpManager == null) {
            return null;
        }
        Vector sendStreams = this.rtpManager.getSendStreams();
        Iterable<SendStream> stoppedSendStreams = this.stopSendStreams(sendStreams, close);
        if (close) {
            this.sendStreamsAreCreated = false;
        }
        return stoppedSendStreams;
    }

    private Iterable<SendStream> stopSendStreams(Iterable<SendStream> sendStreams, boolean close) {
        if (sendStreams == null) {
            return null;
        }
        for (SendStream sendStream : sendStreams) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Stopping send stream with hashcode " + sendStream.hashCode()));
                }
                sendStream.getDataSource().stop();
                sendStream.stop();
                if (!close) continue;
                try {
                    sendStream.close();
                }
                catch (NullPointerException npe) {
                    logger.error((Object)("Failed to close send stream " + sendStream), (Throwable)npe);
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)("Failed to stop send stream " + sendStream), (Throwable)ioe);
            }
        }
        return sendStreams;
    }

    public void update(ReceiveStreamEvent ev) {
        block10: {
            MediaDeviceSession devSess;
            ReceiveStream receiveStream;
            block11: {
                block9: {
                    if (!(ev instanceof NewReceiveStreamEvent)) break block9;
                    ReceiveStream receiveStream2 = ev.getReceiveStream();
                    if (receiveStream2 == null) break block10;
                    long receiveStreamSSRC = 0xFFFFFFFFL & receiveStream2.getSSRC();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Received new ReceiveStream with ssrc " + receiveStreamSSRC));
                    }
                    this.addRemoteSourceID(receiveStreamSSRC);
                    this.addReceiveStream(receiveStream2);
                    break block10;
                }
                if (!(ev instanceof TimeoutEvent)) break block11;
                ReceiveStream evReceiveStream = ev.getReceiveStream();
                Participant participant = ev.getParticipant();
                ArrayList<ReceiveStream> receiveStreamsToRemove = new ArrayList<ReceiveStream>();
                if (evReceiveStream != null) {
                    receiveStreamsToRemove.add(evReceiveStream);
                } else if (participant != null) {
                    Collection<ReceiveStream> receiveStreams = this.getReceiveStreams();
                    Vector rtpManagerReceiveStreams = this.rtpManager.getReceiveStreams();
                    Iterator iterator = receiveStreams.iterator();
                    while (iterator.hasNext()) {
                        ReceiveStream receiveStream3 = (ReceiveStream)iterator.next();
                        if (!participant.equals(receiveStream3.getParticipant()) || participant.getStreams().contains(receiveStream3) || rtpManagerReceiveStreams.contains(receiveStream3)) continue;
                        receiveStreamsToRemove.add(receiveStream3);
                    }
                }
                for (ReceiveStream receiveStream4 : receiveStreamsToRemove) {
                    this.removeReceiveStream(receiveStream4);
                    DataSource dataSource = receiveStream4.getDataSource();
                    if (dataSource == null) continue;
                    dataSource.disconnect();
                }
                break block10;
            }
            if (!(ev instanceof RemotePayloadChangeEvent) || (receiveStream = ev.getReceiveStream()) == null || (devSess = this.getDeviceSession()) == null) break block10;
            TranscodingDataSource transcodingDS = devSess.getTranscodingDataSource(receiveStream);
            try {
                if (transcodingDS != null) {
                    transcodingDS.disconnect();
                    transcodingDS.connect();
                    transcodingDS.start();
                }
                devSess.playbackDataSourceChanged(receiveStream.getDataSource());
            }
            catch (IOException e) {
                logger.error((Object)"Error re-creating TranscodingDataSource's processor!", (Throwable)e);
            }
        }
    }

    public void update(RemoteEvent ev) {
        if (ev instanceof SenderReportEvent || ev instanceof ReceiverReportEvent) {
            SenderReport report;
            boolean senderReport = false;
            if (ev instanceof SenderReportEvent) {
                ++this.numberOfReceivedSenderReports;
                report = ((SenderReportEvent)ev).getReport();
                senderReport = true;
            } else {
                ++this.numberOfReceivedReceiverReports;
                report = ((ReceiverReportEvent)ev).getReport();
            }
            Feedback feedback = null;
            long remoteJitter = -1L;
            if (report.getFeedbackReports().size() > 0) {
                feedback = (Feedback)report.getFeedbackReports().get(0);
                remoteJitter = feedback.getJitter();
                this.getMediaStreamStats().updateRemoteJitter(remoteJitter);
            }
            if (feedback != null && this.getDirection() != MediaDirection.INACTIVE) {
                Set<PacketLossAwareEncoder> plaes = null;
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession != null) {
                    plaes = deviceSession.getEncoderControls(PacketLossAwareEncoder.class);
                }
                if (plaes != null && !plaes.isEmpty()) {
                    int expectedPacketLoss = feedback.getFractionLost() * 100 / 256;
                    for (PacketLossAwareEncoder plae : plaes) {
                        if (plae == null) continue;
                        plae.setExpectedPacketLoss(expectedPacketLoss);
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                if ((this.numberOfReceivedSenderReports + this.numberOfReceivedReceiverReports) % 4L != 1L) {
                    return;
                }
                StringBuilder buff = new StringBuilder("rtpstat:");
                MediaType mediaType = this.getMediaType();
                String mediaTypeStr = mediaType == null ? "" : mediaType.toString();
                buff.append("Received a ").append(senderReport ? "sender" : "receiver").append(" report for ").append(mediaTypeStr).append(" stream SSRC:").append(this.getLocalSourceID()).append(" [");
                if (senderReport) {
                    buff.append("packet count:").append(report.getSenderPacketCount()).append(", bytes:").append(report.getSenderByteCount());
                }
                if (feedback != null) {
                    buff.append(", interarrival jitter:").append(remoteJitter).append(", lost packets:").append(feedback.getNumLost()).append(", time since previous report:").append((int)((double)feedback.getDLSR() / 65.536)).append("ms");
                }
                buff.append(" ]");
                logger.trace((Object)buff);
            }
        }
    }

    public void update(SendStreamEvent ev) {
        if (ev instanceof NewSendStreamEvent) {
            long localSourceID = ev.getSendStream().getSSRC() & 0xFFFFFFFFL;
            if (this.getLocalSourceID() != localSourceID) {
                this.setLocalSourceID(localSourceID);
            }
        }
    }

    public void update(SessionEvent ev) {
    }

    StatisticsEngine getStatisticsEngine() {
        return this.statisticsEngine;
    }

    @Override
    public void setExternalTransformer(TransformEngine transformEngine) {
        this.externalTransformerWrapper.setWrapped(transformEngine);
    }

    @Override
    public void injectPacket(RawPacket pkt, boolean data, TransformEngine after) throws TransmissionFailedException {
        this.injectPacket(pkt, data, after, false);
    }

    public void injectPacket(RawPacket pkt, boolean data, TransformEngine after, boolean create) throws TransmissionFailedException {
        if (!this.isStarted()) {
            return;
        }
        try {
            TransformEngineWrapper<TransformEngine> wrapper;
            RTPConnectorOutputStream outputStream;
            if (pkt == null || pkt.getBuffer() == null) {
                throw new NullPointerException(pkt == null ? "pkt" : "pkt.getBuffer()");
            }
            AbstractRTPConnector rtpConnector = this.getRTPConnector();
            if (rtpConnector == null) {
                throw new IllegalStateException("rtpConnector");
            }
            RTPConnectorOutputStream rTPConnectorOutputStream = outputStream = data ? rtpConnector.getDataOutputStream(create) : rtpConnector.getControlOutputStream(create);
            if (after != null && (wrapper = this.externalTransformerWrapper) != null && wrapper.contains(after)) {
                after = wrapper;
            }
            outputStream.write(pkt.getBuffer(), pkt.getOffset(), pkt.getLength(), after);
        }
        catch (IOException | IllegalStateException | NullPointerException e) {
            throw new TransmissionFailedException(e);
        }
    }

    public int getTemporalID(RawPacket pkt) {
        RawPacket.HeaderExtension fmhe;
        if (this.frameMarkingsExtensionId != -1 && (fmhe = pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId)) != null) {
            return FrameMarkingHeaderExtension.getTemporalID(fmhe);
        }
        REDBlock redBlock = this.getPrimaryREDBlock(pkt);
        if (redBlock == null || redBlock.getLength() == 0) {
            return -1;
        }
        byte vp8PT = this.getDynamicRTPPayloadType("VP8");
        byte vp9PT = this.getDynamicRTPPayloadType("VP9");
        if (redBlock.getPayloadType() == vp8PT) {
            return DePacketizer.VP8PayloadDescriptor.getTemporalLayerIndex(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        if (redBlock.getPayloadType() == vp9PT) {
            return DePacketizer.VP9PayloadDescriptor.getTemporalLayerIndex(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        return -1;
    }

    public int getSpatialID(RawPacket pkt) {
        REDBlock redBlock;
        if (this.frameMarkingsExtensionId != -1) {
            String encoding = this.getFormat(pkt.getPayloadType()).getEncoding();
            RawPacket.HeaderExtension fmhe = pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId);
            if (fmhe != null) {
                return FrameMarkingHeaderExtension.getSpatialID(fmhe, encoding);
            }
        }
        if ((redBlock = this.getPrimaryREDBlock(pkt)) == null || redBlock.getLength() == 0) {
            return -1;
        }
        byte vp9PT = this.getDynamicRTPPayloadType("VP9");
        if (redBlock.getPayloadType() == vp9PT) {
            return DePacketizer.VP9PayloadDescriptor.getSpatialLayerIndex(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        return -1;
    }

    public boolean supportsFrameBoundaries(RawPacket pkt) {
        if (this.frameMarkingsExtensionId == -1) {
            REDBlock redBlock = this.getPrimaryREDBlock(pkt);
            if (redBlock != null && redBlock.getLength() != 0) {
                byte vp9PT = this.getDynamicRTPPayloadType("VP9");
                byte vp8PT = this.getDynamicRTPPayloadType("VP8");
                byte pt = redBlock.getPayloadType();
                return vp9PT == pt || vp8PT == pt;
            }
            return false;
        }
        return pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId) != null;
    }

    public boolean isStartOfFrame(RawPacket pkt) {
        RawPacket.HeaderExtension fmhe;
        if (!RTPPacketPredicate.INSTANCE.test(pkt)) {
            return false;
        }
        if (this.frameMarkingsExtensionId != -1 && (fmhe = pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId)) != null) {
            return FrameMarkingHeaderExtension.isStartOfFrame(fmhe);
        }
        REDBlock redBlock = this.getPrimaryREDBlock(pkt);
        if (redBlock == null || redBlock.getLength() == 0) {
            return false;
        }
        byte vp8PT = this.getDynamicRTPPayloadType("VP8");
        byte vp9PT = this.getDynamicRTPPayloadType("VP9");
        if (redBlock.getPayloadType() == vp8PT) {
            return DePacketizer.VP8PayloadDescriptor.isStartOfFrame(redBlock.getBuffer(), redBlock.getOffset());
        }
        if (redBlock.getPayloadType() == vp9PT) {
            return DePacketizer.VP9PayloadDescriptor.isStartOfFrame(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        return false;
    }

    public boolean isEndOfFrame(RawPacket pkt) {
        RawPacket.HeaderExtension fmhe;
        if (!RTPPacketPredicate.INSTANCE.test(pkt)) {
            return false;
        }
        if (this.frameMarkingsExtensionId != -1 && (fmhe = pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId)) != null) {
            return FrameMarkingHeaderExtension.isEndOfFrame(fmhe);
        }
        REDBlock redBlock = this.getPrimaryREDBlock(pkt);
        if (redBlock == null || redBlock.getLength() == 0) {
            return false;
        }
        byte vp9PT = this.getDynamicRTPPayloadType("VP9");
        if (redBlock.getPayloadType() == vp9PT) {
            return DePacketizer.VP9PayloadDescriptor.isEndOfFrame(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        return RawPacket.isPacketMarked(pkt);
    }

    public String packetToString(RawPacket pkt) {
        if (pkt == null) {
            return "null";
        }
        if (pkt.getPayloadType() == this.getDynamicRTPPayloadType("VP8")) {
            byte[] buf = pkt.getBuffer();
            int off = pkt.getPayloadOffset();
            int len = pkt.getPayloadLength();
            return pkt + ", " + DePacketizer.VP8PayloadDescriptor.toString(buf, off, len);
        }
        return pkt.toString();
    }

    @Override
    public boolean isKeyFrame(byte[] buf, int off, int len) {
        return this.isKeyFrame(new RawPacket(buf, off, len));
    }

    @Override
    public boolean isKeyFrame(RawPacket pkt) {
        RawPacket.HeaderExtension fmhe;
        if (!RTPPacketPredicate.INSTANCE.test(pkt)) {
            return false;
        }
        if (this.frameMarkingsExtensionId != -1 && (fmhe = pkt.getHeaderExtension((byte)this.frameMarkingsExtensionId)) != null) {
            return FrameMarkingHeaderExtension.isKeyframe(fmhe);
        }
        REDBlock redBlock = this.getPrimaryREDBlock(pkt);
        if (redBlock == null || redBlock.getLength() == 0) {
            return false;
        }
        byte vp8PT = this.getDynamicRTPPayloadType("VP8");
        byte h264PT = this.getDynamicRTPPayloadType("h264");
        if (redBlock.getPayloadType() == vp8PT) {
            return org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer.isKeyFrame(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        if (redBlock.getPayloadType() == h264PT) {
            return DePacketizer.isKeyFrame(redBlock.getBuffer(), redBlock.getOffset(), redBlock.getLength());
        }
        return false;
    }

    public CachingTransformer getCachingTransformer() {
        return this.cachingTransformer;
    }

    @Override
    public RetransmissionRequester getRetransmissionRequester() {
        return this.retransmissionRequester;
    }

    @Override
    public TransformEngineChain getTransformEngineChain() {
        return this.transformEngineChain;
    }

    @Override
    public REDBlock getPrimaryREDBlock(ByteArrayBuffer baf) {
        return this.getPrimaryREDBlock(new RawPacket(baf.getBuffer(), baf.getOffset(), baf.getLength()));
    }

    @Override
    public REDBlock getPrimaryREDBlock(RawPacket pkt) {
        byte pktPT;
        if (pkt == null || pkt.getLength() < 12) {
            return null;
        }
        byte redPT = this.getDynamicRTPPayloadType("red");
        if (redPT == (pktPT = pkt.getPayloadType())) {
            return REDBlockIterator.getPrimaryBlock(pkt.getBuffer(), pkt.getPayloadOffset(), pkt.getPayloadLength());
        }
        return new REDBlock(pkt.getBuffer(), pkt.getPayloadOffset(), pkt.getPayloadLength(), pktPT);
    }

    public RtxTransformer getRtxTransformer() {
        return null;
    }

    protected DiscardTransformEngine createDiscardEngine() {
        return null;
    }

    protected TransformEngine getRTCPTermination() {
        return null;
    }

    protected PaddingTermination getPaddingTermination() {
        return null;
    }

    public RemoteBitrateEstimatorWrapper getRemoteBitrateEstimator() {
        return null;
    }

    private void onDynamicPayloadTypesChanged() {
        RtxTransformer rtxTransformer = this.getRtxTransformer();
        if (rtxTransformer != null) {
            rtxTransformer.onDynamicPayloadTypesChanged();
        }
    }

    @Override
    public void setTransportCCEngine(TransportCCEngine engine) {
        if (this.transportCCEngine != null) {
            this.transportCCEngine.removeMediaStream(this);
        }
        this.transportCCEngine = engine;
        if (this.transportCCEngine != null) {
            this.transportCCEngine.addMediaStream(this);
        }
    }

    @Override
    public void setRTPTranslator(RTPTranslator rtpTranslator) {
        super.setRTPTranslator(rtpTranslator);
        if (this.deviceSession != null) {
            this.deviceSession.setUseTranslator(rtpTranslator != null);
        }
    }
}

