/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Highlighter;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.utils.HighlightUtils;

public class TagList {
    public static final String FULL_PROPERTY = "FULL_PROPERTY";
    public static final String NUM_ERRORS_PROPERTY = "NUM_ERRORS_PROPERTY";
    public static final String FIRST_ERROR_PROPERTY = "FIRST_ERROR_PROPERTY";
    public static final String LAST_ERROR_PROPERTY = "LAST_ERROR_PROPERTY";
    public static final String CURRENT_ERROR_PROPERTY = "CURRENT_ERROR_PROPERTY";
    public static final String PREVIOUS_ERROR_PROPERTY = "PREVIOUS_ERROR_PROPERTY";
    public static final String NEXT_ERROR_PROPERTY = "NEXT_ERROR_PROPERTY";
    private PropertyChangeSupport propertyChangeSupport;
    private TagNode first;
    private TagNode last;
    private TagNode current;
    private int caretPosition = -1;
    private int nErrors;
    private static int maxNumOfErrors = 2500;
    private StateChecker stateChecker = new StateChecker();

    public TagList(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
        this.clear();
    }

    public boolean isEmpty() {
        return null == this.first;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.current = null;
        this.nErrors = 0;
    }

    private TagNode findTagNode(Highlighter.Highlight tag) {
        TagNode node = this.findNearTagNode((tag.getStartOffset() + tag.getEndOffset()) / 2);
        Highlighter.Highlight curTag = node.getTag();
        if (tag == curTag) {
            return node;
        }
        return null;
    }

    public void add(Object tag, ErrorInfo info) {
        this.stateChecker.init();
        this.add((Highlighter.Highlight)tag, info);
        this.stateChecker.check();
    }

    private void addFirstAndLastTagNode(Highlighter.Highlight tag, ErrorInfo info) {
        this.last = this.first = new TagNode(tag, info);
        this.current = this.first;
    }

    private void addMiddleTagNode(Highlighter.Highlight tag, ErrorInfo info, TagNode node) {
        this.current = new TagNode(tag, node, node.getNext(), info);
        node.getNext().setPrevious(this.current);
        node.setNext(this.current);
    }

    private void addFirstTagNode(Highlighter.Highlight tag, ErrorInfo info) {
        this.current = new TagNode(tag, this.first, info);
        this.first.setPrevious(this.current);
        this.first = this.current;
    }

    private void addLastTagNode(Highlighter.Highlight tag, ErrorInfo info) {
        this.current = new TagNode(tag, this.last, null, info);
        this.last.setNext(this.current);
        this.last = this.current;
    }

    private void add(Highlighter.Highlight tag, ErrorInfo info) {
        if (!this.isEmpty()) {
            TagNode node = this.findPreviousNode((tag.getStartOffset() + tag.getEndOffset()) / 2);
            if (null == node) {
                this.addFirstTagNode(tag, info);
            } else if (this.last == node) {
                this.addLastTagNode(tag, info);
            } else {
                this.addMiddleTagNode(tag, info, node);
            }
        } else {
            this.addFirstAndLastTagNode(tag, info);
        }
        ++this.nErrors;
    }

    public void remove(Object tag) {
        this.remove((Highlighter.Highlight)tag);
    }

    private void removeFirstTagNode(TagNode node) {
        this.first = node.getNext();
        this.first.setPrevious(null);
        this.current = this.first;
    }

    private void removeFisrtAndLastTagNode() {
        this.first = null;
        this.last = null;
        this.current = null;
    }

    private void removeLastTagNode(TagNode node) {
        this.last = node.getPrevious();
        this.last.setNext(null);
        this.current = this.last;
    }

    private void removeTagNode(TagNode node) {
        TagNode prev = node.getPrevious();
        prev.setNext(node.getNext());
        node.getNext().setPrevious(prev);
        this.current = prev;
    }

    private void remove(Highlighter.Highlight tag) {
        if (!this.isEmpty()) {
            TagNode node = this.findTagNode(tag);
            if (null != node) {
                if (this.first == node) {
                    if (this.last != node) {
                        this.removeFirstTagNode(node);
                    } else {
                        this.removeFisrtAndLastTagNode();
                    }
                } else if (this.last == node) {
                    this.removeLastTagNode(node);
                } else {
                    this.removeTagNode(node);
                }
            }
            --this.nErrors;
        }
    }

    private boolean isInside(int beginPos, int endPos) {
        if (this.isEmpty()) {
            return false;
        }
        return this.first.getTag().getStartOffset() <= endPos && this.last.getTag().getEndOffset() >= beginPos;
    }

    public void removeAll(Highlighter highlighter) {
        while (null != this.first) {
            highlighter.removeHighlight(this.first.getTag());
            this.first = this.first.getNext();
        }
        this.last = null;
        this.current = null;
        this.nErrors = 0;
    }

    private TagNode removeNullRange(TagNode begin, Highlighter highlighter) {
        while (null != begin && HighlightUtils.isNullRange(begin.getTag())) {
            highlighter.removeHighlight(begin.getTag());
            begin = begin.getNext();
            --this.nErrors;
        }
        return begin;
    }

    private TagNode removeRangeTo(TagNode begin, Highlighter highlighter, int endPos) {
        while (null != begin && !HighlightUtils.isMajor(begin.getTag(), endPos)) {
            highlighter.removeHighlight(begin.getTag());
            begin = begin.getNext();
            --this.nErrors;
        }
        return begin;
    }

    public void removeRange(int beginPos, int endPos, Highlighter highlighter) {
        if (this.isInside(beginPos, endPos)) {
            this.stateChecker.init();
            if (HighlightUtils.isMajorOrEquals(this.first.getTag(), beginPos) && HighlightUtils.isMinorOrEquals(this.last.getTag(), endPos)) {
                this.removeAll(highlighter);
            } else {
                TagNode next;
                TagNode prev = this.findPreviousNode(beginPos);
                if (null == prev) {
                    if (HighlightUtils.isInside(this.first.getTag(), beginPos - 1)) {
                        next = this.removeRangeTo(this.first.getNext(), highlighter, endPos);
                        prev = this.first;
                    } else {
                        this.first = next = this.removeRangeTo(this.first, highlighter, endPos);
                        this.first.setPrevious(null);
                        prev = next;
                        next = prev.getNext();
                    }
                } else {
                    next = this.removeRangeTo(prev.getNext(), highlighter, endPos);
                }
                if (null != next) {
                    prev.setNext(next);
                    next.setPrevious(prev);
                } else {
                    this.last = prev;
                    prev.setNext(null);
                }
                this.current = prev;
            }
            this.stateChecker.check();
        }
    }

    public void removeNullRanges(int beginPos, int endPos, Highlighter highlighter) {
        if (this.isInside(beginPos, endPos)) {
            this.stateChecker.init();
            if (HighlightUtils.isMajorOrEquals(this.first.getTag(), beginPos) && HighlightUtils.isMinorOrEquals(this.last.getTag(), endPos)) {
                this.removeAll(highlighter);
            } else {
                TagNode next;
                TagNode prev = this.findPreviousNode(beginPos);
                if (null == prev) {
                    if (HighlightUtils.isInside(this.first.getTag(), beginPos - 1)) {
                        next = this.removeNullRange(this.first.getNext(), highlighter);
                        prev = this.first;
                    } else {
                        this.first = next = this.removeNullRange(this.first, highlighter);
                        this.first.setPrevious(null);
                        prev = next;
                        next = prev.getNext();
                    }
                } else {
                    next = this.removeNullRange(prev.getNext(), highlighter);
                }
                if (null != next) {
                    prev.setNext(next);
                    next.setPrevious(prev);
                } else {
                    this.last = prev;
                    prev.setNext(null);
                }
                this.current = prev;
            }
            this.stateChecker.check();
        }
    }

    public void updateCurrent(int curPos) {
        this.stateChecker.init();
        this.current = this.findNearTagNode(curPos);
        this.caretPosition = curPos;
        this.stateChecker.check();
    }

    private TagNode findFirstLastOrCurrentNearNode(int curPos) {
        TagNode result = this.current;
        int delta = HighlightUtils.getDeltaFromStart(result.getTag(), curPos);
        if (delta > 0) {
            if (HighlightUtils.getDeltaFromEnd(curPos, this.first.getTag()) < delta) {
                result = this.first;
            }
        } else {
            delta = HighlightUtils.getDeltaFromEnd(curPos, result.getTag());
            if (HighlightUtils.getDeltaFromStart(this.last.getTag(), curPos) < delta) {
                result = this.last;
            }
        }
        return result;
    }

    private TagNode findNearTagNode(int curPos) {
        TagNode result = this.current;
        if (!this.isEmpty()) {
            if (HighlightUtils.isMajor(this.first.getTag(), curPos)) {
                result = this.first;
            } else if (HighlightUtils.isMinor(this.last.getTag(), curPos)) {
                result = this.last;
            } else {
                for (result = this.findFirstLastOrCurrentNearNode(curPos); null != result && HighlightUtils.isMinor(result.getTag(), curPos); result = result.getNext()) {
                }
                while (null != result && HighlightUtils.isMajor(result.getTag(), curPos)) {
                    result = result.getPrevious();
                }
                if (null == result) {
                    result = this.first;
                }
            }
        }
        return result;
    }

    private TagNode findPreviousNode(int index) {
        TagNode result = this.findFirstLastOrCurrentNearNode(index);
        if (HighlightUtils.isMajorOrEquals(result.getTag(), index)) {
            while (null != result && HighlightUtils.isMajorOrEquals(result.getTag(), index)) {
                result = result.getPrevious();
            }
        } else {
            TagNode prev = result;
            while (null != result && HighlightUtils.isMinor(result.getTag(), index)) {
                prev = result;
                result = result.getNext();
            }
            result = prev;
        }
        while (null != result && HighlightUtils.isNullRange(result.getTag())) {
            result = result.getPrevious();
        }
        return result;
    }

    public boolean hasTagAt(int curPos) {
        boolean result = false;
        if (!this.isEmpty()) {
            this.current = this.findNearTagNode(curPos);
            result = HighlightUtils.isUpOpenInside(this.current.getTag(), curPos);
        }
        return result;
    }

    public ErrorInfo getErrorInfoAt(int curPos) {
        ErrorInfo result = null;
        if (this.hasTagAt(curPos)) {
            result = this.current.getErrorInfo();
        }
        return result;
    }

    public List<ErrorInfo> getAllErrorInfo() {
        LinkedList<ErrorInfo> result = new LinkedList<ErrorInfo>();
        for (TagNode node = this.first; null != node; node = node.getNext()) {
            result.add(node.getErrorInfo());
        }
        return result;
    }

    public static int getMaxNumOfErrors() {
        return maxNumOfErrors;
    }

    public static void setMaxNumOfErrors(int aMaxNumOfErrors) {
        maxNumOfErrors = aMaxNumOfErrors;
    }

    public boolean isFull() {
        return this.getNumOfErrors() >= TagList.getMaxNumOfErrors();
    }

    public int getNumOfErrors() {
        return this.nErrors;
    }

    private ErrorInfo getErrorInfo(TagNode node) {
        if (node != null) {
            return node.getErrorInfo();
        }
        return null;
    }

    public ErrorInfo getFirstError() {
        return this.getErrorInfo(this.first);
    }

    public ErrorInfo getLastError() {
        return this.getErrorInfo(this.last);
    }

    public ErrorInfo getCurrentError() {
        return this.getErrorInfoAt(this.caretPosition);
    }

    public ErrorInfo getPreviousError() {
        TagNode node = null;
        if (this.caretPosition >= 0 && !this.isEmpty() && !HighlightUtils.isMinorOrEquals((node = this.findNearTagNode(this.caretPosition)).getTag(), this.caretPosition)) {
            node = node.getPrevious();
        }
        return this.getErrorInfo(node);
    }

    public ErrorInfo getNextError() {
        TagNode node = null;
        if (this.caretPosition >= 0 && !this.isEmpty() && !HighlightUtils.isMajor((node = this.findNearTagNode(this.caretPosition)).getTag(), this.caretPosition)) {
            node = node.getNext();
        }
        return this.getErrorInfo(node);
    }

    public String toString() {
        String result = String.format("N nodes %d ", this.nErrors);
        for (TagNode aux = this.first; aux != null; aux = aux.getNext()) {
            result = result + aux + "\n";
        }
        result = result + " Current = " + this.current;
        return result;
    }

    private static class TagNode {
        private TagNode next;
        private TagNode prev;
        private Highlighter.Highlight tag;
        private ErrorInfo errorInfo;

        public TagNode(Highlighter.Highlight tag, ErrorInfo info) {
            this(tag, null, null, info);
        }

        public TagNode(Highlighter.Highlight tag, TagNode next, ErrorInfo info) {
            this(tag, null, next, info);
        }

        public TagNode(Highlighter.Highlight tag, TagNode previous, TagNode next, ErrorInfo info) {
            this.tag = tag;
            this.setNext(next);
            this.setPrevious(previous);
            this.errorInfo = info;
        }

        public TagNode getNext() {
            return this.next;
        }

        public void setNext(TagNode node) {
            this.next = node;
        }

        public TagNode getPrevious() {
            return this.prev;
        }

        public void setPrevious(TagNode node) {
            this.prev = node;
        }

        public Highlighter.Highlight getTag() {
            return this.tag;
        }

        public ErrorInfo getErrorInfo() {
            this.errorInfo.getBadWord().moveTo(this.tag.getStartOffset());
            return this.errorInfo;
        }

        public String toString() {
            return "(" + this.tag.getStartOffset() + "," + this.tag.getEndOffset() + ")";
        }
    }

    private class StateChecker {
        private int nErrors;
        private ErrorInfo firstError;
        private ErrorInfo lastError;
        private ErrorInfo caretError;
        private ErrorInfo previousError;
        private ErrorInfo nextError;
        private boolean full;

        private StateChecker() {
        }

        public void init() {
            this.nErrors = TagList.this.nErrors;
            this.firstError = TagList.this.getFirstError();
            this.lastError = TagList.this.getLastError();
            this.caretError = TagList.this.getCurrentError();
            this.previousError = TagList.this.getPreviousError();
            this.nextError = TagList.this.getNextError();
            this.full = TagList.this.isFull();
        }

        public void check() {
            if (TagList.this.nErrors < 0) {
                throw new IllegalStateException("Number of nodes < 0");
            }
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.NUM_ERRORS_PROPERTY, this.nErrors, TagList.this.nErrors);
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.FULL_PROPERTY, this.full, TagList.this.isFull());
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.FIRST_ERROR_PROPERTY, this.firstError, TagList.this.getFirstError());
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.LAST_ERROR_PROPERTY, this.lastError, TagList.this.getLastError());
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.CURRENT_ERROR_PROPERTY, this.caretError, TagList.this.getCurrentError());
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.PREVIOUS_ERROR_PROPERTY, this.previousError, TagList.this.getPreviousError());
            TagList.this.propertyChangeSupport.firePropertyChange(TagList.NEXT_ERROR_PROPERTY, this.nextError, TagList.this.getNextError());
        }
    }
}

