/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class CancelableDialog
extends JDialog
implements KeyEventPostProcessor {
    private boolean escWasPressed = false;

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager mng = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        mng.addKeyEventPostProcessor(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager mng = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        mng.removeKeyEventPostProcessor(this);
    }

    protected boolean hasPressedExitKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 27 && keyEvent.getID() == 401 && SwingUtilities.getWindowAncestor(keyEvent.getComponent()) == this;
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (this.hasPressedExitKey(keyEvent)) {
            this.escWasPressed = true;
            this.close();
            return true;
        }
        return false;
    }

    private static Frame getCurrentFrame() {
        Frame[] frames = Frame.getFrames();
        if (null == frames || frames.length == 0) {
            return null;
        }
        return frames[frames.length - 1];
    }

    public CancelableDialog() throws HeadlessException {
        this(CancelableDialog.getCurrentFrame());
    }

    public CancelableDialog(Frame owner) throws HeadlessException {
        this(owner, "");
    }

    public CancelableDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title, true);
    }

    public CancelableDialog(Dialog owner) throws HeadlessException {
        this(owner, "");
    }

    public CancelableDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title, true);
    }

    public CancelableDialog(Window owner) throws HeadlessException {
        this(owner, "");
    }

    public CancelableDialog(Window owner, String title) throws HeadlessException {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public boolean isEscWasPressed() {
        return this.escWasPressed;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public Action getCloseAction() {
        return new AbstractAction("Cerrar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelableDialog.this.close();
            }
        };
    }
}

