/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.ServiceLoader;
import javax.swing.JPanel;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.panels.LoadDictionaryPanel;
import org.dts.spell.swing.panels.NoDictionaryInstalledPanel;
import org.dts.spell.swing.panels.NoErrorSolutionPanel;
import org.dts.spell.swing.panels.SearchSolutionPanel;
import org.dts.spell.swing.panels.SolutionPanel;

public class SolutionContainerPanel
extends JPanel {
    private SolutionPanel noErrorPanel;
    private SolutionPanel searchSolutionPanel;
    private SolutionPanel loadDictionaryPanel;
    private SolutionPanel noDictionaryPanel;
    private SolutionPanel currentPanel;

    public SolutionContainerPanel(JTextComponentSpellChecker txtCmpSpellChecker) {
        this.initPanels(txtCmpSpellChecker);
    }

    protected void initPanels(JTextComponentSpellChecker txtCmpSpellChecker) {
        CardLayout cardLayout = new CardLayout(5, 5);
        this.setLayout(cardLayout);
        this.addInternalSolutionPanel(this.getNoErrorPanel(), txtCmpSpellChecker);
        this.addInternalSolutionPanel(this.getSearchErrorPanel(), txtCmpSpellChecker);
        this.addInternalSolutionPanel(this.getLoadDictionaryPanel(), txtCmpSpellChecker);
        this.addInternalSolutionPanel(this.getNoDictionaryPanel(), txtCmpSpellChecker);
        ServiceLoader<SolutionPanel> loader = ServiceLoader.load(SolutionPanel.class);
        for (SolutionPanel panel : loader) {
            this.addInternalSolutionPanel(panel, txtCmpSpellChecker);
        }
        this.currentPanel = this.getNoErrorPanel();
    }

    protected void addInternalSolutionPanel(SolutionPanel panel, JTextComponentSpellChecker txtCmpSpellChecker) {
        panel.initFrom(txtCmpSpellChecker);
        this.addSolutionPanel(panel);
    }

    protected void addSolutionPanel(SolutionPanel panel) {
        this.add((Component)panel, panel.getName());
    }

    protected CardLayout getCardLayout() {
        return (CardLayout)this.getLayout();
    }

    public SolutionPanel getSearchErrorPanel() {
        if (null == this.searchSolutionPanel) {
            this.searchSolutionPanel = new SearchSolutionPanel();
        }
        return this.searchSolutionPanel;
    }

    public SolutionPanel getNoErrorPanel() {
        if (null == this.noErrorPanel) {
            this.noErrorPanel = new NoErrorSolutionPanel();
        }
        return this.noErrorPanel;
    }

    public ProgressListener getLoadDictionaryPanelAsListener() {
        return (ProgressListener)this.getLoadDictionaryPanel();
    }

    public SolutionPanel getLoadDictionaryPanel() {
        if (null == this.loadDictionaryPanel) {
            this.loadDictionaryPanel = new LoadDictionaryPanel();
        }
        return this.loadDictionaryPanel;
    }

    public SolutionPanel getNoDictionaryPanel() {
        if (null == this.noDictionaryPanel) {
            this.noDictionaryPanel = new NoDictionaryInstalledPanel();
        }
        return this.noDictionaryPanel;
    }

    public void showSolutionPanel(SolutionPanel panel) {
        this.getCardLayout().show(this, panel.getName());
        this.currentPanel = panel;
    }

    protected SolutionPanel getPanelByName(String name) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!name.equals(this.getComponent(i).getName())) continue;
            return (SolutionPanel)this.getComponent(i);
        }
        return null;
    }

    public SolutionPanel getSolutionPanelFor(ErrorInfo errorInfo) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            SolutionPanel panel;
            if (!(this.getComponent(i) instanceof SolutionPanel) || !(panel = (SolutionPanel)this.getComponent(i)).isForError(errorInfo)) continue;
            return panel;
        }
        return this.getNoErrorPanel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (null != this.currentPanel) {
            this.currentPanel.setEnabled(enabled);
        }
    }
}

