/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.panels.SolutionPanel;

public class LoadDictionaryPanel
extends SolutionPanel
implements ProgressListener {
    private JLabel label;
    private JProgressBar progressBar;
    private String description = "Se est\u00e1 cargando el diccionario, por favor espere mientras se carga.";

    public LoadDictionaryPanel() {
        super("LOAD_DICTIONARY_PANEL");
    }

    @Override
    public void initFrom(JTextComponentSpellChecker txtCmpSpellChecker) {
        super.initFrom(txtCmpSpellChecker);
        this.label = this.createNoWidthLabel(this.getDescription());
        this.progressBar = new JProgressBar();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.label);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.progressBar);
    }

    @Override
    public String getTitle() {
        return "<html>El diccionario no est\u00e1 cargado.</html>";
    }

    @Override
    public void calcSolution(ErrorInfo errorInfo) {
    }

    @Override
    public void activePanel(ErrorInfo errorInfo) {
    }

    @Override
    public boolean isForError(ErrorInfo errorInfo) {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void setProgressData(ProgressEvent evt) {
        String txt = String.format("<html>%s<br><br>%s<br><br></html>", this.getDescription(), evt.getProgress());
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(evt.getTotal());
        this.progressBar.setValue(evt.getStep());
        this.label.setText(txt);
        this.repaint();
    }

    protected void setError(ProgressEvent evt) {
        String txt = String.format("<html>%s</html>", evt.getError().getLocalizedMessage());
        this.progressBar.setVisible(false);
        this.label.setText(txt);
        this.repaint();
    }

    public void beginProgress(ProgressEvent evt) {
        this.setProgressData(evt);
    }

    public void nextStep(ProgressEvent evt) {
        this.setProgressData(evt);
    }

    public void endProgress(ProgressEvent evt) {
        if (!evt.hasError()) {
            this.setProgressData(evt);
        } else {
            this.setError(evt);
        }
    }
}

