/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.Expression;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.Statement;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.dictionary.DictionaryManager;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.actions.AbstractSpellCheckerAction;
import org.dts.spell.swing.event.TextComponentSpellCheckerAdapter;
import org.dts.spell.swing.event.TextComponentSpellCheckerEvent;
import org.dts.spell.swing.event.TextComponentSpellCheckerListener;
import org.dts.spell.swing.panels.SolutionContainerPanel;
import org.dts.spell.swing.panels.SolutionPanel;
import org.dts.spell.swing.utils.Messages;
import org.dts.spell.swing.utils.SeparatorLineBorder;

public class JRealTimeSpellPanel
extends JPanel {
    private JTextComponentSpellChecker textComponentSpellChecker;
    private ErrorMarker activeErrorMarker;
    private FindFocusAction focusFinderAction;
    private PropertyChangeListener currentErrorInfoListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JRealTimeSpellPanel.this.updateErrorInfo((ErrorMarker)evt.getSource(), (ErrorInfo)evt.getNewValue());
        }
    };
    private PropertyChangeListener firstLastErrorInfoListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ErrorMarker errorMarker = (ErrorMarker)evt.getSource();
            if (evt.getPropertyName().equals("NEXT_ERROR_PROPERTY")) {
                JRealTimeSpellPanel.this.goNextAction.update(errorMarker, (ErrorInfo)evt.getNewValue());
            } else {
                JRealTimeSpellPanel.this.goPreviousAction.update(errorMarker, (ErrorInfo)evt.getNewValue());
            }
            JRealTimeSpellPanel.this.goLastAction.update(errorMarker, errorMarker.getLastError());
            JRealTimeSpellPanel.this.goFirstAction.update(errorMarker, errorMarker.getFirstError());
        }
    };
    private PropertyChangeListener destroyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!JRealTimeSpellPanel.this.isDisplayable()) {
                JRealTimeSpellPanel.this.onDestroy();
            }
        }
    };
    private TextComponentSpellCheckerListener cmpChangeListener = new TextComponentSpellCheckerAdapter(){

        @Override
        public void realTimeStart(TextComponentSpellCheckerEvent evt) {
            JRealTimeSpellPanel.this.realTimeStart(evt);
        }

        @Override
        public void realTimeWillStop(TextComponentSpellCheckerEvent evt) {
            JRealTimeSpellPanel.this.realTimeWillStop(evt);
        }
    };
    private ProgressListener loadDictionary = new ProgressListener(){

        private void callInSwingTrhead(Runnable run) {
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(run);
                } else {
                    run.run();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void beginProgress(final ProgressEvent evt) {
            this.callInSwingTrhead(new Runnable(){

                @Override
                public void run() {
                    JRealTimeSpellPanel.this.solutionPanel.getLoadDictionaryPanelAsListener().beginProgress(evt);
                }
            });
        }

        public void nextStep(final ProgressEvent evt) {
            this.callInSwingTrhead(new Runnable(){

                @Override
                public void run() {
                    JRealTimeSpellPanel.this.solutionPanel.getLoadDictionaryPanelAsListener().nextStep(evt);
                }
            });
        }

        public void endProgress(final ProgressEvent evt) {
            this.callInSwingTrhead(new Runnable(){

                @Override
                public void run() {
                    JRealTimeSpellPanel.this.solutionPanel.getLoadDictionaryPanelAsListener().endProgress(evt);
                }
            });
            if (!evt.hasError()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JRealTimeSpellPanel.this.resetErrorMarker();
                    }
                });
            }
        }
    };
    private GoAction goFirstAction;
    private GoAction goPreviousAction;
    private GoAction goNextAction;
    private GoAction goLastAction;
    private JLabel errorInfoLabel;
    private SolutionContainerPanel solutionPanel;
    private final ThreadPoolExecutor calcExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());

    public JRealTimeSpellPanel(JTextComponentSpellChecker textComponentSpellChecker) {
        this(textComponentSpellChecker, true);
    }

    public JRealTimeSpellPanel(JTextComponentSpellChecker textComponentSpellChecker, boolean auto) {
        this.textComponentSpellChecker = textComponentSpellChecker;
        this.setAutomatic(auto);
        this.init();
        this.onShowPanel();
        this.addPropertyChangeListener("ancestor", this.destroyListener);
    }

    public void setAutomatic(boolean value) {
        if (this.isAutomatic() != value) {
            if (value) {
                this.focusFinderAction = new FindFocusAction();
            } else {
                this.focusFinderAction.release();
                this.focusFinderAction = null;
            }
        }
    }

    public boolean isAutomatic() {
        return null != this.focusFinderAction;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (this.isVisible() != aFlag) {
            super.setVisible(aFlag);
            if (aFlag) {
                this.onShowPanel();
            } else {
                this.onHidePanel();
            }
        }
    }

    protected void onDestroy() {
        this.onHidePanel();
        this.setAutomatic(false);
        this.calcExecutor.shutdown();
    }

    protected void onHidePanel() {
        this.textComponentSpellChecker.removeListener(this.cmpChangeListener);
        DictionaryManager.get().removeProgressListener(this.loadDictionary);
        this.setErrorMarker(null);
    }

    protected void onShowPanel() {
        JTextComponent txtCmp;
        this.textComponentSpellChecker.addListener(this.cmpChangeListener);
        DictionaryManager.get().addProgressListener(this.loadDictionary);
        ErrorMarker errorMarker = null;
        if (null != this.focusFinderAction && null != (txtCmp = this.focusFinderAction.getTextComponent())) {
            errorMarker = this.textComponentSpellChecker.getErrorMarker(txtCmp);
        }
        this.setErrorMarker(errorMarker);
    }

    protected void realTimeStart(TextComponentSpellCheckerEvent evt) {
        if (null != this.focusFinderAction) {
            JTextComponent txtCmp = evt.getTextComponent();
            if (this.focusFinderAction.getTextComponent() == txtCmp) {
                this.setErrorMarker(evt.getTextComponentSpellChecker().getErrorMarker(txtCmp));
            }
        }
    }

    public void realTimeWillStop(TextComponentSpellCheckerEvent evt) {
        if (this.getCurrentTextComponent() == evt.getTextComponent()) {
            this.setErrorMarker(null);
        }
    }

    protected void onFocusedTextComponentChanged(JTextComponent textCmp) {
        if (null != textCmp) {
            this.setErrorMarker(this.textComponentSpellChecker.getErrorMarker(textCmp));
        } else {
            this.setErrorMarker(null);
        }
    }

    protected void quitErrorMarker(ErrorMarker errorMarker) {
        if (null != errorMarker) {
            errorMarker.removePropertyChangeListener("FIRST_ERROR_PROPERTY", this.goFirstAction);
            errorMarker.removePropertyChangeListener("LAST_ERROR_PROPERTY", this.goLastAction);
            errorMarker.removePropertyChangeListener("NEXT_ERROR_PROPERTY", this.firstLastErrorInfoListener);
            errorMarker.removePropertyChangeListener("PREVIOUS_ERROR_PROPERTY", this.firstLastErrorInfoListener);
            errorMarker.removePropertyChangeListener("CURRENT_ERROR_PROPERTY", this.currentErrorInfoListener);
        }
    }

    protected void putErrorMarker(ErrorMarker errorMarker) {
        if (null != errorMarker) {
            errorMarker.addPropertyChangeListener("FIRST_ERROR_PROPERTY", this.goFirstAction);
            errorMarker.addPropertyChangeListener("LAST_ERROR_PROPERTY", this.goLastAction);
            errorMarker.addPropertyChangeListener("NEXT_ERROR_PROPERTY", this.firstLastErrorInfoListener);
            errorMarker.addPropertyChangeListener("PREVIOUS_ERROR_PROPERTY", this.firstLastErrorInfoListener);
            errorMarker.addPropertyChangeListener("CURRENT_ERROR_PROPERTY", this.currentErrorInfoListener);
        }
    }

    public void setErrorMarker(ErrorMarker errorMarker) {
        this.setErrorMarker(errorMarker, false);
    }

    public void resetErrorMarker() {
        this.setErrorMarker(this.activeErrorMarker, true);
    }

    protected void setErrorMarker(ErrorMarker errorMarker, boolean force) {
        if (this.activeErrorMarker != errorMarker || force) {
            this.quitErrorMarker(this.activeErrorMarker);
            this.activeErrorMarker = errorMarker;
            this.putErrorMarker(this.activeErrorMarker);
            this.updateActionsState(errorMarker);
            this.updateErrorInfo(errorMarker);
        }
    }

    public void updateFirstAction(Action action, ErrorMarker errorMarker, ErrorInfo firstErrorInfo) {
        action.setEnabled(null != firstErrorInfo && errorMarker.getCurrentError() != firstErrorInfo);
    }

    public void updateLastAction(Action action, ErrorMarker errorMarker, ErrorInfo lastErrorInfo) {
        action.setEnabled(null != lastErrorInfo && errorMarker.getCurrentError() != lastErrorInfo);
    }

    public void updateNextAction(Action action, ErrorMarker errorMarker, ErrorInfo nextErrorInfo) {
        action.setEnabled(null != nextErrorInfo);
    }

    public void updatePreviousAction(Action action, ErrorMarker errorMarker, ErrorInfo previousErrorInfo) {
        action.setEnabled(null != previousErrorInfo);
    }

    public void updateActionsState(ErrorMarker errorMarker) {
        this.goFirstAction.update(errorMarker);
        this.goLastAction.update(errorMarker);
        this.goNextAction.update(errorMarker);
        this.goPreviousAction.update(errorMarker);
    }

    protected void init() {
        this.createPanels();
        this.updateActionsState(this.activeErrorMarker);
        this.updateErrorInfo(this.activeErrorMarker);
    }

    protected Action createAction(String name, String methodName) {
        final ActionListener listener = EventHandler.create(ActionListener.class, this, methodName);
        AbstractAction result = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        };
        return result;
    }

    protected void createPanels() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints cnt = new GridBagConstraints();
        cnt.anchor = 11;
        cnt.fill = 2;
        cnt.weightx = 1.0;
        cnt.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.createNavigationPanel(), cnt);
        cnt.gridy = 1;
        cnt.anchor = 10;
        cnt.fill = 2;
        this.add((Component)this.createErrorInfoPanel(), cnt);
        cnt.gridy = 2;
        cnt.anchor = 10;
        cnt.fill = 1;
        cnt.weighty = 1.0;
        this.add((Component)this.createErrorSolutionPanel(), cnt);
    }

    protected void updateErrorInfo(ErrorMarker errorMarker) {
        if (null != errorMarker) {
            this.updateErrorInfo(errorMarker, errorMarker.getCurrentError());
        } else {
            this.updateErrorInfo(errorMarker, null);
        }
    }

    protected void dalayCalc(long startTimestamp) {
        try {
            long currentTimestamp = System.currentTimeMillis();
            long delay = 1000L - (currentTimestamp - startTimestamp);
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void calcSolution(final SolutionPanel panel, final ErrorInfo errorInfo) {
        this.calcExecutor.execute(new Runnable(){

            @Override
            public void run() {
                long startTimestamp = System.currentTimeMillis();
                panel.doCalcSolution(errorInfo);
                JRealTimeSpellPanel.this.dalayCalc(startTimestamp);
                SwingUtilities.invokeLater(new SolutionUpdater(panel));
            }
        });
    }

    protected void updateErrorInfo(ErrorMarker errorMarker, ErrorInfo errorInfo) {
        SolutionPanel activePanel;
        SpellDictionary dict = this.textComponentSpellChecker.getSpellChecker().getDictionary();
        if (null == dict) {
            activePanel = this.solutionPanel.getNoDictionaryPanel();
        } else if (!dict.isLoad()) {
            activePanel = this.solutionPanel.getLoadDictionaryPanel();
        } else if (null != errorInfo) {
            activePanel = this.solutionPanel.getSearchErrorPanel();
            this.calcSolution(this.solutionPanel.getSolutionPanelFor(errorInfo), errorInfo);
        } else {
            activePanel = this.solutionPanel.getNoErrorPanel();
        }
        this.solutionPanel.showSolutionPanel(activePanel);
        this.setErrorInfoText(activePanel.getTitle());
        this.errorInfoLabel.setEnabled(null != errorMarker);
        this.solutionPanel.setEnabled(null != errorMarker);
    }

    public void setErrorInfoText(String txt) {
        this.errorInfoLabel.setText(txt);
    }

    protected JLabel createErrorInfoLabel() {
        JLabel label = new JLabel("X");
        label.setPreferredSize(new Dimension(0, label.getPreferredSize().height));
        return label;
    }

    protected JPanel createErrorInfoPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.errorInfoLabel = this.createErrorInfoLabel();
        result.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), Messages.getString("JRealTimeSpellPanel.ERROR_TITLE_STRING")));
        result.add((Component)this.errorInfoLabel, "Center");
        return result;
    }

    public JTextComponent getCurrentTextComponent() {
        if (null != this.activeErrorMarker) {
            return this.activeErrorMarker.getTextComponent();
        }
        return null;
    }

    public void gotoError(ErrorInfo info) {
        Word word = info.getBadWord();
        JTextComponent textComponent = this.getCurrentTextComponent();
        textComponent.setCaretPosition(word.getEnd());
        textComponent.moveCaretPosition(word.getStart());
        textComponent.requestFocusInWindow();
    }

    public void gotoFirstError(ErrorMarker errorMaker, ErrorInfo errorInfo) {
        this.gotoError(errorInfo);
    }

    public void gotoPreviousError(ErrorMarker errorMaker, ErrorInfo errorInfo) {
        this.gotoError(errorInfo);
    }

    public void gotoNextError(ErrorMarker errorMaker, ErrorInfo errorInfo) {
        this.gotoError(errorInfo);
    }

    public void gotoLastError(ErrorMarker errorMaker, ErrorInfo errorInfo) {
        this.gotoError(errorInfo);
    }

    protected GoAction createFirstAction() {
        return new GoAction(Messages.getString("JRealTimeSpellPanel.GO_FIRST_BUTTON"), "gotoFirstError", "updateFirstAction", "getFirstError");
    }

    protected GoAction createPreviousAction() {
        return new GoAction(Messages.getString("JRealTimeSpellPanel.GO_PREVIOUS_BUTTON"), "gotoPreviousError", "updatePreviousAction", "getPreviousError");
    }

    protected GoAction createNextAction() {
        return new GoAction(Messages.getString("JRealTimeSpellPanel.GO_NEXT_BUTTON"), "gotoNextError", "updateNextAction", "getNextError");
    }

    protected GoAction createLastAction() {
        return new GoAction(Messages.getString("JRealTimeSpellPanel.GO_LAST_BUTTON"), "gotoLastError", "updateLastAction", "getLastError");
    }

    protected void createNavigationActions() {
        this.goFirstAction = this.createFirstAction();
        this.goPreviousAction = this.createPreviousAction();
        this.goNextAction = this.createNextAction();
        this.goLastAction = this.createLastAction();
    }

    protected JPanel createNavigationPanel() {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), Messages.getString("JRealTimeSpellPanel.NAVIGATION_TITLE_STRING")));
        this.createNavigationActions();
        result.add(new JButton(this.goFirstAction));
        result.add(new JButton(this.goPreviousAction));
        result.add(new JButton(this.goNextAction));
        result.add(new JButton(this.goLastAction));
        return result;
    }

    protected JPanel createErrorSolutionPanel() {
        this.solutionPanel = new SolutionContainerPanel(this.textComponentSpellChecker);
        this.solutionPanel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), Messages.getString("JRealTimeSpellPanel.SOLUTION_TITLE_STRING")));
        return this.solutionPanel;
    }

    private class SolutionUpdater
    implements Runnable {
        private SolutionPanel panel;

        public SolutionUpdater(SolutionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            if (null != JRealTimeSpellPanel.this.activeErrorMarker && this.panel.tryActivatePanel(JRealTimeSpellPanel.this.activeErrorMarker.getCurrentError())) {
                JRealTimeSpellPanel.this.solutionPanel.showSolutionPanel(this.panel);
                JRealTimeSpellPanel.this.setErrorInfoText(this.panel.getTitle());
            }
        }
    }

    protected class GoAction
    extends AbstractAction
    implements PropertyChangeListener {
        String actionMethodName;
        String updateMethodName;
        String errorMarkerMethod;

        public GoAction(String name, String actionMethodName, String updateMethodName, String errorMarkerMethod) {
            super(name);
            this.actionMethodName = actionMethodName;
            this.updateMethodName = updateMethodName;
            this.errorMarkerMethod = errorMarkerMethod;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Statement st = new Statement(JRealTimeSpellPanel.this, this.actionMethodName, new Object[]{JRealTimeSpellPanel.this.activeErrorMarker, this.getErrorInfo(JRealTimeSpellPanel.this.activeErrorMarker)});
            try {
                st.execute();
            }
            catch (Exception ex) {
                Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private ErrorInfo getErrorInfo(ErrorMarker errorMarker) {
            ErrorInfo result = null;
            if (null != errorMarker) {
                Expression st = new Expression(errorMarker, this.errorMarkerMethod, null);
                try {
                    result = (ErrorInfo)st.getValue();
                }
                catch (Exception ex) {
                    Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return result;
        }

        public void update(ErrorMarker errorMarker) {
            this.update(errorMarker, this.getErrorInfo(errorMarker));
        }

        public void update(ErrorMarker errorMarker, ErrorInfo errorInfo) {
            Statement st = new Statement(JRealTimeSpellPanel.this, this.updateMethodName, new Object[]{this, errorMarker, errorInfo});
            try {
                st.execute();
            }
            catch (Exception ex) {
                Logger.getLogger(JRealTimeSpellPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update((ErrorMarker)evt.getSource(), (ErrorInfo)evt.getNewValue());
        }
    }

    private class FindFocusAction
    extends AbstractSpellCheckerAction {
        public FindFocusAction() {
            super("");
        }

        public JTextComponent getTextComponent() {
            return this.getLastSelected();
        }

        @Override
        public void onFocusedTextComponentChanged(JTextComponent textCmp) {
            if (JRealTimeSpellPanel.this.isVisible()) {
                JRealTimeSpellPanel.this.onFocusedTextComponentChanged(textCmp);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

