/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.DictionaryManager;
import org.dts.spell.dictionary.DictionaryProvider;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.actions.ResetIgnoreWordsAction;
import org.dts.spell.swing.actions.ResetReplaceWordsAction;
import org.dts.spell.swing.utils.BlockProgressDialog;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.swing.utils.SeparatorLineBorder;

public class DictionaryConfigPanel
extends JPanel {
    private ExecutorService loader = Executors.newSingleThreadExecutor();
    private SpellChecker checker;
    private JPanel basicPropertiesPanel;
    private JButton closeButton;
    private JComboBox dictionaryComboBox;
    private JLabel dictionaryLabel;
    private JPanel dictionaryPanel;
    private JCheckBox ignoreCase;
    private JCheckBox ignoreNumbers;
    private JButton installDictionaryButton;
    private JButton installDictionaryFromFileButton;
    private JButton resetIgnoreWordsButton;
    private JLabel resetIgnoreWordsLabel;
    private JLabel resetIgnoreWordsLabel1;
    private JButton resetReplaceWordsButton;
    private JButton unistallDictionaryButtom;

    public DictionaryConfigPanel(JTextComponentSpellChecker txtCmpSpellChecker, Action closeAction) {
        this.initComponents();
        this.checker = txtCmpSpellChecker.getSpellChecker();
        this.ignoreCase.setSelected(this.checker.isIgnoreUpperCaseWords());
        this.ignoreNumbers.setSelected(this.checker.isSkipNumbers());
        this.resetIgnoreWordsButton.setAction(this.getResetIgnoreWordsAction(txtCmpSpellChecker));
        this.resetReplaceWordsButton.setAction(this.getResetReplaceWordsAction(txtCmpSpellChecker));
        this.closeButton.setAction(closeAction);
        this.unistallDictionaryButtom.setAction(this.getUninstallAction());
        this.installDictionaryButton.setAction(this.getInstallAction());
        this.initDictionaryCombobox(this.dictionaryComboBox);
    }

    protected Action getResetIgnoreWordsAction(JTextComponentSpellChecker txtCmpSpellChecker) {
        return new ResetIgnoreWordsAction(txtCmpSpellChecker);
    }

    protected Action getResetReplaceWordsAction(JTextComponentSpellChecker txtCmpSpellChecker) {
        return new ResetReplaceWordsAction(txtCmpSpellChecker);
    }

    protected DictionaryProvider selectDictionaryProvider() {
        DictionaryProvider[] dps = DictionaryManager.get().getDictionaryProviders();
        Object[] names = new String[dps.length];
        int selected = 0;
        for (int i = 0; i < dps.length; ++i) {
            names[i] = dps[i].getDisplayName();
        }
        selected = JOptionPane.showOptionDialog(this, "Seleccione el tipo de diccionario", "Selecci\u00f3n de tipo", 0, 3, null, names, names[0]);
        return dps[selected];
    }

    protected Action getUninstallAction() {
        UninstallAction result = new UninstallAction();
        this.dictionaryComboBox.addItemListener(result);
        return result;
    }

    protected Action getInstallAction() {
        return new InstallDictionariesAction();
    }

    protected String getDisplayLabel(Locale locale) {
        return String.format("%s de %s", locale.getDisplayLanguage(), locale.getDisplayCountry());
    }

    protected void initDictionaryCombobox(JComboBox dictionaryComboBox) {
        dictionaryComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String txt;
                if (value instanceof Locale) {
                    Locale locale = (Locale)value;
                    txt = DictionaryConfigPanel.this.getDisplayLabel(locale);
                } else {
                    txt = (String)value;
                }
                return super.getListCellRendererComponent((JList<?>)list, txt, index, isSelected, cellHasFocus);
            }
        });
    }

    protected void fillDictionaries() {
        this.dictionaryComboBox.addItem("Cargando locales, por favor espere");
        this.loader.submit(new Runnable(){

            @Override
            public void run() {
                DictionaryManager dm = DictionaryManager.get();
                List locales = dm.getInstalledLocales();
                Collections.sort(locales, new Comparator<DictionaryManager.LocaleProvider>(){

                    @Override
                    public int compare(DictionaryManager.LocaleProvider o1, DictionaryManager.LocaleProvider o2) {
                        return o1.getLocale().getDisplayLanguage().compareTo(o1.getLocale().getDisplayLanguage());
                    }
                });
                DictionaryConfigPanel.this.fillCombobox(locales);
            }
        });
    }

    protected void fillCombobox(final List<DictionaryManager.LocaleProvider> locales) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DictionaryConfigPanel.this.dictionaryComboBox.removeAllItems();
                if (locales.isEmpty()) {
                    DictionaryConfigPanel.this.dictionaryComboBox.addItem("No tiene diccionarios instalados");
                } else {
                    for (DictionaryManager.LocaleProvider localeProvider : locales) {
                        DictionaryConfigPanel.this.dictionaryComboBox.addItem(localeProvider.getLocale());
                    }
                }
                DictionaryConfigPanel.this.dictionaryComboBox.setSelectedItem(DictionaryConfigPanel.this.checker.getDictionary().getLocale());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(run);
        } else {
            run.run();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.loader = Executors.newSingleThreadExecutor();
        this.fillDictionaries();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (null != this.loader) {
            this.loader.shutdown();
        }
        this.loader = null;
        this.checker.setIgnoreUpperCaseWords(this.ignoreCase.isSelected());
        this.checker.setSkipNumbers(this.ignoreNumbers.isSelected());
    }

    private void initComponents() {
        this.dictionaryPanel = new JPanel();
        this.dictionaryComboBox = new JComboBox();
        this.dictionaryLabel = new JLabel();
        this.unistallDictionaryButtom = new JButton();
        this.installDictionaryButton = new JButton();
        this.installDictionaryFromFileButton = new JButton();
        this.basicPropertiesPanel = new JPanel();
        this.resetIgnoreWordsLabel1 = new JLabel();
        this.ignoreNumbers = new JCheckBox();
        this.ignoreCase = new JCheckBox();
        this.resetIgnoreWordsLabel = new JLabel();
        this.resetIgnoreWordsButton = new JButton();
        this.resetReplaceWordsButton = new JButton();
        this.closeButton = new JButton();
        this.dictionaryPanel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), "Diccionario"));
        this.dictionaryLabel.setText("Diccionario actual:");
        this.unistallDictionaryButtom.setText("Desintalar");
        this.installDictionaryButton.setText("Instalar m\u00e1s diccionarios...");
        this.installDictionaryFromFileButton.setText("Instalar diccionario desde fichero...");
        GroupLayout dictionaryPanelLayout = new GroupLayout(this.dictionaryPanel);
        this.dictionaryPanel.setLayout(dictionaryPanelLayout);
        dictionaryPanelLayout.setHorizontalGroup(dictionaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dictionaryPanelLayout.createSequentialGroup().addContainerGap().addGroup(dictionaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dictionaryPanelLayout.createSequentialGroup().addComponent(this.dictionaryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dictionaryComboBox, 0, 364, Short.MAX_VALUE)).addGroup(dictionaryPanelLayout.createSequentialGroup().addComponent(this.unistallDictionaryButtom).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.installDictionaryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installDictionaryFromFileButton))).addContainerGap()));
        dictionaryPanelLayout.setVerticalGroup(dictionaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dictionaryPanelLayout.createSequentialGroup().addContainerGap().addGroup(dictionaryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dictionaryLabel).addComponent(this.dictionaryComboBox, -2, -1, -2)).addGap(26, 26, 26).addGroup(dictionaryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unistallDictionaryButtom).addComponent(this.installDictionaryButton).addComponent(this.installDictionaryFromFileButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.basicPropertiesPanel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), "Opciones del corrector"));
        this.resetIgnoreWordsLabel1.setText("<html>Si por otro lado desea reiniciar la lista de palabras que el corrector reemplaza autom\u00e1ticamente pulse el bot\u00f3n de <b>reiniciar reemplazar palabras</b>.</html>");
        this.ignoreNumbers.setText("Ignorar los n\u00fameros.");
        this.ignoreNumbers.setActionCommand("ignoreNumers");
        this.ignoreCase.setText("Ignorar may\u00fasculas y min\u00fasuculas.");
        this.resetIgnoreWordsLabel.setText("<html>Si desea reiniciar la lista de palabras que el corrector debe de ignorar como err\u00f3neas pulse el bot\u00f3n de <b>reiniciar ignorar palabras</b>.<p></html>");
        this.resetIgnoreWordsButton.setText("Reiniciar ignorar palabras");
        this.resetReplaceWordsButton.setText("Reiniciar reemplazar palabras");
        GroupLayout basicPropertiesPanelLayout = new GroupLayout(this.basicPropertiesPanel);
        this.basicPropertiesPanel.setLayout(basicPropertiesPanelLayout);
        basicPropertiesPanelLayout.setHorizontalGroup(basicPropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicPropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.resetIgnoreWordsLabel, -1, 469, Short.MAX_VALUE).addContainerGap()).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.ignoreCase, -1, -1, Short.MAX_VALUE).addGap(286, 286, 286)).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.ignoreNumbers, -1, 203, Short.MAX_VALUE).addGap(276, 276, 276)).addGroup(GroupLayout.Alignment.TRAILING, basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.resetIgnoreWordsButton, -2, 184, -2).addContainerGap()).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.resetIgnoreWordsLabel1, -1, 469, Short.MAX_VALUE).addContainerGap())).addGroup(GroupLayout.Alignment.TRAILING, basicPropertiesPanelLayout.createSequentialGroup().addComponent(this.resetReplaceWordsButton).addContainerGap()))));
        basicPropertiesPanelLayout.linkSize(0, this.resetIgnoreWordsButton, this.resetReplaceWordsButton);
        basicPropertiesPanelLayout.setVerticalGroup(basicPropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPropertiesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ignoreNumbers, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreCase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resetIgnoreWordsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetIgnoreWordsButton).addGap(18, 18, 18).addComponent(this.resetIgnoreWordsLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.resetReplaceWordsButton).addContainerGap()));
        this.closeButton.setText("Cerrar");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.basicPropertiesPanel, GroupLayout.Alignment.LEADING, 0, 481, Short.MAX_VALUE).addComponent(this.dictionaryPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(365, Short.MAX_VALUE).addComponent(this.closeButton, -2, 126, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dictionaryPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.basicPropertiesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton).addContainerGap(36, Short.MAX_VALUE)));
    }

    public class InstallDictionariesAction
    extends AbstractAction {
        public InstallDictionariesAction() {
            super("Instalar m\u00e1s diccionarios...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final DictionaryProvider dp = DictionaryConfigPanel.this.selectDictionaryProvider();
            final BlockProgressDialog dlg = new BlockProgressDialog(null);
            try {
                List<Locale> locales = dlg.doTask(new Callable<List<Locale>>(){

                    @Override
                    public List<Locale> call() throws Exception {
                        dlg.beginProgress(new ProgressEvent((Object)this, "Empezando", 1, 10));
                        List result = dp.getAvailableLocales();
                        dlg.nextStep(new ProgressEvent((Object)this, "Leidos los locales", 2, 10));
                        try {
                            for (int i = 2; i < 10; ++i) {
                                Thread.sleep(500L);
                                dlg.nextStep(new ProgressEvent((Object)this, "Leidos los locales", i, 10));
                            }
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(DictionaryConfigPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        dlg.endProgress(new ProgressEvent((Object)this, "Bien leido", 10, 10));
                        return result;
                    }
                });
                if (null != dp) {
                    JOptionPane.showOptionDialog(DictionaryConfigPanel.this, "Seleccione el diccionario", "Selecci\u00f3n de diccionario", 0, 3, null, locales.toArray(), locales.get(0));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(DictionaryConfigPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class UninstallAction
    extends AbstractAction
    implements ItemListener {
        private DictionaryManager.LocaleProvider localeProvider;

        public UninstallAction() {
            super("Desinstalar");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (JOptionPane.showConfirmDialog(DictionaryConfigPanel.this, String.format("\u00bf Desea desinstalar ?", new Object[0]), "Desintalar", 0) == 0) {
                    DictionaryManager.get().unistall(this.localeProvider);
                }
            }
            catch (Exception ex) {
                ErrorMsgBox.show((Component)DictionaryConfigPanel.this, ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (1 == e.getStateChange()) {
                Object selObj = e.getItem();
                this.localeProvider = selObj instanceof DictionaryManager.LocaleProvider ? (DictionaryManager.LocaleProvider)selObj : null;
                this.setEnabled(null != this.localeProvider);
            }
        }
    }
}

