/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellCheckerListener
extends SpellCheckAdapter {
    private ErrorMarker errorMarker;

    public void setErrorMarker(ErrorMarker errorMarker) {
        this.errorMarker = errorMarker;
    }

    public void spellingError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getSpellingErrorInfo((SpellCheckEvent)event));
    }

    public void badCaseError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getBadCaseErrorInfo((SpellCheckEvent)event));
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getRepeatWordErrorInfo((SpellCheckEvent)event));
    }

    private void markError(SpellCheckEvent event, final ErrorInfo info) {
        if (!this.errorMarker.isActive()) {
            event.cancel();
        } else {
            final Word badWord = event.getCurrentWord();
            final ErrorMarker localErrorMarker = this.errorMarker;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (localErrorMarker.isActive()) {
                            localErrorMarker.markError(badWord.getStart(), badWord.getEnd(), info);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void beginChecking(SpellCheckEvent event) {
        if (!this.errorMarker.isActive()) {
            event.cancel();
        } else {
            SynchronizedWordFinder finder = (SynchronizedWordFinder)event.getWordFinder();
            final TextRange textRange = finder.getTextRange();
            final ErrorMarker localErrorMarker = this.errorMarker;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (localErrorMarker.isActive()) {
                        localErrorMarker.unMarkRange(textRange.getBegin(), textRange.getEnd());
                    }
                }
            });
        }
    }
}

