/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.dts.spell.SpellChecker;
import org.dts.spell.event.SpellCheckListener;
import org.dts.spell.finder.Word;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.event.RealTimeSpellCheckerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellChecker
implements DocumentListener,
Runnable {
    private SpellChecker spellChecker;
    private List<TextRange> textRanges = new LinkedList<TextRange>();
    private Map<Document, List<TextComponentAndFinder>> activeDocuments = new HashMap<Document, List<TextComponentAndFinder>>();
    private volatile boolean stopThread;
    private RealTimeSpellCheckerListener listener;
    private Thread thread;
    private static final TextComponentAndFinder[] EMPTY_ARRAY = new TextComponentAndFinder[0];

    public RealTimeSpellChecker(SpellChecker checker) {
        this.spellChecker = checker;
    }

    public void addTextComponent(JTextComponent textComponent, DocumentWordFinder finder) {
        Document doc = textComponent.getDocument();
        List<TextComponentAndFinder> list = this.activeDocuments.get(doc);
        if (null == list) {
            list = new LinkedList<TextComponentAndFinder>();
            this.activeDocuments.put(doc, list);
            doc.addDocumentListener(this);
        }
        list.add(new TextComponentAndFinder(textComponent, finder));
        this.addTextRange(doc);
    }

    public void removeTextComponent(JTextComponent textComponent) {
        this.removeTextComponent(textComponent.getDocument(), textComponent);
    }

    DocumentWordFinder removeTextComponent(Document doc, JTextComponent textComponent) {
        List<TextComponentAndFinder> list = this.activeDocuments.get(doc);
        DocumentWordFinder result = null;
        if (null != list) {
            ListIterator<TextComponentAndFinder> it = list.listIterator();
            while (it.hasNext()) {
                TextComponentAndFinder txtCmpFnd = it.next();
                if (txtCmpFnd.getTextComponent() != textComponent) continue;
                it.remove();
                txtCmpFnd.getErrorMarker().quitTextComponent(doc);
                result = txtCmpFnd.getWordFinder().getWrapDocumentFinder();
            }
            if (list.isEmpty()) {
                this.activeDocuments.remove(doc);
                doc.removeDocumentListener(this);
            }
        }
        return result;
    }

    public List<ErrorMarker> getErrorMarkers() {
        LinkedList<ErrorMarker> list = new LinkedList<ErrorMarker>();
        for (List<TextComponentAndFinder> txtCmpList : this.activeDocuments.values()) {
            for (TextComponentAndFinder txtCmpFnd : txtCmpList) {
                list.add(txtCmpFnd.getErrorMarker());
            }
        }
        return list;
    }

    public boolean isEmpty() {
        return this.activeDocuments.isEmpty();
    }

    private TextComponentAndFinder getTextComponentAndFinder(JTextComponent textComponent) {
        return this.getTextComponentAndFinder(textComponent.getDocument(), textComponent);
    }

    private TextComponentAndFinder getTextComponentAndFinder(Document doc, JTextComponent textComponent) {
        List<TextComponentAndFinder> list = this.activeDocuments.get(doc);
        if (null != list) {
            for (TextComponentAndFinder txtFnd : list) {
                if (txtFnd.getTextComponent() != textComponent) continue;
                return txtFnd;
            }
        }
        return null;
    }

    public ErrorMarker getErrorMarker(JTextComponent textComponent) {
        return this.getErrorMarker(textComponent.getDocument(), textComponent);
    }

    ErrorMarker getErrorMarker(Document doc, JTextComponent textComponent) {
        TextComponentAndFinder txtCmpFnd = this.getTextComponentAndFinder(doc, textComponent);
        if (null != txtCmpFnd) {
            return txtCmpFnd.getErrorMarker();
        }
        return null;
    }

    public DocumentWordFinder getWordFinder(JTextComponent textComponent) {
        TextComponentAndFinder txtCmpFnd = this.getTextComponentAndFinder(textComponent);
        if (null != txtCmpFnd) {
            return txtCmpFnd.getWordFinder().getWrapDocumentFinder();
        }
        return null;
    }

    public boolean isRealTimeSpellChecking(JTextComponent textComponent) {
        return this.isRealTimeSpellChecking(textComponent.getDocument(), textComponent);
    }

    boolean isRealTimeSpellChecking(Document doc, JTextComponent textComponent) {
        return this.getTextComponentAndFinder(doc, textComponent) != null;
    }

    public synchronized void start() {
        assert (null == this.thread);
        this.stopThread = false;
        this.listener = new RealTimeSpellCheckerListener();
        this.thread = new Thread(this);
        this.thread.setName("Spell-checker");
        this.thread.setPriority(1);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        assert (null != this.thread);
        RealTimeSpellChecker realTimeSpellChecker = this;
        synchronized (realTimeSpellChecker) {
            this.stopThread = true;
            this.notify();
        }
        try {
            this.thread.join();
            this.thread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void addTextRange(Document document) {
        this.addTextRange(document, 0, document.getLength());
    }

    public void addTextRange(final Document document, final int begin, final int length) {
        this.addTextRange(new DocumentEvent(){

            @Override
            public int getOffset() {
                return begin;
            }

            @Override
            public int getLength() {
                return length;
            }

            @Override
            public Document getDocument() {
                return document;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.CHANGE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element elem) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    public synchronized void addTextRange(DocumentEvent e) {
        assert (null != this.thread);
        try {
            if (!this.textRanges.isEmpty()) {
                TextRange oldTextRange = this.textRanges.get(this.textRanges.size() - 1);
                TextRange newTextRange = oldTextRange.compactWith(e);
                if (null != newTextRange) {
                    this.textRanges.add(newTextRange);
                }
            } else {
                this.textRanges.add(new TextRange(e));
            }
            if (!this.textRanges.isEmpty()) {
                this.notify();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(TextRange range, RealTimeSpellCheckerListener listener) {
        Document doc = range.getDocument();
        TextComponentAndFinder[] list = EMPTY_ARRAY;
        TextComponentAndFinder[] textComponentAndFinderArray = this;
        synchronized (this) {
            List<TextComponentAndFinder> currentList = this.activeDocuments.get(doc);
            if (null != currentList) {
                list = currentList.toArray(list);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            for (TextComponentAndFinder txtCmpFnd : list) {
                SynchronizedWordFinder finder = txtCmpFnd.getWordFinder();
                listener.setErrorMarker(txtCmpFnd.getErrorMarker());
                Word lastWord = finder.setTextRange(range);
                this.spellChecker.setLastWord(lastWord);
                this.spellChecker.check((WordFinder)finder, (SpellCheckListener)listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (true) {
            try {
                while (true) {
                    TextRange range;
                    RealTimeSpellChecker realTimeSpellChecker = this;
                    synchronized (realTimeSpellChecker) {
                        if (!this.stopThread && this.textRanges.isEmpty()) {
                            this.wait();
                        }
                        if (this.stopThread) {
                            break block5;
                        }
                        range = this.textRanges.remove(0);
                    }
                    this.checkRange(range, this.listener);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static class TextComponentAndFinder {
        private SynchronizedWordFinder finder;
        private ErrorMarker errorMarker;

        public TextComponentAndFinder(JTextComponent textComponent, DocumentWordFinder documentFinder) {
            this.errorMarker = ErrorMarker.get(textComponent, false);
            this.finder = new SynchronizedWordFinder(documentFinder);
        }

        public ErrorMarker getErrorMarker() {
            return this.errorMarker;
        }

        public SynchronizedWordFinder getWordFinder() {
            return this.finder;
        }

        public JTextComponent getTextComponent() {
            return this.errorMarker.getTextComponent();
        }
    }
}

