/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.actions.ErrorInfoAction;

public class ErrorPopUpMenu {
    private JPopupMenu NULL_POPUP = new NullPopup();
    private ErrorPopupMenuListener errorPopupMenuListener = new ErrorPopupMenuListener();
    private Hashtable<JTextComponent, PopupMenuInfo> currentEditors = new Hashtable();
    private JTextComponentSpellChecker textComponentSpellChecker;

    protected JTextComponentSpellChecker getTextComponentSpellChecker() {
        return this.textComponentSpellChecker;
    }

    public ErrorPopUpMenu(JTextComponentSpellChecker textComponentSpellChecker) {
        this.textComponentSpellChecker = textComponentSpellChecker;
    }

    public void addErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        this.currentEditors.put(textComponent, new PopupMenuInfo(errorMarker));
        textComponent.addMouseMotionListener(this.errorPopupMenuListener);
        textComponent.getComponentPopupMenu().addPopupMenuListener(this.errorPopupMenuListener);
    }

    public void removeErrorMarker(ErrorMarker errorMarker) {
        JTextComponent textComponent = errorMarker.getTextComponent();
        PopupMenuInfo info = this.currentEditors.get(textComponent);
        textComponent.removePropertyChangeListener(info);
        this.currentEditors.remove(textComponent);
        textComponent.getComponentPopupMenu().removePopupMenuListener(this.errorPopupMenuListener);
        textComponent.removeMouseMotionListener(this.errorPopupMenuListener);
        if (null == info.originalPopup) {
            textComponent.setComponentPopupMenu(null);
        }
    }

    public PopupMenuInfo getPopupMenuInfo(JPopupMenu popup) {
        return this.currentEditors.get((JTextComponent)popup.getInvoker());
    }

    protected void mergeWithErrorPopupMenuItems(JPopupMenu popup) {
        JTextComponent textCmp = (JTextComponent)popup.getInvoker();
        PopupMenuInfo popupInfo = this.currentEditors.get(textCmp);
        ErrorMarker marker = popupInfo.errorMarker;
        int pos = null != popupInfo.position ? textCmp.viewToModel(popupInfo.position) : textCmp.getCaretPosition();
        this.mergeWithErrorPopupMenu(marker, pos);
    }

    protected void deleteErrorPopupMenuItems(JPopupMenu menu) {
        ErrorPopUpMenu.cleanErrorPopupMenu(menu);
    }

    protected void mergeWithErrorPopupMenu(ErrorMarker marker, int position) {
        ErrorInfo info = marker.getErrorInfo(position);
        if (null != info) {
            this.mergeWithErrorPopupMenu(info, marker.getTextComponent());
        }
    }

    protected JPopupMenu getErrorPopupMenu(ErrorInfo info, JTextComponent textComponent) {
        return this.mergeWithErrorPopupMenu(info, textComponent);
    }

    protected ErrorInfoAction setupErrorInfoAction(ErrorInfoAction action, ErrorInfo info) {
        action.setErrorInfo(info);
        return action;
    }

    protected Action getDeleteWordAction(ErrorInfo info) {
        return this.setupErrorInfoAction(this.getTextComponentSpellChecker().getDeleteWordAction(), info);
    }

    protected Action getReplaceWordAction(ErrorInfo info, String suggestion) {
        return this.setupErrorInfoAction(this.getTextComponentSpellChecker().getReplaceWordAction(suggestion), info);
    }

    protected Action getAddWordAction(ErrorInfo info) {
        return this.setupErrorInfoAction(this.getTextComponentSpellChecker().getAddWordAction(), info);
    }

    protected Action getIgnoreWordAction(ErrorInfo info) {
        return this.setupErrorInfoAction(this.getTextComponentSpellChecker().getIgnoreWordAction(), info);
    }

    protected JPopupMenu mergeWithErrorPopupMenu(ErrorInfo info, JTextComponent textComponent) {
        String[] suggestions = info.getSuggestions();
        JPopupMenu result = textComponent.getComponentPopupMenu();
        if (null == suggestions) {
            if (result.getSubElements().length > 0) {
                result.add(new SeparatorSpellErrorMenuItem());
            }
            result.add(new SpellMenutItem(this.getDeleteWordAction(info)));
        } else if (suggestions.length > 0) {
            if (result.getSubElements().length > 0) {
                result.add(new SeparatorSpellErrorMenuItem());
            }
            for (String sg : suggestions) {
                result.add(new SpellMenutItem(this.getReplaceWordAction(info, sg)));
            }
        }
        if (info.isSpellingError()) {
            if (result.getSubElements().length > 0) {
                result.add(new SeparatorSpellErrorMenuItem());
            }
            result.add(new SpellMenutItem(this.getIgnoreWordAction(info)));
            result.add(new SpellMenutItem(this.getAddWordAction(info)));
        }
        return result;
    }

    protected static JPopupMenu cleanErrorPopupMenu(JTextComponent textComponent) {
        return ErrorPopUpMenu.cleanErrorPopupMenu(textComponent.getComponentPopupMenu());
    }

    protected static JPopupMenu cleanErrorPopupMenu(JPopupMenu menu) {
        boolean exit;
        int current = menu.getComponentCount() - 1;
        boolean bl = exit = current < 0;
        while (!exit) {
            Component cmp = menu.getComponent(current);
            if (cmp instanceof SpellErrorMenuItem) {
                menu.remove(cmp);
                exit = --current < 0;
                continue;
            }
            exit = true;
        }
        return menu;
    }

    protected class SpellMenutItem
    extends JMenuItem
    implements SpellErrorMenuItem {
        public SpellMenutItem(Action action) {
            super(action);
        }
    }

    protected static class SeparatorSpellErrorMenuItem
    extends JPopupMenu.Separator
    implements SpellErrorMenuItem {
        protected SeparatorSpellErrorMenuItem() {
        }
    }

    protected static interface SpellErrorMenuItem {
    }

    private class ErrorPopupMenuListener
    extends MouseMotionAdapter
    implements PopupMenuListener {
        private ErrorPopupMenuListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ErrorPopUpMenu.this.deleteErrorPopupMenuItems((JPopupMenu)e.getSource());
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            if (ErrorPopUpMenu.this.NULL_POPUP != popup) {
                ErrorPopUpMenu.this.mergeWithErrorPopupMenuItems(popup);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PopupMenuInfo popupInfo = (PopupMenuInfo)ErrorPopUpMenu.this.currentEditors.get((JTextComponent)e.getSource());
            popupInfo.position = e.getPoint();
        }
    }

    public class PopupMenuInfo
    implements PropertyChangeListener {
        public ErrorMarker errorMarker;
        public JPopupMenu originalPopup;
        public Point position;

        public PopupMenuInfo(ErrorMarker marker) {
            JComponent parent;
            JTextComponent textComponent = marker.getTextComponent();
            this.errorMarker = marker;
            this.originalPopup = textComponent.getComponentPopupMenu();
            textComponent.addPropertyChangeListener("componentPopupMenu", this);
            if (null == this.originalPopup) {
                textComponent.setComponentPopupMenu(ErrorPopUpMenu.this.NULL_POPUP);
            }
            if (textComponent.getInheritsPopupMenu() && textComponent.getParent() instanceof JComponent && this.originalPopup == (parent = (JComponent)textComponent.getParent()).getComponentPopupMenu()) {
                this.originalPopup = null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPopupMenu newPopup = (JPopupMenu)evt.getNewValue();
            if (newPopup != this.originalPopup) {
                this.originalPopup = newPopup;
            }
        }
    }

    private class NullPopup
    extends JPopupMenu {
        private NullPopup() {
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                ErrorPopUpMenu.this.mergeWithErrorPopupMenuItems(this);
                if (this.getSubElements().length > 0) {
                    super.setVisible(b);
                }
            } else {
                super.setVisible(b);
            }
        }
    }
}

