/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxEntries;

    public LRUMap(int maxEntries) {
        this(16, maxEntries);
    }

    public LRUMap(int initialCapacity, int maxEntries) {
        this(initialCapacity, 0.75f, maxEntries);
    }

    public LRUMap(int initialCapacity, float loadFactor, int maxEntries) {
        super(initialCapacity, loadFactor, true);
        this.maxEntries = maxEntries;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        if (this.size() > maxEntries) {
            ArrayList keys = new ArrayList(this.keySet());
            ArrayList values = new ArrayList(this.values());
            this.clear();
            ListIterator keysIt = keys.listIterator();
            ListIterator valuesIt = values.listIterator();
            while (this.size() <= maxEntries && keysIt.hasNext() && valuesIt.hasNext()) {
                this.put(keysIt.next(), valuesIt.next());
            }
        }
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxEntries;
    }
}

