/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dts.spell.event.ProgressListener;

public class FileUtils {
    public static File getUserDir() {
        return new File(System.getProperty("user.home"));
    }

    public static File getJMySpellDir() {
        File dir = new File(FileUtils.getUserDir(), ".jmyspell");
        dir.mkdirs();
        return dir;
    }

    public static File getDictionariesDir() {
        File dir = new File(FileUtils.getJMySpellDir(), "dictionaries");
        dir.mkdirs();
        return dir;
    }

    public static String extractNameAndExtension(String name) {
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static String extractOnlyName(String name) {
        int index = name.lastIndexOf(46);
        String rootName = index != -1 ? name.substring(0, index) : name;
        index = name.lastIndexOf(47);
        if (index != -1) {
            rootName = rootName.substring(index + 1);
        }
        return rootName;
    }

    public static String extractOnlyName(File file) {
        return FileUtils.extractOnlyName(file.getName());
    }

    public static File extractRootFile(File file) {
        return new File(file.getParent(), FileUtils.extractOnlyName(file));
    }

    public static String getFileExtension(File file) {
        String name = FileUtils.extractOnlyName(file);
        String fullName = file.getName();
        return fullName.substring(name.length());
    }

    public static void copyStream(InputStream in, OutputStream out, ProgressListener listener) throws IOException {
        byte[] bytes = new byte[65536];
        int r = in.read(bytes);
        while (r > 0) {
            out.write(bytes, 0, r);
            r = in.read(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(File file, InputStream in, ProgressListener listener) throws IOException {
        FileOutputStream fo = new FileOutputStream(file);
        try (BufferedOutputStream out = new BufferedOutputStream(fo);){
            FileUtils.copyStream(in, fo, listener);
        }
    }
}

