/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class EventMulticaster<T> {
    private final List<T> listeners = new CopyOnWriteArrayList<T>();
    private final T multicaster;

    public EventMulticaster(Class<T> type) {
        this.multicaster = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new MyInvocationHandler());
    }

    public void addListener(T listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public T getMulticaster() {
        return this.multicaster;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    private class MyInvocationHandler
    implements InvocationHandler {
        private MyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                for (Object listener : EventMulticaster.this.listeners) {
                    method.invoke(listener, args);
                }
                return null;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

