/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.openoffice;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.dictionary.myspell.MySpell;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.event.ProgressListenerSupport;
import org.dts.spell.utils.FileUtils;

public class OpenOfficeSpellDictionary
implements SpellDictionary {
    private File personalDict;
    private MySpell mySpell;
    private Future<Object> loader = null;
    private ProgressListenerSupport listeners = new ProgressListenerSupport();
    private Locale locale;
    private URL sourceURL;

    public OpenOfficeSpellDictionary() {
    }

    public OpenOfficeSpellDictionary(Locale locale) {
        this.locale = locale;
    }

    public OpenOfficeSpellDictionary(InputStream affIS, InputStream dicIS) throws IOException {
        this(affIS, dicIS, true);
    }

    public OpenOfficeSpellDictionary(InputStream affIS, InputStream dicIS, boolean inBackground) throws IOException {
        this(affIS, dicIS, OpenOfficeSpellDictionary.getPersonalWordsFile(), true);
    }

    public OpenOfficeSpellDictionary(InputStream affIS, InputStream dicIS, File personalDict, boolean inBackground) throws IOException {
        this.load(affIS, dicIS, personalDict, inBackground);
    }

    public OpenOfficeSpellDictionary(ZipFile zipFile) throws IOException {
        this(zipFile, true);
    }

    public OpenOfficeSpellDictionary(ZipFile zipFile, boolean inBackground) throws IOException {
        this.load(zipFile, inBackground);
    }

    public OpenOfficeSpellDictionary(InputStream zipStream, File personalDict) throws IOException {
        this(zipStream, personalDict, true);
    }

    public OpenOfficeSpellDictionary(InputStream zipStream, File personalDict, boolean inBackground) throws IOException {
        this.load(zipStream, personalDict, inBackground);
    }

    public OpenOfficeSpellDictionary(File file) throws IOException {
        this(file, true);
    }

    public OpenOfficeSpellDictionary(File file, boolean inBackground) throws IOException {
        this.load(file, inBackground);
    }

    public OpenOfficeSpellDictionary(File dictFile, File affFile) throws IOException {
        this(dictFile, affFile, true);
    }

    public OpenOfficeSpellDictionary(File dictFile, File affFile, boolean inBackground) throws IOException {
        this.load(dictFile, affFile, inBackground);
    }

    private void initFromFiles(final File dictFile, final File affFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromFiles(dictFile, affFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromFiles(dictFile, affFile);
        }
    }

    private synchronized void beginLoad() {
        this.listeners.beginProgress(new ProgressEvent(this, "Cargando diccionario", 0, 2));
    }

    private synchronized void endLoad(IOException ex) throws IOException {
        this.listeners.endProgress(new ProgressEvent(this, ex));
        throw ex;
    }

    private synchronized void endLoad(MySpell dict) {
        this.mySpell = dict;
        this.listeners.endProgress(new ProgressEvent(this, "Carga realizada con \u00e9xito", 2, 2));
    }

    private void initFromFiles(File dictFile, File affFile) throws IOException {
        try {
            this.beginLoad();
            this.personalDict = OpenOfficeSpellDictionary.getPersonalWordsFile(this.getLocale());
            MySpell dict = new MySpell(affFile.getPath(), dictFile.getPath(), (ProgressListener)this.listeners);
            this.readPersonalWords(this.personalDict, dict);
            this.endLoad(dict);
        }
        catch (IOException ex) {
            this.endLoad(ex);
        }
    }

    private void initFromZipFile(ZipFile zipFile) throws IOException {
        try {
            this.beginLoad();
            this.personalDict = OpenOfficeSpellDictionary.getPersonalWordsFile(this.getLocale());
            MySpell dict = new MySpell(zipFile, (ProgressListener)this.listeners);
            this.readPersonalWords(this.personalDict, dict);
            this.endLoad(dict);
        }
        catch (IOException ex) {
            this.endLoad(ex);
        }
    }

    private void initFromStream(InputStream zipStream, File personalDict) throws IOException {
        try {
            this.beginLoad();
            this.personalDict = personalDict;
            MySpell dict = new MySpell(zipStream, (ProgressListener)this.listeners);
            this.readPersonalWords(personalDict, dict);
            this.endLoad(dict);
        }
        catch (IOException ex) {
            this.endLoad(ex);
        }
    }

    private void initFromStreams(InputStream dicIS, InputStream affIS, File personalDict) throws IOException {
        try {
            this.beginLoad();
            this.personalDict = personalDict;
            MySpell dict = new MySpell(dicIS, affIS, (ProgressListener)this.listeners);
            this.readPersonalWords(personalDict, dict);
            this.endLoad(dict);
        }
        catch (IOException ex) {
            this.endLoad(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addWord(String word) throws SpellDictionaryException {
        this.waitToLoad();
        PrintWriter pw = null;
        word = word.trim();
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.personalDict, true), this.mySpell.get_dic_encoding()));
            this.mySpell.addCustomWord(word);
            pw.println(word);
        }
        catch (Exception ex) {
            try {
                throw new SpellDictionaryException(ex);
            }
            catch (Throwable throwable) {
                try {
                    Utils.close(pw);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SpellDictionaryException(e);
                }
            }
        }
        try {
            Utils.close(pw);
            return;
        }
        catch (IOException e) {
            throw new SpellDictionaryException(e);
        }
    }

    @Override
    public boolean isCorrect(String word) {
        this.waitToLoad();
        return this.mySpell.spell(word);
    }

    @Override
    public List<String> getSuggestions(String word) {
        this.waitToLoad();
        return this.mySpell.suggest(word);
    }

    @Override
    public List<String> getSuggestions(String word, int nMax) {
        this.waitToLoad();
        return this.mySpell.suggest(word, nMax);
    }

    @Override
    public synchronized boolean isLoad() {
        return null != this.mySpell;
    }

    private void waitToLoad() {
        try {
            if (null != this.loader && !this.loader.isDone()) {
                this.loader.get();
                this.loader = null;
            }
            if (!this.isLoad()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static File getPersonalWordsFile(Locale locale) {
        if (null != locale) {
            return new File(FileUtils.getJMySpellDir(), String.format("%s_%s.per", locale.getLanguage(), locale.getCountry()));
        }
        return OpenOfficeSpellDictionary.getPersonalWordsFile();
    }

    private static File getPersonalWordsFile() {
        return new File(FileUtils.getJMySpellDir(), "dictionary.per");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersonalWords(File personalFile, MySpell mySpell) throws IOException {
        BufferedReader rd = null;
        FileInputStream fr = null;
        try {
            if (null != personalFile && personalFile.exists() && !personalFile.isDirectory()) {
                fr = new FileInputStream(personalFile);
                rd = new BufferedReader(new InputStreamReader((InputStream)fr, mySpell.get_dic_encoding()));
                int size = (int)personalFile.length();
                int current = size - fr.available();
                this.listeners.nextStep(new ProgressEvent(this, "Cargando diccionario personal", current, size));
                String line = rd.readLine();
                while (line != null) {
                    current = size - fr.available();
                    this.listeners.nextStep(new ProgressEvent(this, "Cargando diccionario personal", current, size));
                    mySpell.addCustomWord(line.trim());
                    line = rd.readLine();
                }
            }
        }
        finally {
            Utils.close(rd);
        }
    }

    public void load(InputStream affIS, InputStream dicIS, boolean inBackground) throws IOException {
        this.load(affIS, dicIS, OpenOfficeSpellDictionary.getPersonalWordsFile(this.getLocale()), true);
    }

    public void load(final InputStream affIS, final InputStream dicIS, final File personalDict, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromStreams(affIS, dicIS, personalDict);
                    dicIS.close();
                    affIS.close();
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromStreams(affIS, dicIS, personalDict);
        }
    }

    public void load(final ZipFile zipFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromZipFile(zipFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromZipFile(zipFile);
        }
    }

    public void load(final InputStream zipStream, final File personalDict, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromStream(zipStream, personalDict);
                    zipStream.close();
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromStream(zipStream, personalDict);
        }
    }

    public void load(File dictFile, File affFile, boolean inBackground) throws IOException {
        this.initFromFiles(dictFile, affFile, inBackground);
    }

    public void load(File file, boolean inBackground) throws IOException {
        if (file.getName().endsWith(".zip")) {
            this.load(new ZipFile(file), inBackground);
        } else {
            this.load(new File(FileUtils.extractRootFile(file) + ".dic"), new File(FileUtils.extractRootFile(file) + ".aff"), inBackground);
        }
    }

    public void setDictionarySource(URL url) {
        this.sourceURL = url;
    }

    @Override
    public void load() throws IOException {
        if (null == this.sourceURL) {
            throw new IllegalStateException("No dictionary source set");
        }
        this.load(this.sourceURL.openStream(), OpenOfficeSpellDictionary.getPersonalWordsFile(this.getLocale()), true);
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        if (null != this.loader) {
            throw new IllegalStateException("This dictionary load was started");
        }
        this.listeners.addListener(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

