/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.openoffice;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Pattern;
import org.dts.spell.dictionary.AbstractDictionaryProvider;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.openoffice.OpenOfficeSpellDictionary;
import org.dts.spell.event.ProgressListener;

public class OpenOfficeDictionaryProvider
extends AbstractDictionaryProvider {
    public static final String REMOTE_SC_DICTIONARY_LIST_LOCATION = "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/";
    public static final String FILES_PATTERN_STRING = "([a-z]{1,8})_(([A-Z]{1,8})?)(_1-3-2)?(\\.zip)";
    public static final Pattern DICTIONARY_ZIP = Pattern.compile("\"([a-z]{1,8})_(([A-Z]{1,8})?)(_1-3-2)?(\\.zip)\"");
    public static final Pattern FILES_DICTIONARY_ZIP = Pattern.compile("([a-z]{1,8})_(([A-Z]{1,8})?)(_1-3-2)?(\\.zip)");

    @Override
    protected Pattern getDictionariesSourceFilesPattern() {
        return DICTIONARY_ZIP;
    }

    @Override
    protected Pattern getInstalledDictionariesFilesPattern() {
        return FILES_DICTIONARY_ZIP;
    }

    @Override
    protected URI getDefaultDictionariesSource() throws URISyntaxException {
        return new URI(REMOTE_SC_DICTIONARY_LIST_LOCATION);
    }

    protected File getFileForLocale(Locale locale) {
        String lang = locale.getLanguage();
        String contry = locale.getCountry();
        String fileName = String.format("%s_%s.zip", lang, contry);
        File dictDir = this.getLocalStorageDir();
        return new File(dictDir, fileName);
    }

    @Override
    public SpellDictionary getDictionary(Locale locale) throws IOException {
        URL dictURL = this.getFileForLocale(locale).toURI().toURL();
        OpenOfficeSpellDictionary result = new OpenOfficeSpellDictionary(locale);
        result.setDictionarySource(dictURL);
        return result;
    }

    @Override
    public void install(Locale locale, ProgressListener listener) throws Exception {
        File installFile = this.getFileForLocale(locale);
        String fileName = installFile.getName();
        URL dictURL = this.getDictionariesSource().resolve(fileName).toURL();
        this.createLocalCopy(dictURL, listener);
    }

    @Override
    public void install(File file, ProgressListener listener) throws Exception {
        Locale locale = this.getLocaleForFile(file);
        if (null == locale) {
            throw new IOException("El formato de archivo no es correcto");
        }
        this.createLocalCopy(file.toURI().toURL(), listener);
    }

    @Override
    public void uninstall(Locale locale, ProgressListener listener) {
        File dirFile = this.getFileForLocale(locale);
        if (dirFile.exists()) {
            dirFile.delete();
        }
    }

    @Override
    public String getDisplayName() {
        return "Diccionarios OppenOffice.org java 100%";
    }
}

