/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell.wordmaps;

import java.util.Map;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.wordmaps.IndexedFileWordMap;
import org.dts.spell.utils.LRUMap;

public class IndexedFileWordMapWithCache
extends IndexedFileWordMap {
    private Map<Integer, HEntry> positionsLru = null;
    private Map<String, Integer> wordsLru = null;

    public IndexedFileWordMapWithCache() {
        this(false);
    }

    public IndexedFileWordMapWithCache(boolean onlyFiles) {
        this(3000, 2000, onlyFiles);
    }

    public IndexedFileWordMapWithCache(int maxPositions, int maxWords, boolean onlyFiles) {
        super(onlyFiles);
        if (maxPositions > 0) {
            this.positionsLru = new LRUMap<Integer, HEntry>(maxPositions);
        }
        if (maxWords > 0) {
            this.wordsLru = new LRUMap<String, Integer>(maxWords);
        }
    }

    @Override
    public HEntry get(String word) {
        if (null != this.wordsLru) {
            HEntry result = null;
            Integer position = this.wordsLru.get(word);
            if (null != position) {
                result = this.getEntryFromPosition(position.intValue());
            } else {
                int index = this.getWordIndex(word);
                if (index > 0) {
                    result = this.getEntry(index);
                    this.wordsLru.put(word, (int)this.getEntryPosition(index));
                }
            }
            return result;
        }
        return super.get(word);
    }

    @Override
    protected String getWord(int index) {
        if (null != this.positionsLru) {
            long position = this.getEntryPosition(index);
            HEntry entry = this.positionsLru.get(position);
            if (null == entry) {
                entry = this.getEntryFromPosition(position);
            }
            return entry.word;
        }
        return super.getWord(index);
    }

    @Override
    protected HEntry getEntryFromPosition(long position) {
        if (null != this.positionsLru) {
            HEntry result = this.positionsLru.get(position);
            if (null == result) {
                result = super.getEntryFromPosition(position);
                this.positionsLru.put((int)position, result);
            }
            return result;
        }
        return super.getEntryFromPosition(position);
    }
}

