/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell.wordmaps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;
import org.dts.spell.myspell.utils.CharMap;
import org.dts.spell.utils.FileUtils;

public class IndexedFileWordMap
extends WordMap {
    private CharMap charMap = new CharMap();
    private String wordMapName;
    private RandomAccessFile words;
    private IndexStorage indexStorage = new FileIndex();

    public IndexedFileWordMap(boolean onlyFiles) {
        this.indexStorage = onlyFiles ? new FileIndex() : new MemoryIndex();
    }

    private File getWordsFile() {
        return new File(FileUtils.getJMySpellDir(), this.wordMapName + ".dic");
    }

    private File getIndexFile() {
        return new File(FileUtils.getJMySpellDir(), this.wordMapName + ".idx");
    }

    @Override
    public void init(long lastModificationTime, String wordMapName, String encoding) throws IOException {
        this.wordMapName = wordMapName;
        File wordFile = this.getWordsFile();
        if (wordFile.lastModified() > lastModificationTime) {
            try {
                this.words = new RandomAccessFile(wordFile, "r");
                this.indexStorage.initFromFile(this.getIndexFile());
            }
            catch (Exception ex) {
                if (null != this.words) {
                    this.words.close();
                }
                this.words = null;
            }
        }
    }

    @Override
    public boolean needEntries() {
        return null == this.words;
    }

    @Override
    public void beginAddEntries(int nEntries) throws IOException {
        File wordFile = this.getWordsFile();
        this.indexStorage.initFromEntries(nEntries, this.getIndexFile());
        wordFile.delete();
        this.words = new RandomAccessFile(wordFile, "rw");
    }

    @Override
    public void endAddEntries(int nEntries) throws IOException {
        Utils.heapSort(this.indexStorage, new Utils.IndexComparator(){

            @Override
            public boolean isLess(int index1, int index2) {
                return IndexedFileWordMap.this.getEntryFromPosition(index1).compareTo(IndexedFileWordMap.this.getEntryFromPosition(index2)) < 0;
            }

            @Override
            public boolean isGreater(int index1, int index2) {
                return IndexedFileWordMap.this.getEntryFromPosition(index1).compareTo(IndexedFileWordMap.this.getEntryFromPosition(index2)) > 0;
            }
        });
        this.indexStorage.endFromEntries(nEntries, this.getIndexFile());
    }

    @Override
    public HEntry get(String word) {
        try {
            int index = Utils.binarySearch(word, this.indexStorage.getSize(), new Utils.IndexSearcher<String>(){

                @Override
                public int compare(int index, String obj) {
                    return IndexedFileWordMap.this.getWord(index).compareTo(obj);
                }
            });
            if (index >= 0) {
                return this.getEntry(index);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void add(HEntry entry) throws IOException {
        this.indexStorage.add((int)this.words.length());
        this.charMap.put(entry.word);
        this.words.writeUTF(entry.word);
        this.words.writeUTF(entry.astr);
    }

    protected long getEntryPosition(int index) {
        return this.indexStorage.get(index);
    }

    protected int getWordIndex(String word) {
        return Utils.binarySearch(word, this.indexStorage.getSize(), new Utils.IndexSearcher<String>(){

            @Override
            public int compare(int index, String obj) {
                return IndexedFileWordMap.this.getWord(index).compareTo(obj);
            }
        });
    }

    protected String getWord(int index) {
        try {
            this.words.seek(this.getEntryPosition(index));
            return this.words.readUTF();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected HEntry getEntry(int index) {
        return this.getEntryFromPosition(this.getEntryPosition(index));
    }

    protected HEntry getEntryFromPosition(long position) {
        try {
            this.words.seek(position);
            return new HEntry(this.words.readUTF(), this.words.readUTF());
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void addCustomWord(String word) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<HEntry> iterator() {
        return new EntryIterator();
    }

    private static class FileIndex
    implements IndexStorage {
        private static int BEGIN_DATA = 23;
        private static int BEGIN_ARRAY = 27;
        private RandomAccessFile indexFile;
        private int nIndex;

        private FileIndex() {
        }

        @Override
        public void initFromFile(File file) throws Exception {
            this.indexFile = new RandomAccessFile(file, "r");
            this.indexFile.seek(BEGIN_DATA);
            this.nIndex = this.indexFile.readInt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initFromEntries(int nEntries, File file) throws IOException {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(new int[0]);
            }
            catch (Throwable throwable) {
                Utils.close(out);
                throw throwable;
            }
            Utils.close(out);
            this.indexFile = new RandomAccessFile(file, "rw");
            this.indexFile.seek(BEGIN_DATA);
            this.nIndex = this.indexFile.readInt();
        }

        @Override
        public void add(int index) throws IOException {
            this.indexFile.seek(this.indexFile.length());
            this.indexFile.writeInt(index);
            this.indexFile.seek(BEGIN_DATA);
            ++this.nIndex;
            this.indexFile.writeInt(this.nIndex);
        }

        @Override
        public void endFromEntries(int nEntries, File file) throws IOException {
        }

        @Override
        public int getSize() {
            return this.nIndex;
        }

        @Override
        public void swap(int index1, int index2) {
            int v1 = this.get(index1);
            int v2 = this.get(index2);
            try {
                this.indexFile.seek(BEGIN_ARRAY + 4 * index2);
                this.indexFile.writeInt(v1);
                this.indexFile.seek(BEGIN_ARRAY + 4 * index1);
                this.indexFile.writeInt(v2);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public int get(int index) {
            try {
                this.indexFile.seek(BEGIN_ARRAY + 4 * index);
                return this.indexFile.readInt();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class MemoryIndex
    implements IndexStorage {
        private int[] indexes;
        private int nIndex;

        private MemoryIndex() {
        }

        @Override
        public int getSize() {
            return this.indexes.length;
        }

        @Override
        public void swap(int index1, int index2) {
            int temp = this.indexes[index1];
            this.indexes[index1] = this.indexes[index2];
            this.indexes[index2] = temp;
        }

        @Override
        public int get(int index) {
            return this.indexes[index];
        }

        @Override
        public void initFromFile(File file) throws Exception {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            try {
                this.indexes = (int[])in.readObject();
                this.nIndex = this.indexes.length;
            }
            finally {
                Utils.close(in);
            }
        }

        @Override
        public void initFromEntries(int nEntries, File file) throws IOException {
            this.indexes = new int[nEntries];
            this.nIndex = 0;
        }

        @Override
        public void add(int index) throws IOException {
            this.indexes[this.nIndex] = index;
            ++this.nIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endFromEntries(int nEntries, File file) throws IOException {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(this.indexes);
            }
            catch (Throwable throwable) {
                Utils.close(out);
                throw throwable;
            }
            Utils.close(out);
        }
    }

    private static interface IndexStorage
    extends Utils.HeapSorteable {
        public void initFromFile(File var1) throws Exception;

        public void initFromEntries(int var1, File var2) throws IOException;

        public void add(int var1) throws IOException;

        public void endFromEntries(int var1, File var2) throws IOException;
    }

    private class EntryIterator
    implements Iterator<HEntry> {
        private HEntry nextEntry = this.moveNext();
        private long position = 0L;

        private HEntry moveNext() {
            HEntry result = null;
            try {
                if (this.position < IndexedFileWordMap.this.words.length()) {
                    IndexedFileWordMap.this.words.seek(this.position);
                    result = new HEntry(IndexedFileWordMap.this.words.readUTF(), IndexedFileWordMap.this.words.readUTF());
                    this.position = IndexedFileWordMap.this.words.getFilePointer();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(EntryIterator.class.getName()).log(Level.SEVERE, null, ex);
                result = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HEntry next() {
            HEntry result = this.nextEntry;
            this.nextEntry = this.moveNext();
            return result;
        }

        @Override
        public boolean hasNext() {
            return null != this.nextEntry;
        }
    }
}

