/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell.wordmaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;

public class AllLinealInMemoryWordMap
extends WordMap {
    private List<HEntry> entries;

    @Override
    public void init(long lastModificationTime, String wordMapName, String encoding) throws IOException {
    }

    @Override
    public boolean needEntries() {
        return true;
    }

    @Override
    public void beginAddEntries(int nEntries) throws IOException {
        this.entries = new ArrayList<HEntry>(nEntries);
    }

    @Override
    public void endAddEntries(int nEntries) throws IOException {
    }

    @Override
    public HEntry get(String word) {
        int index = Collections.binarySearch(this.entries, word);
        if (index >= 0) {
            return this.entries.get(index);
        }
        return null;
    }

    @Override
    public void add(HEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public void addCustomWord(String word) {
        int index = Collections.binarySearch(this.entries, word);
        if (index < 0) {
            index = -index;
            this.entries.add(index, new HEntry(word));
        }
    }

    @Override
    public Iterator<HEntry> iterator() {
        return this.entries.iterator();
    }

    private static class SimpleEntry {
        public byte[] word;
        public byte[] astr;

        private SimpleEntry() {
        }
    }
}

