/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.SuggestMgr;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.utils.FileUtils;

public class MySpell {
    public static final int NOCAP = 0;
    public static final int INITCAP = 1;
    public static final int ALLCAP = 2;
    public static final int HUHCAP = 3;
    private static final String UNKNOW_DICTIONARY_NAME = "unknow";
    private AffixMgr pAMgr;
    private WordMap pHMgr;
    private SuggestMgr pSMgr;
    private String encoding;
    private int maxSug;
    private ProgressListener listener;

    public MySpell(String zipFile, ProgressListener listener) throws IOException {
        this(new ZipFile(zipFile), listener);
    }

    public MySpell(ZipFile zipFile, ProgressListener listener) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        InputStream affStream = null;
        InputStream dStream = null;
        long lastModificationTime = 0L;
        String dicName = UNKNOW_DICTIONARY_NAME;
        this.listener = listener;
        while (entries.hasMoreElements() && (null == affStream || null == dStream)) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().endsWith(".aff")) {
                affStream = zipFile.getInputStream(entry);
                continue;
            }
            if (!entry.getName().endsWith(".dic")) continue;
            dStream = zipFile.getInputStream(entry);
            lastModificationTime = entry.getTime();
            dicName = FileUtils.extractOnlyName(entry.getName());
        }
        this.initFromStreams(affStream, dStream, lastModificationTime, dicName);
        affStream.close();
        dStream.close();
    }

    public MySpell(InputStream zipStream, ProgressListener listener) throws IOException {
        this(new ZipInputStream(zipStream), listener);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public MySpell(ZipInputStream zipStream, ProgressListener listener) throws IOException {
        void var5_13;
        void var4_8;
        ZipEntry entry = zipStream.getNextEntry();
        Object var4_4 = null;
        Object var5_9 = null;
        long lastModificationTime = 0L;
        String dicName = UNKNOW_DICTIONARY_NAME;
        this.listener = listener;
        while (null != entry) {
            block7: {
                if (entry.getName().endsWith(".aff")) {
                    void var5_10;
                    if (null == var5_10) {
                        InputStream inputStream = this.createFromZipEntry(zipStream, entry);
                        break block7;
                    } else {
                        ZipInputStream zipInputStream = zipStream;
                        break;
                    }
                }
                if (entry.getName().endsWith(".dic")) {
                    void var4_5;
                    dicName = FileUtils.extractOnlyName(entry.getName());
                    lastModificationTime = entry.getTime();
                    if (null == var4_5) {
                        InputStream inputStream = this.createFromZipEntry(zipStream, entry);
                    } else {
                        ZipInputStream zipInputStream = zipStream;
                        break;
                    }
                }
            }
            entry = zipStream.getNextEntry();
        }
        this.initFromStreams((InputStream)var4_8, (InputStream)var5_13, lastModificationTime, dicName);
    }

    public MySpell(InputStream affStream, InputStream dStream, ProgressListener listener) throws IOException {
        this.listener = listener;
        this.initFromStreams(affStream, dStream, 0L, UNKNOW_DICTIONARY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MySpell(String affpath, String dpath, ProgressListener listener) throws IOException {
        FileInputStream affStream = null;
        FileInputStream dStream = null;
        this.listener = listener;
        try {
            affStream = new FileInputStream(affpath);
            dStream = new FileInputStream(dpath);
            File dictionaryFile = new File(dpath);
            this.initFromStreams(affStream, dStream, dictionaryFile.lastModified(), FileUtils.extractOnlyName(dictionaryFile));
        }
        catch (Throwable throwable) {
            Utils.close(affStream);
            Utils.close(dStream);
            throw throwable;
        }
        Utils.close(affStream);
        Utils.close(dStream);
    }

    private InputStream createFromZipEntry(ZipInputStream zipStream, ZipEntry entry) throws IOException {
        int cReaded;
        int size = (int)entry.getSize();
        byte[] data = new byte[size];
        int current = cReaded = zipStream.read(data);
        while (cReaded > 0) {
            cReaded = zipStream.read(data, current, size - current);
            current += cReaded;
        }
        return new ByteArrayInputStream(data);
    }

    private void initFromStreams(InputStream affStream, InputStream dStream, long lastModificationTime, String wordMapName) throws IOException {
        this.encoding = AffixMgr.readEncoding(affStream);
        this.pHMgr = this.load_tables(dStream, lastModificationTime, wordMapName);
        this.pAMgr = new AffixMgr(affStream, this.encoding, this.pHMgr, this.listener);
        String try_string = this.pAMgr.get_try_string();
        this.maxSug = 15;
        this.pSMgr = new SuggestMgr(try_string, this.maxSug, this.pAMgr);
    }

    public List<String> suggest(String word) {
        return this.suggest(word, this.maxSug);
    }

    public List<String> suggest(String word, int nMax) {
        ListIterator<String> it;
        if (this.pSMgr == null) {
            return Collections.emptyList();
        }
        int[] captype = new int[1];
        boolean[] abbv = new boolean[1];
        String cw = this.cleanword(word, captype, abbv);
        int wl = cw.length();
        if (wl == 0) {
            return Collections.emptyList();
        }
        List<String> wlst = new LinkedList<String>();
        switch (captype[0]) {
            case 0: {
                wlst = this.pSMgr.suggest(wlst, cw, nMax);
                break;
            }
            case 1: {
                String wspace = cw.toLowerCase();
                this.pSMgr.suggest(wlst, wspace, nMax);
                it = wlst.listIterator();
                while (it.hasNext()) {
                    it.set(Utils.mkInitCap(it.next()));
                }
                this.pSMgr.suggest(wlst, cw, nMax);
                break;
            }
            case 3: {
                this.pSMgr.suggest(wlst, cw, nMax);
                String wspace = cw.toLowerCase();
                this.pSMgr.suggest(wlst, wspace, nMax);
                break;
            }
            case 2: {
                String wspace = cw.toLowerCase();
                this.pSMgr.suggest(wlst, wspace, nMax);
                it = wlst.listIterator();
                while (it.hasNext()) {
                    it.set(it.next().toUpperCase());
                }
                this.pSMgr.suggest(wlst, cw, nMax);
                break;
            }
        }
        if (!wlst.isEmpty()) {
            return wlst;
        }
        this.pSMgr.ngsuggest(wlst, cw, this.pHMgr, nMax);
        if (!wlst.isEmpty()) {
            switch (captype[0]) {
                case 0: {
                    break;
                }
                case 3: {
                    break;
                }
                case 1: {
                    it = wlst.listIterator();
                    while (it.hasNext()) {
                        it.set(Utils.mkInitCap(it.next()));
                    }
                    break;
                }
                case 2: {
                    it = wlst.listIterator();
                    while (it.hasNext()) {
                        it.set(it.next().toUpperCase());
                    }
                    break;
                }
            }
        }
        return wlst;
    }

    public boolean spell(String word) {
        String rv = null;
        int[] captype = new int[1];
        boolean[] abbv = new boolean[1];
        String cw = this.cleanword(word, captype, abbv);
        int wl = cw.length();
        if (wl == 0) {
            return true;
        }
        switch (captype[0]) {
            case 0: 
            case 3: {
                rv = this.check(cw);
                if (!abbv[0] || rv != null) break;
                cw = cw + '.';
                rv = this.check(cw);
                break;
            }
            case 2: {
                String wspace = cw.toLowerCase();
                rv = this.check(wspace);
                if (rv == null) {
                    rv = this.check(Utils.mkInitCap(wspace));
                }
                if (rv == null) {
                    rv = this.check(cw);
                }
                if (!abbv[0] || rv != null) break;
                wspace = cw;
                wspace = wspace + '.';
                rv = this.check(wspace);
                break;
            }
            case 1: {
                String wspace = cw.toLowerCase();
                rv = this.check(wspace);
                if (rv == null) {
                    rv = this.check(cw);
                }
                if (!abbv[0] || rv != null) break;
                wspace = cw;
                wspace = wspace + '.';
                rv = this.check(wspace);
            }
        }
        return rv != null;
    }

    public String get_dic_encoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WordMap load_tables(InputStream tStream, long lastModifiactionTime, String wordMapName) throws IOException {
        WordMap result = WordMap.create();
        result.init(lastModifiactionTime, wordMapName, this.encoding);
        if (result.needEntries()) {
            BufferedReader rawdict = null;
            try {
                rawdict = new BufferedReader(new InputStreamReader(tStream, this.encoding));
                String ts = rawdict.readLine();
                if (ts == null) {
                    throw new IOException(Utils.getString("ERROR_HASH_MANAGER_2"));
                }
                int tablesize = Integer.parseInt(ts);
                if (tablesize == 0) {
                    throw new IOException(Utils.getString("ERROR_HASH_MANAGER_4"));
                }
                result.beginAddEntries(tablesize);
                int current = 0;
                this.listener.nextStep(new ProgressEvent(this, "Cargando palabras...", current, tablesize));
                while ((ts = rawdict.readLine()) != null) {
                    result.add(new HEntry(ts.trim()));
                    this.listener.nextStep(new ProgressEvent(this, "Cargando palabras...", ++current, tablesize));
                }
                result.endAddEntries(tablesize);
            }
            catch (Throwable throwable) {
                Utils.close(rawdict);
                throw throwable;
            }
            Utils.close(rawdict);
        }
        return result;
    }

    private String cleanword(String src, int[] pcaptype, boolean[] pabbrev) {
        int nl;
        int q;
        int p = 0;
        for (q = 0; q < src.length() && !Character.isLetterOrDigit(src.charAt(q)); ++q) {
        }
        pabbrev[0] = false;
        for (nl = src.substring(q).length(); nl > 0 && !Character.isLetterOrDigit(src.charAt(q + nl - 1)); --nl) {
        }
        if (q + nl < src.length() && src.charAt(q + nl) == '.') {
            pabbrev[0] = true;
        }
        if (nl <= 0) {
            pcaptype[0] = 0;
            pabbrev[0] = false;
            return "";
        }
        int ncap = 0;
        int nneutral = 0;
        int nc = 0;
        p = q;
        while (nl > 0) {
            ++nc;
            char c = src.charAt(q);
            if (Character.isUpperCase(c)) {
                ++ncap;
            }
            if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) {
                ++nneutral;
            }
            ++q;
            --nl;
        }
        pcaptype[0] = ncap == 0 ? 0 : (ncap == 1 && Character.isUpperCase(src.charAt(p)) ? 1 : (ncap == nc || ncap + nneutral == nc ? 2 : 3));
        return src.substring(p, q);
    }

    private String check(String word) {
        HEntry he = null;
        if (this.pHMgr != null) {
            he = this.pHMgr.get(word);
        }
        if (he == null && this.pAMgr != null && (he = this.pAMgr.affix_check(word)) == null && this.pAMgr.get_compound() != null) {
            he = this.pAMgr.compound_check(word, this.pAMgr.get_compound().charAt(0));
        }
        if (he != null) {
            return he.word;
        }
        return null;
    }

    public void addCustomWord(String word) throws IOException {
        this.pHMgr.addCustomWord(word);
    }
}

