/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.dts.spell.dictionary.DictionaryProvider;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.event.ProgressListenerSupport;
import org.dts.spell.utils.LRUMap;

public class DictionaryManager {
    private static DictionaryManager instance;
    private ServiceLoader<DictionaryProvider> providers;
    private ProgressListenerSupport progressListeners;
    private LRUMap<Locale, SpellDictionary> cache = new LRUMap(4);

    private DictionaryManager() {
    }

    private ProgressListenerSupport getProgressListeters() {
        if (null == this.progressListeners) {
            this.progressListeners = new ProgressListenerSupport();
        }
        return this.progressListeners;
    }

    public DictionaryProvider[] getDictionaryProviders() {
        ArrayList<DictionaryProvider> dpList = new ArrayList<DictionaryProvider>();
        for (DictionaryProvider dp : this.getProviders()) {
            dpList.add(dp);
        }
        return dpList.toArray(new DictionaryProvider[dpList.size()]);
    }

    private ServiceLoader<DictionaryProvider> getProviders() {
        if (null == this.providers) {
            this.providers = ServiceLoader.load(DictionaryProvider.class);
        }
        return this.providers;
    }

    public static DictionaryManager get() {
        if (null == instance) {
            instance = new DictionaryManager();
        }
        return instance;
    }

    public void reloadProviders() {
        this.getProviders().reload();
    }

    public List<LocaleProvider> getInstalledLocales() {
        ArrayList<LocaleProvider> result = new ArrayList<LocaleProvider>();
        for (DictionaryProvider dp : this.getProviders()) {
            for (Locale locale : dp.getInstalledLocales()) {
                result.add(new LocaleProvider(locale, dp));
            }
        }
        return result;
    }

    public List<LocaleProvider> getAvailableLocales() {
        ArrayList<LocaleProvider> result = new ArrayList<LocaleProvider>();
        for (DictionaryProvider dp : this.getProviders()) {
            for (Locale locale : dp.getAvailableLocales()) {
                result.add(new LocaleProvider(locale, dp));
            }
        }
        return result;
    }

    public void install(LocaleProvider localeProvider) throws Exception {
        localeProvider.getProvider().install(localeProvider.getLocale(), (ProgressListener)this.getProgressListeters());
    }

    public void install(File file, DictionaryProvider provider) throws Exception {
        provider.install(file, (ProgressListener)this.getProgressListeters());
    }

    public void unistall(LocaleProvider localeProvider) throws Exception {
        localeProvider.getProvider().uninstall(localeProvider.getLocale(), this.getProgressListeters());
    }

    public boolean hasInstalledLocales() {
        for (DictionaryProvider dp : this.getProviders()) {
            if (dp.getInstalledLocales().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public <T> T getDictionaryProvider(Class<T> providerClass) {
        for (DictionaryProvider dp : this.getProviders()) {
            if (!providerClass.isInstance(dp)) continue;
            return providerClass.cast(dp);
        }
        return null;
    }

    public DictionaryProvider getDictionaryProvider(Locale locale) {
        for (DictionaryProvider dp : this.getProviders()) {
            if (!dp.isForLocale(locale)) continue;
            return dp;
        }
        return null;
    }

    public <T> T getDictionaryProvider(Class<T> providerClass, Locale locale) {
        for (DictionaryProvider dp : this.getProviders()) {
            if (!providerClass.isInstance(dp) || !dp.isForLocale(locale)) continue;
            return providerClass.cast(dp);
        }
        return null;
    }

    public SpellDictionary getDictionary(Locale locale) throws IOException {
        DictionaryProvider dp;
        SpellDictionary dictionary = (SpellDictionary)this.cache.get(locale);
        if (null == dictionary && null != (dp = this.getDictionaryProvider(locale)) && null != (dictionary = dp.getDictionary(locale))) {
            dictionary.addProgressListener(this.getProgressListeters());
            this.cache.put(locale, dictionary);
        }
        return dictionary;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void removeFromCache(Locale locale) {
        this.cache.remove(locale);
    }

    public void removeFromCache(SpellDictionary dictionary) {
        this.cache.remove(dictionary.getLocale());
    }

    public SpellDictionary getDictionary() throws IOException {
        return this.getDictionary(Locale.getDefault());
    }

    public void addProgressListener(ProgressListener listener) {
        this.getProgressListeters().addListener(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.getProgressListeters().removeListener(listener);
    }

    public static class LocaleProvider {
        private Locale locale;
        private DictionaryProvider provider;

        LocaleProvider(Locale locale, DictionaryProvider provider) {
            this.locale = locale;
            this.provider = provider;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public DictionaryProvider getProvider() {
            return this.provider;
        }
    }
}

