/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dts.spell.dictionary.DictionaryProvider;
import org.dts.spell.event.ProgressListener;
import org.dts.spell.utils.FileUtils;

public abstract class AbstractDictionaryProvider
implements DictionaryProvider {
    private URI sourceURI;
    private FileFilter fileFilter;

    public AbstractDictionaryProvider() {
        try {
            this.sourceURI = this.getDefaultDictionariesSource();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(AbstractDictionaryProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected abstract Pattern getDictionariesSourceFilesPattern();

    protected abstract Pattern getInstalledDictionariesFilesPattern();

    @Override
    public boolean isForLocale(Locale locale) {
        return this.getInstalledLocales().contains(locale);
    }

    protected FileFilter createInstalledDictionaryFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                Matcher matcher = AbstractDictionaryProvider.this.getInstalledDictionariesFilesPattern().matcher(pathname.getName());
                return matcher.find();
            }
        };
    }

    private FileFilter getInstalledDictionaryFileFilter() {
        if (null == this.fileFilter) {
            this.fileFilter = this.createInstalledDictionaryFileFilter();
        }
        return this.fileFilter;
    }

    protected Locale getLocaleForFile(File file) {
        String name = file.getName();
        Matcher matcher = this.getInstalledDictionariesFilesPattern().matcher(name);
        if (matcher.find()) {
            return this.createLocaleFrom(matcher);
        }
        return null;
    }

    protected Locale createLocaleFrom(Matcher matcher) {
        String language = matcher.group(1);
        String country = matcher.group(2);
        return new Locale(language, country);
    }

    protected File getLocalStorageDir() {
        File dictDir = FileUtils.getDictionariesDir();
        return new File(dictDir, this.getClass().getName());
    }

    protected void addLocaleFromInstalledFile(List<Locale> list, File file) {
        Locale locale = this.getLocaleForFile(file);
        if (null != locale) {
            list.add(locale);
        }
    }

    protected void addFromInstallDirectory(List<Locale> list, File dictionariesDirectory) {
        if (dictionariesDirectory.isDirectory() && dictionariesDirectory.exists()) {
            File[] files;
            for (File file : files = dictionariesDirectory.listFiles(this.getInstalledDictionaryFileFilter())) {
                this.addLocaleFromInstalledFile(list, file);
            }
        }
    }

    protected abstract URI getDefaultDictionariesSource() throws URISyntaxException;

    public void setDictionariesSource(URI uri) {
        this.sourceURI = uri;
    }

    public URI getDictionariesSource() {
        return this.sourceURI;
    }

    protected String readAsString(InputStream in, String encoding) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] chars = new char[1024];
        int nCount = reader.read(chars);
        StringWriter writer = new StringWriter();
        while (nCount > 0) {
            writer.write(chars, 0, nCount);
            nCount = reader.read(chars);
        }
        return writer.toString();
    }

    protected String getEncoding(URLConnection connection) {
        Matcher matcher;
        String encoding = connection.getContentEncoding();
        if (null == encoding && null != (encoding = connection.getHeaderField("Content-Type")) && (matcher = Pattern.compile("(charset=)(.*)").matcher(encoding)).find()) {
            encoding = matcher.group(2);
        }
        return encoding;
    }

    protected void addLocaleFromSource(List<Locale> list, Matcher matcher) {
        list.add(this.createLocaleFrom(matcher));
    }

    protected void addFromSources(List<Locale> list) {
        try {
            URL url = this.getDictionariesSource().toURL();
            URLConnection connection = url.openConnection();
            connection.connect();
            String encoding = this.getEncoding(connection);
            String html = this.readAsString(connection.getInputStream(), encoding);
            Matcher matcher = this.getDictionariesSourceFilesPattern().matcher(html);
            while (matcher.find()) {
                this.addLocaleFromSource(list, matcher);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractDictionaryProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL createLocalCopy(URL dictURL, ProgressListener listener) throws IOException {
        try (InputStream in = dictURL.openStream();){
            File dictDir = this.getLocalStorageDir();
            String file = FileUtils.extractNameAndExtension(dictURL.getFile());
            File result = new File(dictDir, file);
            FileUtils.copyStreamToFile(result, in, listener);
        }
        return dictURL;
    }

    @Override
    public List<Locale> getInstalledLocales() {
        LinkedList<Locale> result = new LinkedList<Locale>();
        this.addFromInstallDirectory(result, this.getLocalStorageDir());
        return result;
    }

    @Override
    public List<Locale> getAvailableLocales() {
        List<Locale> installed = this.getInstalledLocales();
        LinkedList<Locale> result = new LinkedList<Locale>();
        this.addFromSources(result);
        result.removeAll(installed);
        return result;
    }
}

